/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jump.task.DummyTaskMonitor;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.java2xml.XML2Java;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.Macro;
import com.vividsolutions.jump.workbench.plugin.MacroManager;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.Recordable;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openjump.core.ui.io.file.DataSourceFileLayerLoader;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class RunMacroPlugIn
extends AbstractThreadedUiPlugIn
implements MacroManager {
    private static final String P_FILE_NAME = "MacroFileName";

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.CUSTOMIZE, "Macro"}, this.getName() + "...", false, null, null, -1);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        JFileChooser jfc = new JFileChooser("lib/ext/macro");
        jfc.setFileSelectionMode(0);
        jfc.setFileFilter(this.createMacroFileFilter());
        jfc.setMultiSelectionEnabled(false);
        if (jfc.showOpenDialog(context.getActiveInternalFrame()) == 0) {
            this.addParameter(P_FILE_NAME, jfc.getSelectedFile().getPath());
            return true;
        }
        return false;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.process(monitor, context);
    }

    public void process(TaskMonitor monitor, PlugInContext context) throws Exception {
        XML2Java xml2Java = new XML2Java();
        context.getWorkbenchContext().getBlackboard().put("MacroRunning", true);
        Macro processes = (Macro)xml2Java.read(new File(this.getStringParam(P_FILE_NAME)), Macro.class);
        for (Recordable process : processes.getProcesses()) {
            System.out.println("    execute " + process.getClass());
            if (process instanceof ThreadedPlugIn) {
                ((ThreadedPlugIn)((Object)process)).run(new DummyTaskMonitor(), context);
                continue;
            }
            if (process instanceof AbstractPlugIn) {
                ((PlugIn)((Object)process)).execute(context);
                continue;
            }
            if (process instanceof DataSourceFileLayerLoader) {
                DataSourceFileLayerLoader dsLoader = (DataSourceFileLayerLoader)process;
                dsLoader.setContext(context.getWorkbenchContext());
                dsLoader.process(new DummyTaskMonitor());
                continue;
            }
            throw new Exception("");
        }
        context.getWorkbenchContext().getBlackboard().put("MacroRunning", false);
    }

    private FileFilter createMacroFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".ojm");
            }

            @Override
            public String getDescription() {
                return "OpenJUMP Macro file";
            }
        };
    }
}

