/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import java.util.Collection;
import java.util.Collections;
import org.locationtech.jts.util.Assert;

public class FeatureEvent {
    private Layer layer;
    private FeatureEventType type;
    private Collection<Feature> features;
    private Collection<Feature> oldFeatureClones;
    private Collection<Feature> oldFeatureAttClones;

    public FeatureEvent(Collection<Feature> features, FeatureEventType type, Layer layer, Collection<Feature> oldFeatureClones) {
        Assert.isTrue((layer != null ? 1 : 0) != 0);
        Assert.isTrue((type != null ? 1 : 0) != 0);
        Assert.isTrue((type == FeatureEventType.GEOMETRY_MODIFIED && oldFeatureClones != null || type != FeatureEventType.GEOMETRY_MODIFIED && oldFeatureClones == null || type == FeatureEventType.ATTRIBUTES_MODIFIED && this.oldFeatureAttClones == null ? 1 : 0) != 0);
        this.layer = layer;
        this.type = type;
        this.features = features;
        if (this.type == FeatureEventType.GEOMETRY_MODIFIED) {
            this.oldFeatureClones = oldFeatureClones;
        } else if (this.type == FeatureEventType.ATTRIBUTES_MODIFIED) {
            this.oldFeatureAttClones = oldFeatureClones;
        }
    }

    public Layer getLayer() {
        return this.layer;
    }

    public FeatureEventType getType() {
        return this.type;
    }

    public Collection<Feature> getFeatures() {
        return Collections.unmodifiableCollection(this.features);
    }

    public Collection<Feature> getOldFeatureClones() {
        return Collections.unmodifiableCollection(this.oldFeatureClones);
    }

    public Collection getOldFeatureAttClones() {
        return Collections.unmodifiableCollection(this.oldFeatureAttClones);
    }
}

