/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.openjpeg;

import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.openjpeg.OpenJpegImage;
import com.vividsolutions.jump.workbench.model.Prioritized;
import de.digitalcollections.openjpeg.imageio.OpenJp2ImageReaderSpi;
import java.io.IOException;
import javax.imageio.ImageReader;

public class OpenJpegImageFactory
implements ReferencedImageFactory,
Prioritized {
    static final String TYPE_NAME = "JPEG2000";
    static final String DESCRIPTION = "JPEG 2000 (via openjpeg and imageio-jnr)";
    static final String[] EXTENSIONS = new String[]{"jp2", "j2k", "j2c", "jpc", "jpx", "jpf"};
    static final String sNotInstalled = "OpenJpeg JP2 driver is not installed";
    private static Boolean available = null;

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public ReferencedImage createImage(String location) throws Exception {
        return new OpenJpegImage(location);
    }

    @Override
    public boolean isEditableImage(String location) {
        return false;
    }

    @Override
    public boolean isAvailable(WorkbenchContext context) {
        if (available != null) {
            return available;
        }
        available = this._isAvailable(context);
        if (!available.booleanValue()) {
            Logger.info("OpenJpeg loader will be unavailable.");
        }
        return available;
    }

    private boolean _isAvailable(WorkbenchContext context) {
        try {
            ImageReader reader = new OpenJp2ImageReaderSpi().createReaderInstance();
            return reader != null;
        }
        catch (IOException exception) {
            Logger.error(exception);
            return false;
        }
    }
}

