/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.mrsid;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.mrsid.MrSIDReferencedImage;
import com.vividsolutions.jump.workbench.imagery.mrsid.SIDInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import org.openjump.core.CheckOS;
import org.openjump.util.UriUtil;

public class MrSIDImageFactory
implements ReferencedImageFactory {
    public static final String MRSIDDECODE = "mrsidgeodecode";
    public static final String MRSIDINFO = "mrsidgeoinfo";
    private static HashMap<String, String> binariesAvailable = new HashMap();
    static final String sNotInstalled = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn.not-installed");
    static final String sErrorSeeOutputWindow = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn.Error-See-Output-Window");

    @Override
    public String getTypeName() {
        return "MrSID";
    }

    @Override
    public ReferencedImage createImage(String location) throws Exception {
        URI uri = new URI(location);
        if (CompressedFile.isArchive(uri) || CompressedFile.isCompressed(uri)) {
            throw new JUMPException("Compressed files not supported for this format.");
        }
        String filepath = new File(UriUtil.getFilePath(uri)).getAbsolutePath();
        return new MrSIDReferencedImage(SIDInfo.readInfo(filepath), filepath);
    }

    @Override
    public String getDescription() {
        return this.getTypeName();
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"sid"};
    }

    @Override
    public boolean isEditableImage(String location) {
        return false;
    }

    @Override
    public boolean isAvailable(WorkbenchContext context) {
        String msg = this.which(MRSIDDECODE);
        if (msg != "") {
            context.getWorkbench().getFrame().log("mrsidgeodecode " + sNotInstalled + " - " + msg, this.getClass());
            return false;
        }
        msg = this.which(MRSIDINFO);
        if (msg != "") {
            context.getWorkbench().getFrame().log("mrsidgeoinfo " + sNotInstalled + " - " + msg, this.getClass());
            return false;
        }
        Logger.info("found Mrsid binaries in path");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String which(String filename) {
        String[] runStr;
        if (binariesAvailable.containsKey(filename)) {
            return binariesAvailable.get(filename);
        }
        if (CheckOS.isLinux()) {
            runStr = new String[]{"which", filename};
        } else {
            if (!CheckOS.isWindows()) return "os not supported.";
            runStr = new String[]{"cmd", "/C", "@for %i in (" + filename + ".exe) do @if NOT \"%~$PATH:i\"==\"\" echo %~$PATH:i"};
        }
        Process p = null;
        BufferedReader in = null;
        try {
            p = Runtime.getRuntime().exec(runStr);
            p.waitFor();
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = in.readLine();
            if (line != null && !line.trim().isEmpty()) {
                binariesAvailable.put(filename, "");
                String string = "";
                return string;
            }
            binariesAvailable.put(filename, filename + " not in path");
            String string = filename + " not in path";
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = e.getMessage();
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (p != null) {
                    p.destroy();
                }
            }
        }
    }
}

