/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.graphic;

import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.graphic.AbstractGraphicImageFactory;
import com.vividsolutions.jump.workbench.imagery.graphic.CommonsImage;
import com.vividsolutions.jump.workbench.imagery.graphic.CommonsTIFFImage;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.io.FilenameUtils;
import org.openjump.util.UriUtil;

public class CommonsImageFactory
extends AbstractGraphicImageFactory {
    @Override
    public String getTypeName() {
        return "Commons Imaging";
    }

    @Override
    public ReferencedImage createImage(String location) {
        try {
            ByteSource byteSource = ByteSource.inputStream((InputStream)CompressedFile.openFile(location), (String)UriUtil.getFileName(location));
            ImageFormat format = Imaging.guessFormat((ByteSource)byteSource);
            if (format.equals(ImageFormats.TIFF)) {
                return new CommonsTIFFImage(location, null);
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
        String ext = FilenameUtils.getExtension((String)location).toLowerCase();
        if (ext.matches("tiff?")) {
            return new CommonsTIFFImage(location, null);
        }
        return new CommonsImage(location, null);
    }

    @Override
    public boolean isAvailable(WorkbenchContext context) {
        Class<?> c = null;
        try {
            c = this.getClass().getClassLoader().loadClass("org.apache.commons.imaging.Imaging");
            if (c == null) {
                return false;
            }
            for (ImageFormats fmt : ImageFormats.values()) {
                if (fmt.getName().equalsIgnoreCase("unknown")) continue;
                this.addExtensions(Arrays.asList(fmt.getExtensions()));
            }
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

