/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.ecw;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.ecw.ECWImage;
import com.vividsolutions.jump.workbench.imagery.ecw.ECWLoadException;
import com.vividsolutions.jump.workbench.imagery.ecw.JNCSRendererProxy;
import java.io.File;
import java.net.URI;
import java.nio.charset.StandardCharsets;

public class ECWImageFactory
implements ReferencedImageFactory {
    private static final String TYPE_NAME = "ECW";
    private static final String DESCRIPTION = "Enhanced Compressed Wavelet (via ecw3.3)";
    private static final String[] EXTENSIONS = new String[]{"ecw"};
    static final String sNotInstalled = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.AddSIDLayerPlugIn.not-installed");
    private static Boolean available = null;

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public ReferencedImage createImage(String location) throws Exception {
        URI uri = new URI(location);
        if (CompressedFile.isArchive(uri) || CompressedFile.isCompressed(uri)) {
            throw new JUMPException("Compressed files not supported for this format.");
        }
        String filepath = new File(uri).getCanonicalPath();
        if (!StandardCharsets.US_ASCII.newEncoder().canEncode(filepath)) {
            String hint = filepath.replaceAll("[^\\u0000-\\u007F]", "?");
            throw new ECWLoadException(I18N.getInstance().get("com.vividsolutions.jump.workbench.imagery.ecw.path-contains-nonansi-chars", hint));
        }
        return new ECWImage(filepath);
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public boolean isEditableImage(String location) {
        return false;
    }

    @Override
    public boolean isAvailable(WorkbenchContext context) {
        if (available != null) {
            return available;
        }
        available = this._isAvailable(context);
        if (!available.booleanValue()) {
            Logger.info("ECW/JP2 SDK loader will be unavailable.");
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _isAvailable(WorkbenchContext context) {
        Class<?> c = null;
        try {
            c = this.getClass().getClassLoader().loadClass(JNCSRendererProxy.RENDERER_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (c == null) {
                context.getWorkbench().getFrame().log("ECW/JP2 loader class " + JNCSRendererProxy.RENDERER_CLASS + " " + sNotInstalled, this.getClass());
                return false;
            }
        }
        finally {
            if (c == null) {
                context.getWorkbench().getFrame().log("ECW/JP2 loader class " + JNCSRendererProxy.RENDERER_CLASS + " " + sNotInstalled, this.getClass());
                return false;
            }
        }
        try {
            System.loadLibrary("jecw");
        }
        catch (Error e) {
            Logger.error("ECW/JP2 native libs " + sNotInstalled + " reason: " + e.getMessage());
            Logger.debug(e);
            return false;
        }
        Logger.info("ECW/JP2 native support loaded.");
        return true;
    }
}

