/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.Logger;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.locationtech.jts.util.Assert;

public class FlexibleDateParser {
    private static List<SimpleDateFormat> lenientFormatters = null;
    private static List<SimpleDateFormat> unlenientFormatters = null;
    private LinkedList<SimpleDateFormat> formattersCache = null;
    private boolean verbose = false;

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public void cachingEnabled(boolean onOff) {
        if (!onOff && this.formattersCache != null) {
            this.formattersCache = null;
        } else if (onOff && this.formattersCache == null) {
            this.formattersCache = new LinkedList();
        }
    }

    public Date parse(String s, boolean lenient) throws ParseException {
        if (s.trim().length() == 0) {
            return null;
        }
        try {
            return this.parse(s, this.unlenientFormatters());
        }
        catch (ParseException e) {
            if (lenient) {
                return this.parse(s, this.lenientFormatters());
            }
            throw e;
        }
    }

    private static Collection<DatePattern> sortByComplexity(Collection<DatePattern> patterns) {
        TreeSet<DatePattern> sortedPatterns = new TreeSet<DatePattern>(new Comparator<DatePattern>(){
            private TreeSet<String> uniqueCharacters = new TreeSet();

            @Override
            public int compare(DatePattern o1, DatePattern o2) {
                int result = this.complexity(o1.pattern) - this.complexity(o2.pattern);
                if (result == 0) {
                    result = o1.index - o2.index;
                }
                return result;
            }

            private int complexity(String pattern) {
                this.uniqueCharacters.clear();
                for (int i = 0; i < pattern.length(); ++i) {
                    if (("" + pattern.charAt(i)).trim().length() <= 0) continue;
                    this.uniqueCharacters.add("" + pattern.charAt(i));
                }
                return this.uniqueCharacters.size();
            }
        });
        sortedPatterns.addAll(patterns);
        return sortedPatterns;
    }

    private List<SimpleDateFormat> lenientFormatters() {
        if (lenientFormatters == null) {
            FlexibleDateParser.load();
        }
        return lenientFormatters;
    }

    private List<SimpleDateFormat> unlenientFormatters() {
        if (unlenientFormatters == null) {
            FlexibleDateParser.load();
        }
        return unlenientFormatters;
    }

    private Date parse(String s, List<SimpleDateFormat> formatters) throws ParseException {
        ParseException firstParseException = null;
        int i = 0;
        for (SimpleDateFormat formatter : new CompositeList<SimpleDateFormat>(this.formattersCache, formatters)) {
            ++i;
            if (this.verbose || Logger.isTraceEnabled()) {
                String msg = s + " -- #" + i + ". " + formatter.toPattern() + (formatter.isLenient() ? "lenient" : "");
                if (this.verbose) {
                    System.out.println(msg);
                }
                Logger.trace(msg);
            }
            try {
                int pos;
                Date d = this.parse(s, formatter);
                if (this.formattersCache != null && (pos = this.formattersCache.indexOf(formatter)) != 0) {
                    this.formattersCache.removeAll(Collections.singleton(formatter));
                    this.formattersCache.addFirst(formatter);
                }
                return d;
            }
            catch (ParseException e) {
                if (firstParseException != null) continue;
                firstParseException = e;
            }
        }
        throw firstParseException;
    }

    private Date parse(String s, SimpleDateFormat formatter) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Date date = formatter.parse(s, pos);
        if (pos.getIndex() == 0) {
            throw new ParseException("Unparseable date: \"" + s + "\"", pos.getErrorIndex());
        }
        if (pos.getIndex() != s.length()) {
            throw new ParseException("Unparseable date: \"" + s + "\"", pos.getErrorIndex());
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (calendar.get(1) == 1970 && !s.contains("70")) {
            calendar.set(1, Calendar.getInstance().get(1));
        }
        return calendar.getTime();
    }

    public static void setLocale(Locale locale) {
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(locale);
        lenientFormatters = null;
        unlenientFormatters = null;
        FlexibleDateParser.load();
        Locale.setDefault(defaultLocale);
    }

    private static void load() {
        if (lenientFormatters == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("language/jump");
            try (InputStream inputStream = FlexibleDateParser.class.getResourceAsStream(resourceBundle.getString("com.vividsolutions.jump.util.FlexibleDateParser"));){
                ArrayList<DatePattern> patterns = new ArrayList<DatePattern>();
                int index = 0;
                for (String line : FileUtil.getContents(inputStream)) {
                    if (line.trim().length() <= 0 || line.startsWith("#")) continue;
                    patterns.add(new DatePattern(line, index));
                    ++index;
                }
                unlenientFormatters = Collections.unmodifiableList(FlexibleDateParser.toFormatters(false, patterns));
                lenientFormatters = Collections.unmodifiableList(FlexibleDateParser.toFormatters(true, patterns));
            }
            catch (IOException e) {
                Assert.shouldNeverReachHere((String)e.toString());
            }
        }
    }

    private static List<SimpleDateFormat> toFormatters(boolean lenient, Collection<DatePattern> patterns) {
        ArrayList<SimpleDateFormat> formatters = new ArrayList<SimpleDateFormat>();
        for (DatePattern pattern : FlexibleDateParser.sortByComplexity(patterns)) {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern.pattern);
            formatter.setLenient(lenient);
            formatters.add(formatter);
        }
        return formatters;
    }

    public static void main(String[] args) throws Exception {
        FlexibleDateParser fdp = new FlexibleDateParser();
        fdp.setVerbose(true);
        System.out.println(fdp.parse("2019/02/17 22:44:35.325+02", true));
    }

    private static class DatePattern {
        private String pattern;
        private int index;

        public DatePattern(String pattern, int index) {
            this.pattern = pattern;
            this.index = index;
        }

        public String toString() {
            return this.pattern;
        }
    }

    private class CompositeList<E>
    extends AbstractList<E> {
        private final List<E> list1;
        private final List<E> list2;

        public CompositeList(List<E> list1, List<E> list2) {
            List empty = Collections.emptyList();
            this.list1 = list1 == null ? empty : list1;
            this.list2 = list2 == null ? empty : list2;
        }

        @Override
        public E get(int index) {
            if (index < this.list1.size()) {
                return this.list1.get(index);
            }
            return this.list2.get(index - this.list1.size());
        }

        @Override
        public int size() {
            return this.list1.size() + this.list2.size();
        }
    }

    public static final class CellRenderer
    extends DefaultTableCellRenderer {
        DateFormat formatter = DateFormat.getDateTimeInstance();

        @Override
        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateTimeInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static final class CellEditor
    extends DefaultCellEditor {
        private Object value;
        DateFormat formatter;
        private FlexibleDateParser flexParser = new FlexibleDateParser();

        public CellEditor(DateFormat formatter) {
            super(new JTextField());
            this.formatter = formatter;
        }

        @Override
        public boolean stopCellEditing() {
            String newValue = (String)super.getCellEditorValue();
            try {
                if (newValue == null || newValue.isEmpty()) {
                    this.value = null;
                } else {
                    try {
                        this.value = this.formatter.parse(newValue);
                    }
                    catch (ParseException e1) {
                        this.value = this.flexParser.parse(newValue, true);
                    }
                }
            }
            catch (Exception e) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            return super.getTableCellEditorComponent(table, this.format(value), isSelected, row, column);
        }

        private String format(Object date) {
            if (date == null || date.toString().isEmpty()) {
                return "";
            }
            if (date instanceof Date) {
                return this.formatter.format(date);
            }
            return date.toString();
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }
}

