/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.qa.diff.UnmatchedEdgeExtracter;
import com.vividsolutions.jump.task.TaskMonitor;
import java.util.ArrayList;
import org.locationtech.jts.geom.Geometry;

public class DiffSegments {
    private FeatureCollection[] fc = new FeatureCollection[2];
    private UnmatchedEdgeExtracter[] uee = new UnmatchedEdgeExtracter[2];
    private TaskMonitor monitor;

    public DiffSegments(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    public void setSegments(int index, FeatureCollection fc) {
        this.fc[index] = fc;
        this.uee[index] = new UnmatchedEdgeExtracter();
        for (Feature feature : fc.getFeatures()) {
            this.uee[index].add(feature.getGeometry());
        }
    }

    public FeatureCollection computeDiffEdges(int index) {
        ArrayList<Geometry> diffEdges = new ArrayList<Geometry>();
        UnmatchedEdgeExtracter otherUee = this.uee[1 - index];
        for (Feature feature : this.fc[index].getFeatures()) {
            otherUee.getDiffEdges(feature.getGeometry(), diffEdges);
        }
        return FeatureDatasetFactory.createFromGeometry(diffEdges);
    }
}

