/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.plugin.edit.SegmentStringData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.locationtech.jts.operation.linemerge.LineSequencer;

public class SegmentStringsWithData2Features {
    private SegmentStringsWithData2Features() {
    }

    public static Geometry buildGeometry(Geometry source, Map<Integer, Map<Integer, List<SegmentString>>> nodedSegmentStrings, boolean interpolate_z, int interpolated_z_dp, GeometryFactory gf) {
        Geometry[] finalComponents = new Geometry[nodedSegmentStrings.size()];
        for (int i = 0; i < finalComponents.length; ++i) {
            Geometry sourceComponent = source.getGeometryN(i);
            Map<Integer, List<SegmentString>> lines = nodedSegmentStrings.get(i);
            if (sourceComponent instanceof LineString) {
                finalComponents[i] = SegmentStringsWithData2Features.merge(lines.get(0), gf, false);
                SegmentStringsWithData2Features.restoreZ(lines.get(0), (LineString)sourceComponent, gf);
                if (!interpolate_z) continue;
                SegmentStringsWithData2Features.interpolate(lines.get(0), (LineString)finalComponents[i], interpolated_z_dp);
                continue;
            }
            if (!(sourceComponent instanceof Polygon)) continue;
            LinearRing exteriorRing = (LinearRing)SegmentStringsWithData2Features.merge(lines.get(0), gf, true);
            SegmentStringsWithData2Features.restoreZ(lines.get(0), (LineString)((Polygon)sourceComponent).getExteriorRing(), gf);
            if (interpolate_z) {
                SegmentStringsWithData2Features.interpolate(lines.get(0), (LineString)exteriorRing, interpolated_z_dp);
            }
            Coordinate[] array = exteriorRing.getCoordinates();
            CoordinateArrays.scroll((Coordinate[])exteriorRing.getCoordinates(), (Coordinate)((Polygon)sourceComponent).getExteriorRing().getCoordinateN(0));
            exteriorRing = gf.createLinearRing(array);
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            for (int j = 0; j < lines.size() - 1; ++j) {
                LinearRing hole = (LinearRing)SegmentStringsWithData2Features.merge(lines.get(j + 1), gf, true);
                SegmentStringsWithData2Features.restoreZ(lines.get(j + 1), (LineString)((Polygon)sourceComponent).getInteriorRingN(j), gf);
                if (hole.isEmpty()) continue;
                if (interpolate_z) {
                    SegmentStringsWithData2Features.interpolate(lines.get(j + 1), (LineString)hole, interpolated_z_dp);
                }
                array = hole.getCoordinates();
                CoordinateArrays.scroll((Coordinate[])exteriorRing.getCoordinates(), (Coordinate)((Polygon)sourceComponent).getExteriorRing().getCoordinateN(0));
                hole = gf.createLinearRing(array);
                holes.add(hole);
            }
            finalComponents[i] = source.getFactory().createPolygon(exteriorRing, holes.toArray(new LinearRing[holes.size()]));
        }
        return source.getFactory().buildGeometry(Arrays.asList(finalComponents));
    }

    private static LineString merge(List<SegmentString> list, GeometryFactory gf, boolean close) {
        LineMerger lineMerger = new LineMerger();
        for (SegmentString ss : list) {
            if (ss.size() <= 1) continue;
            lineMerger.add((Geometry)gf.createLineString(ss.getCoordinates()));
        }
        Collection lineStrings = lineMerger.getMergedLineStrings();
        LineSequencer sequencer = new LineSequencer();
        sequencer.add(lineStrings);
        LineString ls = gf.createLineString(sequencer.getSequencedLineStrings().getCoordinates());
        if (close) {
            CoordinateList coords = new CoordinateList(ls.getCoordinates());
            coords.closeRing();
            if (ls.getNumPoints() < 4) {
                return gf.createLinearRing(new Coordinate[0]);
            }
            return gf.createLinearRing(coords.toCoordinateArray());
        }
        return ls;
    }

    private static void restoreZ(List<SegmentString> list, LineString g, GeometryFactory gf) {
        HashMap<Coordinate, Coordinate> map = new HashMap<Coordinate, Coordinate>();
        for (Coordinate c : g.getCoordinates()) {
            c = (Coordinate)c.clone();
            gf.getPrecisionModel().makePrecise(c);
            map.put(c, c);
        }
        for (SegmentString ss : list) {
            Coordinate c;
            Coordinate[] cc = ss.getCoordinates();
            c = (Coordinate)map.get(cc[0]);
            cc[0].z = null != c ? c.z : Double.NaN;
            c = (Coordinate)map.get(cc[cc.length - 1]);
            if (null != c) {
                cc[cc.length - 1].z = c.z;
                continue;
            }
            cc[cc.length - 1].z = Double.NaN;
        }
    }

    private static void interpolate(List<SegmentString> list, LineString g, int interpolated_z_dp) {
        for (SegmentString ss : list) {
            Coordinate[] cc = ss.getCoordinates();
            if (Double.isNaN(cc[0].z)) {
                cc[0].z = SegmentStringsWithData2Features.interpolate(cc[0], g, interpolated_z_dp);
            }
            if (!Double.isNaN(cc[cc.length - 1].z)) continue;
            cc[cc.length - 1].z = SegmentStringsWithData2Features.interpolate(cc[cc.length - 1], g, interpolated_z_dp);
        }
    }

    private static double round(double d, int dp) {
        double scale = 1.0;
        for (int i = 0; i < dp; ++i) {
            scale *= 10.0;
        }
        return Math.rint(d * scale) / scale;
    }

    private static double[] nextPointWithZ(int index, LineString line) {
        int i;
        double dist = 0.0;
        Coordinate[] cc = line.getCoordinates();
        for (i = index + 1; i < cc.length; ++i) {
            dist += cc[i].distance(cc[i - 1]);
            if (Double.isNaN(cc[i].z)) continue;
            return new double[]{cc[i].z, dist};
        }
        if (line.isClosed()) {
            for (i = 1; i < index; ++i) {
                dist += cc[i].distance(cc[i - 1]);
                if (Double.isNaN(cc[i].z)) continue;
                return new double[]{cc[i].z, dist};
            }
        }
        return null;
    }

    private static double[] previousPointWithZ(int index, LineString line) {
        int i;
        double dist = 0.0;
        Coordinate[] cc = line.getCoordinates();
        for (i = index - 1; i >= 0; --i) {
            dist += cc[i].distance(cc[i + 1]);
            if (Double.isNaN(cc[i].z)) continue;
            return new double[]{cc[i].z, dist};
        }
        if (line.isClosed()) {
            for (i = cc.length - 2; i > index; --i) {
                dist += cc[i].distance(cc[i + 1]);
                if (Double.isNaN(cc[i].z)) continue;
                return new double[]{cc[i].z, dist};
            }
        }
        return null;
    }

    private static double interpolate(Coordinate c, LineString line, int dp) {
        int index = -1;
        for (int i = 0; i < line.getNumPoints(); ++i) {
            if (!line.getCoordinateN(i).equals((Object)c)) continue;
            index = i;
            break;
        }
        if (index > -1) {
            double[] previous = SegmentStringsWithData2Features.previousPointWithZ(index, line);
            double[] next = SegmentStringsWithData2Features.nextPointWithZ(index, line);
            if (previous != null && next != null) {
                double pZ = previous[0];
                double nZ = next[0];
                double pD = previous[1];
                double nD = next[1];
                double interpolated = pZ + (nZ - pZ) * (pD / (pD + nD));
                return SegmentStringsWithData2Features.round(interpolated, dp);
            }
        }
        return c.z;
    }

    public static Map<Feature, Map<Integer, Map<Integer, List<SegmentString>>>> getFeature2SegmentStringTreeMap(Collection nodedSubstring) {
        HashMap<Feature, Map<Integer, Map<Integer, List<SegmentString>>>> geomStructureMap = new HashMap<Feature, Map<Integer, Map<Integer, List<SegmentString>>>>();
        for (Object line : nodedSubstring) {
            ArrayList<SegmentString> ssl;
            HashMap linearElements;
            SegmentString ss = (SegmentString)line;
            SegmentStringData metadata = (SegmentStringData)ss.getData();
            Feature feature = metadata.getFeature();
            int component = metadata.getComponent();
            int linearElement = metadata.getLinearElement();
            HashMap components = (HashMap)geomStructureMap.get(feature);
            if (components == null) {
                components = new HashMap(1);
                linearElements = new HashMap(1);
                ssl = new ArrayList<SegmentString>(2);
                ssl.add(ss);
                linearElements.put(linearElement, ssl);
                components.put(component, linearElements);
                geomStructureMap.put(feature, components);
                continue;
            }
            linearElements = (HashMap)components.get(component);
            if (linearElements == null) {
                linearElements = new HashMap(1);
                ssl = new ArrayList(2);
                ssl.add(ss);
                linearElements.put(linearElement, ssl);
                components.put(component, linearElements);
                continue;
            }
            ssl = (ArrayList<SegmentString>)linearElements.get(linearElement);
            if (ssl == null) {
                ssl = new ArrayList(2);
            }
            ssl.add(ss);
            linearElements.put(linearElement, ssl);
        }
        return geomStructureMap;
    }
}

