/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jump.feature.Feature;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;

public class SegmentStringData {
    private Feature feature;
    private int component;
    private int linearElement;

    public SegmentStringData(Feature feature, int component, int linearElement) {
        this.feature = feature;
        this.component = component;
        this.linearElement = linearElement;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public int getComponent() {
        return this.component;
    }

    public int getLinearElement() {
        return this.linearElement;
    }

    public LineString getSourceLineString() {
        Geometry source = this.feature.getGeometry();
        Geometry sourceComponent = source.getGeometryN(this.component);
        if (sourceComponent instanceof Polygon) {
            if (this.linearElement == 0) {
                return ((Polygon)sourceComponent).getExteriorRing();
            }
            return ((Polygon)sourceComponent).getInteriorRingN(this.linearElement - 1);
        }
        return (LineString)sourceComponent;
    }

    public String toString() {
        return "FID=" + this.feature.getID() + " Component=" + this.component + " LinearElement=" + this.linearElement;
    }
}

