/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class LineNoderPlugIn
extends AbstractThreadedUiPlugIn {
    private static final String SRC_LAYER = I18N.getInstance().get("jump.plugin.edit.LineNoderPlugIn.Line-Layer");
    private static final String SELECTED_ONLY = GenericNames.USE_SELECTED_FEATURES_ONLY;
    private boolean useSelected = false;
    private String layerName;
    private GeometryFactory fact = new GeometryFactory();

    @Override
    public String getName() {
        return I18N.getInstance().get("jump.plugin.edit.LineNoderPlugIn.Node-Lines");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.getName() + "...", false, null, this.createEnableCheck(context.getWorkbenchContext()), -1);
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        monitor.report(I18N.getInstance().get("jump.plugin.edit.LineNoderPlugIn.Noding"));
        Layer layer = context.getLayerManager().getLayer(this.layerName);
        Collection<Feature> inputFeatures = this.getFeaturesToProcess(layer, context);
        Collection<LineString> lines = this.getLines(inputFeatures);
        monitor.report(I18N.getInstance().get("jump.plugin.edit.LineNoderPlugIn.Noding-input-lines"));
        Geometry nodedGeom = this.nodeLines(lines);
        List nodedLines = LineNoderPlugIn.toLines(nodedGeom);
        if (monitor.isCancelRequested()) {
            return;
        }
        this.createLayer(context, nodedLines);
    }

    private Collection<Feature> getFeaturesToProcess(Layer lyr, PlugInContext context) {
        if (this.useSelected) {
            return context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(lyr);
        }
        return lyr.getFeatureCollectionWrapper().getFeatures();
    }

    private Collection<LineString> getLines(Collection<Feature> inputFeatures) {
        ArrayList<LineString> linesList = new ArrayList<LineString>();
        LinearComponentExtracter lineFilter = new LinearComponentExtracter(linesList);
        Iterator<Feature> iterator = inputFeatures.iterator();
        while (iterator.hasNext()) {
            Feature obj;
            Feature f = obj = iterator.next();
            Geometry g = f.getGeometry();
            g.apply((GeometryComponentFilter)lineFilter);
        }
        return linesList;
    }

    private Geometry nodeLines(Collection<LineString> lines) {
        MultiLineString linesGeom = this.fact.createMultiLineString(GeometryFactory.toLineStringArray(lines));
        MultiLineString unionInput = this.fact.createMultiLineString(null);
        Geometry minLine = this.extractPoint(lines);
        if (minLine != null) {
            unionInput = minLine;
        }
        return linesGeom.union((Geometry)unionInput);
    }

    private static List toLines(Geometry geom) {
        ArrayList linesList = new ArrayList();
        LinearComponentExtracter lineFilter = new LinearComponentExtracter(linesList);
        geom.apply((GeometryComponentFilter)lineFilter);
        return linesList;
    }

    private Geometry extractPoint(Collection<LineString> lines) {
        Point point = null;
        for (LineString lineString : lines) {
            if (lineString.isEmpty()) continue;
            Coordinate p = lineString.getCoordinate();
            point = lineString.getFactory().createPoint(p);
        }
        return point;
    }

    private void createLayer(PlugInContext context, Collection nodedLines) throws Exception {
        FeatureCollection polyFC = FeatureDatasetFactory.createFromGeometry(nodedLines);
        context.addLayer(StandardCategoryNames.RESULT, this.layerName + " " + I18N.getInstance().get("jump.plugin.edit.LineNoderPlugIn.Noded-Lines"), polyFC);
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarImage(new ImageIcon(this.getClass().getResource("Polygonize.png")));
        dialog.setSideBarDescription(I18N.getInstance().get("jump.plugin.edit.LineNoderPlugIn.Nodes-the-lines-in-a-layer"));
        dialog.addLayerComboBox(SRC_LAYER, context.getCandidateLayer(0), null, context.getLayerManager());
        dialog.addCheckBox(SELECTED_ONLY, this.useSelected);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        Layer layer = dialog.getLayer(SRC_LAYER);
        this.layerName = layer.getName();
        this.useSelected = dialog.getBoolean(SELECTED_ONLY);
    }
}

