/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.JUMPWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class WKTWriter
implements JUMPWriter {
    private org.locationtech.jts.io.WKTWriter wktWriter = new org.locationtech.jts.io.WKTWriter(3);

    @Override
    public void write(FeatureCollection featureCollection, DriverProperties dp) throws Exception {
        String outputFname = dp.getProperty("File");
        if (outputFname == null) {
            outputFname = dp.getProperty(DriverProperties.DEFAULT_VALUE_KEY);
        }
        if (outputFname == null) {
            throw new IllegalParametersException("call to WKTWrite.write() has DataProperties w/o a OutputFile specified");
        }
        FileWriter writer = new FileWriter(outputFname);
        this.write(featureCollection, writer);
        ((Writer)writer).close();
    }

    public void write(FeatureCollection featureCollection, Writer writer) throws IOException {
        Iterator<Feature> i = featureCollection.iterator();
        while (i.hasNext()) {
            Feature feature = i.next();
            this.wktWriter.writeFormatted(feature.getGeometry(), writer);
            if (!i.hasNext()) continue;
            writer.write("\n\n");
        }
    }
}

