/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.AbstractJUMPReader;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.workbench.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.dbffile.DbfFile;
import org.geotools.shapefile.Shapefile;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;

public class ShapefileReader
extends AbstractJUMPReader {
    private File delete_this_tmp_dbf = null;
    private File delete_this_tmp_shx = null;
    private File delete_this_tmp_cpg = null;
    private static final Pattern CODE_PAGE = Pattern.compile(".*?(\\d\\d\\d++)");

    @Override
    public FeatureCollection read(DriverProperties dp) throws Exception {
        this.getExceptions().clear();
        String shpFileName = dp.getProperty("File");
        if (shpFileName == null) {
            shpFileName = dp.getProperty(DriverProperties.DEFAULT_VALUE_KEY);
        }
        if (shpFileName == null) {
            throw new IllegalParametersException(I18N.getInstance().get("io.ShapefileReader.no-file-property-specified"));
        }
        Shapefile myshape = this.getShapefile(shpFileName, dp.getProperty("CompressedFile"));
        myshape.setTaskMonitor(this.getTaskMonitor());
        String charsetName = this.getCharset(shpFileName, dp);
        DbfFile mydbf = this.getDbfFile(shpFileName, dp.getProperty("CompressedFile"), Charset.forName(charsetName));
        try {
            FeatureDataset featureDataset;
            block24: {
                InputStream shx = this.getShx(shpFileName, dp.getProperty("CompressedFile"));
                try {
                    FeatureDataset featureCollection;
                    GeometryFactory factory = new GeometryFactory();
                    GeometryCollection collection = shx == null ? myshape.read(factory) : myshape.readFromIndex(factory, shx);
                    FeatureSchema fs = new FeatureSchema();
                    fs.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
                    if (mydbf == null) {
                        featureCollection = new FeatureDataset(fs);
                        int numGeometries = collection.getNumGeometries();
                        for (int x = 0; x < numGeometries; ++x) {
                            BasicFeature feature = new BasicFeature(fs);
                            Geometry geo = collection.getGeometryN(x);
                            feature.setGeometry(geo);
                            featureCollection.add(feature);
                        }
                    } else {
                        Geometry geo;
                        BasicFeature feature;
                        int numfields = mydbf.getNumFields();
                        for (int j = 0; j < numfields; ++j) {
                            AttributeType type = AttributeType.toAttributeType(mydbf.getFieldType(j));
                            fs.addAttribute(mydbf.getFieldName(j), type);
                        }
                        featureCollection = new FeatureDataset(fs);
                        for (int x = 0; x < Math.min(mydbf.getLastRec(), collection.getNumGeometries()); ++x) {
                            byte[] s = mydbf.GetDbfRec(x);
                            if (s[0] == 42 && System.getProperty("dbf.deleted.on") == null) {
                                Logger.debug("Skip deleted dbf record " + x);
                                continue;
                            }
                            feature = new BasicFeature(fs);
                            geo = collection.getGeometryN(x);
                            for (int y = 0; y < numfields; ++y) {
                                feature.setAttribute(y + 1, mydbf.ParseRecordColumn(s, y));
                            }
                            feature.setGeometry(geo);
                            featureCollection.add(feature);
                        }
                        if (collection.getNumGeometries() > mydbf.getLastRec()) {
                            String message = I18N.getInstance().get("com.vividsolutions.jump.io.ShapefileReader.shp-gt-dbf", shpFileName, collection.getNumGeometries(), mydbf.getLastRec());
                            Logger.error(message);
                            this.getExceptions().add(new Exception(message));
                            for (int x = mydbf.getLastRec(); x < collection.getNumGeometries(); ++x) {
                                feature = new BasicFeature(fs);
                                geo = collection.getGeometryN(x);
                                feature.setGeometry(geo);
                                featureCollection.add(feature);
                            }
                        }
                        if (collection.getNumGeometries() < mydbf.getLastRec()) {
                            String message = I18N.getInstance().get("com.vividsolutions.jump.io.ShapefileReader.shp-lt-dbf", shpFileName, collection.getNumGeometries(), mydbf.getLastRec());
                            Logger.error(message);
                            this.getExceptions().add(new Exception(message));
                            ArrayList emptyList = new ArrayList();
                            for (int x = collection.getNumGeometries(); x < mydbf.getLastRec(); ++x) {
                                BasicFeature feature2 = new BasicFeature(fs);
                                Geometry geo2 = factory.buildGeometry(emptyList);
                                byte[] s = mydbf.GetDbfRec(x);
                                if (s[0] == 42 && System.getProperty("dbf.deleted.on") == null) continue;
                                for (int y = 0; y < numfields; ++y) {
                                    feature2.setAttribute(y + 1, mydbf.ParseRecordColumn(s, y));
                                }
                                feature2.setGeometry(geo2);
                                featureCollection.add(feature2);
                            }
                        }
                    }
                    featureDataset = featureCollection;
                    if (shx == null) break block24;
                }
                catch (Throwable throwable) {
                    if (shx != null) {
                        try {
                            shx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                shx.close();
            }
            return featureDataset;
        }
        finally {
            this.deleteTmpDbf();
            this.deleteTmpShx();
            this.deleteTmpCpg();
            myshape.close();
            if (mydbf != null) {
                mydbf.close();
            }
        }
    }

    protected Shapefile getShapefile(String shpfileName, String compressedFname) throws Exception {
        InputStream in = CompressedFile.openFile(shpfileName, compressedFname);
        return new Shapefile(in);
    }

    protected InputStream getShx(String srcFileName, String compressedFname) throws Exception {
        if (srcFileName.matches("(?i).*\\.shp$")) {
            File shxFile = new File(srcFileName = srcFileName.replaceAll("\\.[^.]*$", ".shx"));
            if (shxFile.exists()) {
                return new FileInputStream(srcFileName);
            }
        } else if (compressedFname != null) {
            byte[] b = new byte[4096];
            boolean keepGoing = true;
            File file = File.createTempFile("shx", ".shx");
            FileOutputStream out = new FileOutputStream(file);
            compressedFname = compressedFname.replaceAll("\\.[^.]*$", ".shx");
            try {
                InputStream in = CompressedFile.openFile(srcFileName, compressedFname);
                while (keepGoing) {
                    int len = in.read(b);
                    if (len > 0) {
                        out.write(b, 0, len);
                    }
                    keepGoing = len != -1;
                }
                in.close();
                out.close();
                FileInputStream shxInputStream = new FileInputStream(file.toString());
                this.delete_this_tmp_shx = file;
                return shxInputStream;
            }
            catch (Exception e) {
                Logger.error(e);
            }
        }
        return null;
    }

    protected String getCharset(String shpFileName, DriverProperties dp) throws Exception {
        String charsetName;
        block15: {
            charsetName = Charset.defaultCharset().name();
            try (InputStream cpgCharsetInputStream = this.getCpgInputStream(shpFileName, dp.getProperty("CompressedFile"));){
                if (cpgCharsetInputStream == null) break block15;
                try (BufferedReader cpgCharsetReader = new BufferedReader(new InputStreamReader(cpgCharsetInputStream));){
                    String cpgCharset = cpgCharsetReader.readLine();
                    try {
                        cpgCharset = this.esri_cp_2_java(cpgCharset);
                        if (Charset.isSupported(cpgCharset)) {
                            charsetName = cpgCharset;
                        }
                    }
                    catch (NullPointerException | IllegalCharsetNameException ice) {
                        Logger.warn("Could not interpret charset name " + cpgCharset + " : revert to default " + charsetName);
                    }
                }
            }
        }
        if (dp.getProperty("charset") != null && Charset.isSupported(dp.getProperty("charset")) && !Charset.defaultCharset().name().equals(Charset.forName(dp.getProperty("charset")).name())) {
            charsetName = dp.getProperty("charset");
        }
        return charsetName;
    }

    protected InputStream getCpgInputStream(String srcFileName, String compressedFname) throws Exception {
        if (srcFileName.matches("(?i).*\\.shp$")) {
            File cpgFile = new File(srcFileName = srcFileName.replaceAll("\\.[^.]*$", ".cpg"));
            if (cpgFile.exists()) {
                return new FileInputStream(srcFileName);
            }
        } else if (compressedFname != null) {
            byte[] b = new byte[4096];
            boolean keepGoing = true;
            File file = File.createTempFile("cpg", ".cpg");
            FileOutputStream out = new FileOutputStream(file);
            compressedFname = compressedFname.replaceAll("\\.[^.]*$", ".cpg");
            try {
                InputStream in = CompressedFile.openFile(srcFileName, compressedFname);
                while (keepGoing) {
                    int len = in.read(b);
                    if (len > 0) {
                        out.write(b, 0, len);
                    }
                    keepGoing = len != -1;
                }
                in.close();
                out.close();
                FileInputStream cpgInputStream = new FileInputStream(file.toString());
                this.delete_this_tmp_cpg = file;
                return cpgInputStream;
            }
            catch (Exception e) {
                Logger.warn(e.getMessage());
            }
        }
        return null;
    }

    protected DbfFile getDbfFile(String srcFileName, String compressedFname, Charset charset) throws IOException {
        if (srcFileName.matches("(?i).*\\.shp$")) {
            File dbfFile = new File(srcFileName = srcFileName.replaceAll("\\.[^.]*$", ".dbf"));
            if (dbfFile.exists()) {
                return new DbfFile(srcFileName, charset);
            }
        } else if (compressedFname != null) {
            byte[] b = new byte[4096];
            boolean keepGoing = true;
            File file = File.createTempFile("dbf", ".dbf");
            FileOutputStream out = new FileOutputStream(file);
            compressedFname = compressedFname.replaceAll("\\.[^.]*$", ".dbf");
            try {
                InputStream in = CompressedFile.openFile(srcFileName, compressedFname);
                while (keepGoing) {
                    int len = in.read(b);
                    if (len > 0) {
                        out.write(b, 0, len);
                    }
                    keepGoing = len != -1;
                }
                in.close();
                out.close();
                DbfFile mydbf = new DbfFile(file.toString(), charset);
                this.delete_this_tmp_dbf = file;
                return mydbf;
            }
            catch (Exception e) {
                Logger.error(e);
            }
        }
        return null;
    }

    private void deleteTmpDbf() {
        if (this.delete_this_tmp_dbf != null) {
            this.delete_this_tmp_dbf.delete();
            this.delete_this_tmp_dbf = null;
        }
    }

    private void deleteTmpShx() {
        if (this.delete_this_tmp_shx != null) {
            this.delete_this_tmp_shx.delete();
            this.delete_this_tmp_shx = null;
        }
    }

    private void deleteTmpCpg() {
        if (this.delete_this_tmp_cpg != null) {
            this.delete_this_tmp_cpg.delete();
            this.delete_this_tmp_cpg = null;
        }
    }

    private String esri_cp_2_java(String esri_cp) {
        Matcher matcher = CODE_PAGE.matcher(esri_cp);
        if (matcher.matches() && matcher.groupCount() == 1) {
            String code = matcher.group(1);
            if (code.length() == 3) {
                if (code.equals("708")) {
                    return "ISO-8859-6";
                }
                if (code.equals("932")) {
                    return "Shift_JIS";
                }
                if (code.equals("936")) {
                    return "GBK";
                }
                return "IBM" + code;
            }
            if (code.length() == 4) {
                return "windows-" + code;
            }
            if (code.startsWith("8859")) {
                return "ISO-8859-" + code.substring(4);
            }
            return esri_cp.replaceAll(" ", "-");
        }
        return esri_cp.replaceAll(" ", "-");
    }
}

