/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.spatialite;

import com.vividsolutions.jump.datastore.jdbc.ValueConverter;
import com.vividsolutions.jump.datastore.jdbc.ValueConverterFactory;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesValueConverterFactory;
import com.vividsolutions.jump.datastore.spatialite.GeometricColumnType;
import com.vividsolutions.jump.datastore.spatialite.SpatialiteDSMetadata;
import com.vividsolutions.jump.feature.AttributeType;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class SpatialiteValueConverterFactory
extends SpatialDatabasesValueConverterFactory {
    protected final ValueConverter SPATIALITE_GEOMETRY_MAPPER = new SpatialiteGeometryValueConverter();
    private SpatialiteDSMetadata metadata;

    public SpatialiteValueConverterFactory(Connection conn) {
        super(conn);
    }

    public void setMetadata(SpatialiteDSMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public ValueConverter getConverter(ResultSetMetaData rsm, int columnIndex) throws SQLException {
        String dbTypeName = rsm.getColumnTypeName(columnIndex);
        String tableName = rsm.getTableName(columnIndex).toLowerCase();
        String columnName = rsm.getColumnName(columnIndex).toLowerCase();
        GeometricColumnType gcType = this.metadata.getGeoColTypesdMap().get((tableName == null || tableName.isEmpty() ? "" : tableName + ".") + columnName);
        if (gcType == null) {
            ValueConverter stdConverter = ValueConverterFactory.getConverter(rsm, columnIndex);
            if (stdConverter != null) {
                return stdConverter;
            }
            return ValueConverterFactory.STRING_MAPPER;
        }
        if (gcType == GeometricColumnType.WKB) {
            return this.WKB_GEOMETRY_MAPPER;
        }
        if (gcType == GeometricColumnType.WKT) {
            return this.WKT_GEOMETRY_MAPPER;
        }
        if (gcType == GeometricColumnType.SPATIALITE || gcType == GeometricColumnType.NATIVE) {
            return this.SPATIALITE_GEOMETRY_MAPPER;
        }
        return ValueConverterFactory.STRING_MAPPER;
    }

    private boolean appearsToBeGeopackageGeometry(byte[] geometryAsBytes) {
        return geometryAsBytes.length > 2 && geometryAsBytes[0] == 71 && geometryAsBytes[1] == 80;
    }

    private boolean appearsToBeNativeGeometry(byte[] geometryAsBytes) {
        boolean blobIsGeometry = false;
        int numBytes = geometryAsBytes.length;
        if (numBytes > 39 && geometryAsBytes[38] == 124 && geometryAsBytes[numBytes - 1] == -2) {
            blobIsGeometry = true;
        }
        return blobIsGeometry;
    }

    class SpatialiteGeometryValueConverter
    implements ValueConverter {
        SpatialiteGeometryValueConverter() {
        }

        @Override
        public AttributeType getType() {
            return AttributeType.GEOMETRY;
        }

        @Override
        public Object getValue(ResultSet rs, int columnIndex) throws IOException, SQLException, ParseException {
            Geometry returnGeometry = null;
            byte[] geometryBytes = rs.getBytes(columnIndex);
            returnGeometry = geometryBytes != null ? (SpatialiteValueConverterFactory.this.appearsToBeGeopackageGeometry(geometryBytes) ? this.getGeopackageGeometryFromBlob(geometryBytes) : this.getNativeGeometryFromBlob(geometryBytes)) : SpatialiteValueConverterFactory.this.wktReader.read("GEOMETRYCOLLECTION EMPTY");
            return returnGeometry;
        }

        private Geometry getNativeGeometryFromBlob(byte[] blobAsBytes) throws IOException, ParseException {
            byte[] wkb = new byte[blobAsBytes.length - 39];
            System.arraycopy(blobAsBytes, 39, wkb, 1, blobAsBytes.length - 1 - 39);
            wkb[0] = blobAsBytes[1];
            WKBReader wkbReader = new WKBReader();
            this.setEwkbGeometryType(wkb);
            Geometry returnGeometry = wkbReader.read(wkb);
            if (returnGeometry == null) {
                throw new IOException("Unable to parse WKB");
            }
            return returnGeometry;
        }

        private Geometry getGeopackageGeometryFromBlob(byte[] blobAsBytes) throws IOException, ParseException {
            byte flags = blobAsBytes[3];
            boolean evelopeSize = false;
            boolean emptyGeometry = (flags & 0x20) != 0;
            int envelopSize = this.getEnvelopeSize(flags);
            int headerSize = 8 + envelopSize;
            byte[] wkb = new byte[blobAsBytes.length - headerSize];
            System.arraycopy(blobAsBytes, headerSize, wkb, 0, blobAsBytes.length - headerSize);
            WKBReader wkbReader = new WKBReader();
            this.setEwkbGeometryType(wkb);
            Geometry returnGeometry = wkbReader.read(wkb);
            if (returnGeometry == null) {
                throw new IOException("Unable to parse WKB");
            }
            return returnGeometry;
        }

        private void setEwkbGeometryType(byte[] wkb) {
            byte byteOrder = wkb[0];
            int geometryType = byteOrder == 0 ? wkb[4] & 0xFF | (wkb[3] & 0xFF) << 8 | (wkb[2] & 0xFF) << 16 | (wkb[1] & 0xFF) << 24 : wkb[1] & 0xFF | (wkb[2] & 0xFF) << 8 | (wkb[3] & 0xFF) << 16 | (wkb[4] & 0xFF) << 24;
            boolean hasZ = (geometryType & Integer.MIN_VALUE) != 0 || geometryType >= 1000 && geometryType < 3000;
            geometryType = (geometryType & 0xFFFF) % 1000;
            if (byteOrder == 0) {
                wkb[1] = hasZ ? (byte)(wkb[1] | 0x80) : wkb[1];
                wkb[2] = 0;
                wkb[3] = 0;
                wkb[4] = (byte)(geometryType & 0xFF);
            } else {
                wkb[4] = hasZ ? (byte)(wkb[4] | 0x80) : wkb[4];
                wkb[3] = 0;
                wkb[2] = 0;
                wkb[1] = (byte)(geometryType & 0xFF);
            }
        }

        private int getEnvelopeSize(byte flags) throws IOException {
            int envelopeSize;
            boolean littleEndian = (flags & 1) != 0;
            int envelopeCode = (flags & 0xE) >>> 1;
            switch (envelopeCode) {
                case 0: {
                    envelopeSize = 0;
                    break;
                }
                case 1: {
                    envelopeSize = 32;
                    break;
                }
                case 2: 
                case 3: {
                    envelopeSize = 48;
                    break;
                }
                case 4: {
                    envelopeSize = 64;
                    break;
                }
                default: {
                    throw new IOException("Invalid envelope code " + envelopeCode);
                }
            }
            return envelopeSize;
        }
    }
}

