/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.spatialdatabases;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.AdhocQuery;
import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreException;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.datastore.Query;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSMetadata;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesSQLBuilder;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesValueConverterFactory;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.FeatureInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class SpatialDatabasesDSConnection
implements DataStoreConnection {
    protected SpatialDatabasesDSMetadata dbMetadata;
    protected Connection connection;

    public SpatialDatabasesDSConnection(Connection conn) {
        this.connection = conn;
        this.dbMetadata = new SpatialDatabasesDSMetadata(this);
    }

    @Override
    public Connection getJdbcConnection() {
        return this.connection;
    }

    @Override
    public SpatialDatabasesDSMetadata getMetadata() {
        return this.dbMetadata;
    }

    @Override
    public SpatialDatabasesSQLBuilder getSqlBuilder(SpatialReferenceSystemID srid, String[] colNames) {
        return new SpatialDatabasesSQLBuilder(this.dbMetadata, srid, colNames);
    }

    @Override
    public FeatureInputStream execute(Query query) throws Exception {
        if (query instanceof FilterQuery) {
            try {
                return this.executeFilterQuery((FilterQuery)query);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (query instanceof AdhocQuery) {
            return this.executeAdhocQuery((AdhocQuery)query);
        }
        throw new IllegalArgumentException(I18N.getInstance().get(this.getClass().getName() + ".unsupported-query-type"));
    }

    public FeatureInputStream executeFilterQuery(FilterQuery query) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public FeatureInputStream executeAdhocQuery(AdhocQuery query) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws DataStoreException {
        try {
            this.connection.close();
        }
        catch (Exception ex) {
            throw new DataStoreException(ex);
        }
    }

    @Override
    public boolean isClosed() throws DataStoreException {
        try {
            return this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new DataStoreException(e);
        }
    }

    public SpatialDatabasesValueConverterFactory getValueConverterFactory() {
        return new SpatialDatabasesValueConverterFactory(this.connection);
    }

    public String[] getCompatibleSchemaSubset(String schemaName, String tableName, FeatureSchema featureSchema, boolean normalizedColumnNames) throws Exception {
        SpatialDatabasesValueConverterFactory factory = this.getValueConverterFactory();
        ResultSet rs = this.connection.createStatement().executeQuery("SELECT * FROM " + SQLUtil.compose(schemaName, tableName) + " LIMIT 0");
        ResultSetMetaData rsMetaData = rs.getMetaData();
        ArrayList<String> commonAttributes = new ArrayList<String>();
        for (int i = 0; i < featureSchema.getAttributeCount(); ++i) {
            String attribut = featureSchema.getAttributeName(i);
            if (normalizedColumnNames) {
                attribut = SQLUtil.normalize(attribut);
            }
            try {
                AttributeType type = factory.getConverter(rsMetaData, rs.findColumn(attribut)).getType();
                if (type == featureSchema.getAttributeType(i)) {
                    // empty if block
                }
                commonAttributes.add(featureSchema.getAttributeName(i));
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return commonAttributes.toArray(new String[0]);
    }
}

