/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.spatialdatabases;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPVersion;
import com.vividsolutions.jump.datastore.DataStoreDriver;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.Extension;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.util.Map;

public abstract class AbstractSpatialDatabasesDSExtension
extends Extension {
    static final String I18NPREFIX = AbstractSpatialDatabasesDSExtension.class.getName();
    public static final String VERSION = JUMPVersion.CURRENT_VERSION;
    protected String errorMessage = null;
    protected DataStoreDriver driver = null;
    protected Class[] dsDriverClasses = null;
    protected Map<String, String> classNameToJarName = null;

    private AbstractSpatialDatabasesDSExtension() {
    }

    public AbstractSpatialDatabasesDSExtension(Class[] dsDriverClasses, Map<String, String> classesToJar) {
        if (classesToJar == null || this.checkArray(dsDriverClasses, DataStoreDriver.class)) {
            throw new IllegalArgumentException();
        }
        this.dsDriverClasses = dsDriverClasses;
        this.classNameToJarName = classesToJar;
    }

    public AbstractSpatialDatabasesDSExtension(Class dsDriverClass, Map<String, String> classesToJar) {
        this(new Class[]{dsDriverClass}, classesToJar);
    }

    private boolean checkArray(Class[] classes, Class derivedFrom) {
        if (!(this.dsDriverClasses instanceof Class[])) {
            return false;
        }
        for (Class clazz : classes) {
            if (clazz.isAssignableFrom(derivedFrom)) continue;
            return false;
        }
        return true;
    }

    @Override
    public abstract String getName();

    @Override
    public String getVersion() {
        return VERSION;
    }

    protected String isAvailable() {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        String msg = "";
        String others = "";
        for (Map.Entry<String, String> entry : this.classNameToJarName.entrySet()) {
            String clazz = entry.getKey();
            String jar = entry.getValue();
            try {
                Class.forName(clazz, false, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                msg = msg.isEmpty() ? jar : msg + ", " + jar;
            }
            catch (Throwable t) {
                others = (!others.isEmpty() ? others + "; " : "") + t.getClass().getSimpleName() + " " + t.getLocalizedMessage();
            }
        }
        if (!msg.isEmpty()) {
            msg = I18N.getInstance().get(I18NPREFIX + ".missing-dependency-jars", msg);
        }
        if (!others.isEmpty()) {
            msg = msg + (!msg.isEmpty() ? " " : "") + I18N.getInstance().get(I18NPREFIX + ".there-were-errors", others);
        }
        this.errorMessage = msg;
        return this.errorMessage;
    }

    @Override
    public String getMessage() {
        String msg = this.isAvailable();
        if (!msg.isEmpty()) {
            return msg;
        }
        if (this.driver != null) {
            return this.driver.getVersion();
        }
        return "";
    }

    @Override
    public void configure(PlugInContext context) throws Exception {
        WorkbenchContext wbc = context.getWorkbenchContext();
        if (this.isAvailable().isEmpty()) {
            for (Class dsDriverClass : this.dsDriverClasses) {
                DataStoreDriver dsDriver = (DataStoreDriver)dsDriverClass.newInstance();
                if (this.driver == null) {
                    this.driver = dsDriver;
                }
                wbc.getRegistry().createEntry(DataStoreDriver.REGISTRY_CLASSIFICATION, dsDriver);
            }
        } else {
            Logger.warn(I18N.getInstance().get(I18NPREFIX + ".datastore-disabled", this.getName(), this.isAvailable()));
        }
    }
}

