/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.postgis;

import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.GeometryColumn;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSMetadata;
import com.vividsolutions.jump.feature.AttributeType;
import java.text.Normalizer;
import java.util.List;

public class PostgisDSMetadata
extends SpatialDatabasesDSMetadata {
    public PostgisDSMetadata(DataStoreConnection con) {
        this.conn = con;
        this.datasetNameQuery = "SELECT DISTINCT f_table_schema, f_table_name FROM geometry_columns";
        this.defaultSchemaName = "public";
        this.spatialDbName = "PostGIS";
        this.spatialExtentQuery1 = "SELECT ST_AsBinary(ST_EstimatedExtent( '%s', '%s', '%s' ))";
        this.spatialExtentQuery2 = "SELECT ST_AsBinary(ST_Envelope(ST_Extent(\"%s\"))) FROM \"%s\".\"%s\"";
        this.geoColumnsQuery = "SELECT f_geometry_column, coord_dimension, srid, type FROM geometry_columns where f_table_schema='%s' and f_table_name = '%s'";
        this.sridQuery = "SELECT srid FROM geometry_columns where f_table_schema = '%s' and f_table_name = '%s' and f_geometry_column = '%s'";
        this.coordDimQuery = "SELECT coord_dimension FROM geometry_columns where f_table_schema = '%s' and f_table_name = '%s' and f_geometry_column = '%s'";
        this.datasetInfoQuery = "SELECT f_table_schema, f_table_name, f_geometry_column, coord_dimension, srid, type FROM geometry_columns order by 1, 2";
    }

    @Override
    public String getSpatialExtentQuery1(String schema, String table, String attributeName) {
        return String.format(this.spatialExtentQuery1, SQLUtil.escapeSingleQuote(schema), SQLUtil.escapeSingleQuote(table), SQLUtil.escapeSingleQuote(attributeName));
    }

    @Override
    public String getSpatialExtentQuery2(String schema, String table, String attributeName) {
        return String.format(this.spatialExtentQuery2, attributeName, schema, table);
    }

    @Override
    public String getGeoColumnsQuery(String datasetName) {
        return String.format(this.geoColumnsQuery, SQLUtil.escapeSingleQuote(this.getSchemaName(datasetName)), SQLUtil.escapeSingleQuote(this.getTableName(datasetName)));
    }

    @Override
    public String getSridQuery(String schemaName, String tableName, String colName) {
        return String.format(this.sridQuery, SQLUtil.escapeSingleQuote(schemaName), SQLUtil.escapeSingleQuote(tableName), SQLUtil.escapeSingleQuote(colName));
    }

    @Override
    public List<GeometryColumn> getGeometryAttributes(String datasetName) {
        String sql = this.getGeoColumnsQuery(datasetName);
        return this.getGeometryAttributes(sql, datasetName);
    }

    @Override
    public String getCoordinateDimensionQuery(String schemaName, String tableName, String colName) {
        return String.format(this.coordDimQuery, SQLUtil.escapeSingleQuote(schemaName), SQLUtil.escapeSingleQuote(tableName), SQLUtil.escapeSingleQuote(colName));
    }

    @Override
    protected String getDbTypeName(AttributeType type) {
        if (type == AttributeType.GEOMETRY) {
            return "geometry";
        }
        if (type == AttributeType.STRING) {
            return "varchar";
        }
        if (type == AttributeType.INTEGER) {
            return "int4";
        }
        if (type == AttributeType.LONG) {
            return "int8";
        }
        if (type == AttributeType.DOUBLE) {
            return "float8";
        }
        if (type == AttributeType.DATE) {
            return "timestamp";
        }
        if (type == AttributeType.BOOLEAN) {
            return "bool";
        }
        if (type == AttributeType.OBJECT) {
            return "bytea";
        }
        return "bytea";
    }

    @Override
    public String getAddSpatialIndexStatement(String schemaName, String tableName, String geometryColumn) {
        String name = schemaName == null ? "" : schemaName + "_";
        name = name + tableName + "_" + geometryColumn + "_idx";
        name = Normalizer.normalize(name, Normalizer.Form.NFD);
        name = name.replaceAll("\\p{M}", "");
        name = name.toLowerCase();
        name = name.replaceAll("[^\\x5F\\x30-\\x39\\x41-\\x5A\\x61-\\x7A]", "_");
        name = name.replaceAll("_+", "_");
        return "CREATE INDEX " + name + " ON " + SQLUtil.compose(schemaName, tableName) + " USING GIST ( \"" + geometryColumn + "\" );";
    }
}

