/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.oracle;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.AdhocQuery;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.oracle.OracleDSMetadata;
import com.vividsolutions.jump.datastore.oracle.OracleFeatureInputStream;
import com.vividsolutions.jump.datastore.oracle.OracleSQLBuilder;
import com.vividsolutions.jump.datastore.oracle.OracleValueConverterFactory;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSConnection;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesSQLBuilder;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.FeatureInputStream;
import java.sql.Connection;
import java.sql.SQLException;

public class OracleDSConnection
extends SpatialDatabasesDSConnection {
    public OracleDSConnection(Connection con) {
        super(con);
        this.dbMetadata = new OracleDSMetadata(this);
    }

    @Override
    public SpatialDatabasesSQLBuilder getSqlBuilder(SpatialReferenceSystemID srid, String[] colNames) {
        return new OracleSQLBuilder(this.dbMetadata, srid, colNames);
    }

    @Override
    public FeatureInputStream executeFilterQuery(FilterQuery query) throws SQLException {
        SpatialReferenceSystemID srid = this.dbMetadata.getSRID(query.getDatasetName(), query.getGeometryAttributeName());
        String[] colNames = this.dbMetadata.getColumnNames(query.getDatasetName());
        OracleSQLBuilder builder = (OracleSQLBuilder)this.getSqlBuilder(srid, colNames);
        String queryString = builder.getSQL(query);
        return new OracleFeatureInputStream(this.connection, queryString, query.getPrimaryKey());
    }

    @Override
    public FeatureInputStream executeAdhocQuery(AdhocQuery query) throws Exception {
        FeatureSchema fs;
        String queryString = query.getQuery();
        OracleFeatureInputStream ifs = new OracleFeatureInputStream(this.connection, queryString, query.getPrimaryKey());
        try {
            fs = ifs.getFeatureSchema();
        }
        catch (Exception e) {
            throw new Exception(I18N.getInstance().get(SpatialDatabasesDSConnection.class.getName() + ".SQL-error") + e.getMessage());
        }
        if (fs.getGeometryIndex() < 0) {
            throw new Exception(I18N.getInstance().get(SpatialDatabasesDSConnection.class.getName() + ".resultset-must-have-a-geometry-column"));
        }
        return ifs;
    }

    @Override
    public OracleValueConverterFactory getValueConverterFactory() {
        return new OracleValueConverterFactory(this.connection);
    }
}

