/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.util;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.Logger;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class CustomTexturePaint
implements Paint {
    private TexturePaint texturePaint;
    private URL url;
    public File svg;

    public CustomTexturePaint() {
        BufferedImage img = new BufferedImage(300, 20, 2);
        Graphics g = img.getGraphics();
        g.setColor(Color.black);
        g.drawString(I18N.getInstance().get("org.openjump.util.CustomTexturePaint.no-image-chosen"), 25, 10);
        g.dispose();
        this.texturePaint = new TexturePaint(img, new Rectangle2D.Float(0.0f, 0.0f, img.getWidth(), img.getHeight()));
    }

    public CustomTexturePaint(URL url) {
        try {
            this.setUrl(url.toExternalForm());
        }
        catch (IOException e) {
            Logger.error("Could not load texture from URL '" + url + "'", e);
            BufferedImage img = new BufferedImage(300, 20, 2);
            Graphics g = img.getGraphics();
            g.setColor(Color.black);
            g.drawString(I18N.getInstance().get("org.openjump.util.CustomTexturePaint.no-image-chosen"), 25, 10);
            g.dispose();
            this.texturePaint = new TexturePaint(img, new Rectangle2D.Float(0.0f, 0.0f, img.getWidth(), img.getHeight()));
        }
    }

    public void setUrl(String url) throws IOException {
        if (url == null || url.isEmpty()) {
            Logger.error("Url given must not be null or empty.");
            return;
        }
        this.url = new URL(url);
        BufferedImage img = ImageIO.read(this.url);
        if (img == null) {
            throw new IOException(I18N.getInstance().get("org.openjump.util.CustomTexturePaint.the-url-does-not-point-to-an-image", url));
        }
        this.texturePaint = new TexturePaint(img, new Rectangle2D.Float(0.0f, 0.0f, img.getWidth(), img.getHeight()));
    }

    public String getUrl() {
        return this.url == null ? null : this.url.toExternalForm();
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return this.texturePaint.createContext(cm, deviceBounds, userBounds, xform, hints);
    }

    @Override
    public int getTransparency() {
        return this.texturePaint.getTransparency();
    }

    public boolean equals(Object other) {
        if (other instanceof CustomTexturePaint) {
            return true;
        }
        return super.equals(other);
    }
}

