/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.sigle.utilities.gui;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

public class DialogUtil {
    public static List getFieldsFromLayer(Layer l) {
        LinkedList<String> fields = new LinkedList<String>();
        for (int i = 0; i < l.getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount(); ++i) {
            fields.add(l.getFeatureCollectionWrapper().getFeatureSchema().getAttributeName(i));
        }
        return fields;
    }

    public static void updateFieldComboBox(JComboBox cb, Layer l) {
        cb.removeAllItems();
        Iterator i = DialogUtil.getFieldsFromLayer(l).iterator();
        while (i.hasNext()) {
            cb.addItem(i.next());
        }
    }

    public static List getFieldsFromLayerWithoutGeometry(Layer l) {
        LinkedList<String> fields = new LinkedList<String>();
        for (int i = 0; i < l.getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount(); ++i) {
            AttributeType type = l.getFeatureCollectionWrapper().getFeatureSchema().getAttributeType(i);
            if (type == AttributeType.GEOMETRY) continue;
            fields.add(l.getFeatureCollectionWrapper().getFeatureSchema().getAttributeName(i));
        }
        return fields;
    }

    public static Double getDoubleFromAttribute(Feature f, String attributeName) {
        Double d = new Double(Double.NaN);
        AttributeType type = f.getSchema().getAttributeType(attributeName);
        if (type == AttributeType.DOUBLE) {
            d = (Double)f.getAttribute(attributeName);
        } else if (type == AttributeType.INTEGER) {
            d = new Double(((Integer)f.getAttribute(attributeName)).doubleValue());
        } else if (type == AttributeType.STRING) {
            d = Double.valueOf((String)f.getAttribute(attributeName));
        }
        return d;
    }

    public static void updateFieldTypeLabel(JLabel label, Layer l, String attributeName) {
        AttributeType nameType = l.getFeatureCollectionWrapper().getFeatureSchema().getAttributeType(attributeName);
        label.setText(nameType.toString());
    }

    public static void setLayerNamesAsListData(LayerManager argManager, JList argList) {
        List<Layer> layers = argManager.getLayers();
        LinkedList<String> layerNames = new LinkedList<String>();
        for (Layer thisElement : layers) {
            String layerName = thisElement.getName();
            layerNames.add(layerName);
        }
        Object[] arrayForJList = layerNames.toArray();
        argList.setListData(arrayForJList);
    }
}

