/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.sigle.plugin.joinTable;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.locationtech.jts.io.ParseException;
import org.openjump.sigle.plugin.joinTable.JoinTableDataSource;

public class JoinTableDataSourceCSV
implements JoinTableDataSource {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("[-+]?[0-9]{1,10}");
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[-+]?([0-9]*\\.[0-9]+|[0-9]+(\\.[0-9]+)?)([eE][-+]?[0-9]+)?");
    private ArrayList fieldNames = null;
    private ArrayList fieldTypes = null;
    private String filePath = null;
    private int fieldCount = 0;
    private String DEFAULT_DELEM = "\t";
    private String DELIMITATEURS = ";|\t";

    public JoinTableDataSourceCSV(String filePath) {
        this.filePath = filePath;
        this.fieldNames = new ArrayList();
        this.readHeader();
    }

    @Override
    public ArrayList getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public ArrayList getFieldTypes() {
        return this.fieldTypes;
    }

    @Override
    public Hashtable buildTable(int keyIndex) {
        Hashtable<String, String[]> table = new Hashtable<String, String[]>();
        int nl = 1;
        this.fieldTypes = new ArrayList();
        try {
            FileReader fileReader = new FileReader(this.filePath);
            FileInputStream fis = new FileInputStream(this.filePath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fis));
            try {
                String line = bufferedReader.readLine();
                ++nl;
                line = bufferedReader.readLine();
                ++nl;
                if (line == null) {
                    throw new Exception(I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.Empty_file"));
                }
                nl = 1;
                while (line != null) {
                    if (line.trim().length() > 0) {
                        String[] valeurs = line.split(this.DELIMITATEURS, -1);
                        if (valeurs.length != this.fieldCount) {
                            throw new Exception(I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.Field_problem_at_line") + nl);
                        }
                        for (int i = 0; i < valeurs.length; ++i) {
                            AttributeType fieldType;
                            String s = valeurs[i];
                            if (i + 1 > this.fieldTypes.size()) {
                                this.fieldTypes.add(i, this.typeOfString(s));
                                continue;
                            }
                            AttributeType newFieldType = this.typeOfString(s);
                            if (newFieldType == (fieldType = (AttributeType)this.fieldTypes.get(i))) continue;
                            if (newFieldType == AttributeType.STRING) {
                                this.fieldTypes.set(i, newFieldType);
                                continue;
                            }
                            if (fieldType == AttributeType.STRING || newFieldType != AttributeType.DOUBLE) continue;
                            this.fieldTypes.set(i, newFieldType);
                        }
                        table.put(valeurs[keyIndex], valeurs);
                    }
                    line = bufferedReader.readLine();
                    ++nl;
                }
            }
            catch (Exception e) {
                String msg = I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.Error_while_reading_file") + this.filePath + " (" + e.getMessage() + ").";
                throw new ParseException(msg);
            }
            finally {
                bufferedReader.close();
                fileReader.close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
        return table;
    }

    private void readHeader() {
        try {
            FileReader fileReader = new FileReader(this.filePath);
            FileInputStream fis = new FileInputStream(this.filePath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fis));
            try {
                String firstLine = bufferedReader.readLine();
                if (firstLine == null) {
                    throw new Exception(I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.Empty_file"));
                }
                String[] champs = firstLine.split(this.DELIMITATEURS);
                for (int k = 0; k < champs.length; ++k) {
                    String s = champs[k];
                    boolean nomUnique = false;
                    String suffixe = "";
                    int j = 0;
                    int i = 1;
                    while (!nomUnique) {
                        nomUnique = true;
                        for (j = 0; j < this.fieldNames.size(); ++j) {
                            String saux = (String)this.fieldNames.get(j);
                            nomUnique = nomUnique && !(s + suffixe).equalsIgnoreCase(saux);
                        }
                        if (nomUnique) continue;
                        suffixe = String.valueOf(i);
                        ++i;
                    }
                    this.fieldNames.add(s + suffixe);
                }
                this.fieldCount = this.fieldNames.size();
            }
            catch (Exception e) {
                String msg = I18N.getInstance().get("org.openjump.sigle.plugin.joinTable.Error_while_reading_fields_in_file") + this.filePath + "(" + e.getMessage() + ").";
                throw new ParseException(msg);
            }
            finally {
                bufferedReader.close();
                fileReader.close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private AttributeType typeOfString(String s) {
        AttributeType res = s.length() == 0 ? AttributeType.INTEGER : (INTEGER_PATTERN.matcher(s).matches() ? AttributeType.INTEGER : (DOUBLE_PATTERN.matcher(s).matches() ? AttributeType.DOUBLE : AttributeType.STRING));
        return res;
    }
}

