/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view.showcenter;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.openjump.core.ui.plugin.view.showcenter.ColorComboRenderer;
import org.openjump.core.ui.plugin.view.showcenter.ShowViewCenterInstallRenderer;
import org.openjump.core.ui.plugin.view.showcenter.ShowViewCenterRenderer;
import org.saig.core.gui.swing.sldeditor.util.FormUtils;

public class ShowViewCenterPlugIn
extends AbstractPlugIn {
    public static String NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.view.showcenter.name");
    public static String DIMENSION = I18N.getInstance().get("ui.FontChooser.size");
    public static String COLOR = I18N.getInstance().get("ui.ColorChooserPanel.choose-color");
    Integer windth = 30;
    ImageIcon radio_icon_3 = GUIUtil.toSmallIcon(new ImageIcon(this.getClass().getResource("icon3.gif")), this.windth);
    ImageIcon radio_icon_2 = GUIUtil.toSmallIcon(new ImageIcon(this.getClass().getResource("icon2.gif")), this.windth);
    ImageIcon radio_icon = GUIUtil.toSmallIcon(new ImageIcon(this.getClass().getResource("icon.gif")), this.windth);
    public static JRadioButtonMenuItem radio_button = new JRadioButtonMenuItem();
    public static JRadioButtonMenuItem radio_button_2 = new JRadioButtonMenuItem();
    public static JRadioButtonMenuItem radio_button_3 = new JRadioButtonMenuItem();
    public static JSpinner dimensionSpinner = new JSpinner();
    public static SpinnerModel dimensionModel = new SpinnerNumberModel(40, 10, 200, 5);
    static Color[] colors = new Color[]{Color.black, Color.red, Color.orange, Color.yellow, Color.green, Color.cyan, Color.cyan.darker(), Color.blue, Color.magenta, Color.pink, Color.darkGray, Color.gray, Color.lightGray, Color.white};
    public static JComboBox<Color> colorBox = new JComboBox<Color>(colors);
    private MultiInputDialog dialog;

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        LayerViewPanel pan = context.getLayerViewPanel();
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.dialog.setResizable(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        radio_button = new JRadioButtonMenuItem("", this.radio_icon, true);
        buttonGroup.add(radio_button);
        radio_button_2 = new JRadioButtonMenuItem("", this.radio_icon_2);
        buttonGroup.add(radio_button_2);
        radio_button_3 = new JRadioButtonMenuItem("", this.radio_icon_3);
        buttonGroup.add(radio_button_3);
        dimensionSpinner = new JSpinner(dimensionModel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)radio_button, "West");
        buttonPanel.add((Component)radio_button_2, "Center");
        buttonPanel.add((Component)radio_button_3, "East");
        JPanel pani = new JPanel(new GridBagLayout());
        this.dialog.addRow(buttonPanel);
        FormUtils.addRowInGBL((JComponent)pani, 2, 0, DIMENSION, (JComponent)dimensionSpinner);
        colorBox.setMaximumRowCount(9);
        colorBox.setRenderer(new ColorComboRenderer());
        this.dialog.addRow(pani);
        this.dialog.pack();
        if (!ShowViewCenterRenderer.isEnabled(pan)) {
            GUIUtil.centreOnWindow(this.dialog);
            this.dialog.setVisible(true);
            if (!this.dialog.wasOKPressed()) {
                return false;
            }
            this.dialog.setApplyVisible(true);
        }
        ShowViewCenterRenderer.setEnabled(!ShowViewCenterRenderer.isEnabled(pan), pan);
        pan.getRenderingManager().render("SHOW_CROSSHAIR");
        return true;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        ShowViewCenterInstallRenderer installRenderer = new ShowViewCenterInstallRenderer();
        installRenderer.initialize(context);
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.VIEW, MenuNames.MAP_DECORATIONS}, this.getName(), true, null, ShowViewCenterPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck multiEnableCheck = new MultiEnableCheck();
        multiEnableCheck.add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                ((JCheckBoxMenuItem)component).setSelected(ShowViewCenterRenderer.isEnabled(workbenchContext.getLayerViewPanel()));
                return null;
            }
        });
        return multiEnableCheck;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

