/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.FlexibleDateParser;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FeatureEventType;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.openjump.core.ui.plugin.AbstractUiPlugIn;

public class AutoAssignAttributePlugIn
extends AbstractUiPlugIn {
    private static String LAYER_COMBO_BOX = GenericNames.LAYER;
    private static String SELECTED_CHECK_BOX;
    private static String SELECT_ONLY_ON_ONE_LAYER;
    private static String TARGET_ATTRIBUTE_COMBO_BOX;
    private static String AUTOINC_CHECK_BOX;
    private static String INC_VALUE_EDIT_BOX;
    private static String AUTOINC_PATTERN_BOX;
    private static String AUTOINC_DESCRIPTION_1;
    private static String AUTOINC_DESCRIPTION_2;
    private static String FROM_SOURCE_CHECK_BOX;
    private static String SOURCE_COMBO_BOX;
    private static String FROM_SOURCE_DESCRIPTION;
    private static String SOURCE_DIFF_DESTINATION;
    private static String ASSIGN_VALUE_CHECK_BOX;
    private static String ASSIGN_VALUE_TEXT_BOX;
    private static String ASSIGN_VALUE_DESCRIPTION;
    private static String DESCRIPTION;
    private Layer layer;
    private boolean selectedFeaturesOnly = true;
    private String targetAttribute;
    private AttributeType destinationAttributeType;
    private boolean autoIncrement = false;
    private String pattern = "0";
    private int autoInc = 1;
    private int incValue;
    private String numeric;
    private boolean assignFromSource = false;
    private String sourceAttribute;
    private boolean assignValue = true;
    private String textToAssign;
    private Map<AttributeType, Converter> typeToConverterMap = new HashMap<AttributeType, Converter>(){
        {
            this.put(AttributeType.STRING, new Converter(){

                @Override
                public Object convert(String d) {
                    return d;
                }
            });
            this.put(AttributeType.INTEGER, new Converter(){

                @Override
                public Object convert(String d) {
                    if (d == null) {
                        return null;
                    }
                    try {
                        return Integer.parseInt(d);
                    }
                    catch (NumberFormatException nfe) {
                        return null;
                    }
                }
            });
            this.put(AttributeType.LONG, new Converter(){

                @Override
                public Object convert(String d) {
                    if (d == null) {
                        return null;
                    }
                    try {
                        return Long.parseLong(d);
                    }
                    catch (NumberFormatException nfe) {
                        return null;
                    }
                }
            });
            this.put(AttributeType.BOOLEAN, new Converter(){

                @Override
                public Object convert(String d) {
                    if (d == null || d.isEmpty()) {
                        return null;
                    }
                    try {
                        return Boolean.parseBoolean(d);
                    }
                    catch (NumberFormatException nfe) {
                        return null;
                    }
                }
            });
            this.put(AttributeType.DOUBLE, new Converter(){

                @Override
                public Object convert(String d) {
                    if (d == null) {
                        return null;
                    }
                    try {
                        return Double.parseDouble(d);
                    }
                    catch (NumberFormatException nfe) {
                        return null;
                    }
                }
            });
            this.put(AttributeType.DATE, new Converter(){
                final FlexibleDateParser parser = new FlexibleDateParser();

                @Override
                public Object convert(String d) {
                    if (d == null) {
                        return null;
                    }
                    try {
                        return this.parser.parse(d, true);
                    }
                    catch (ParseException nfe) {
                        return null;
                    }
                }
            });
        }
    };

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_ATTRIBUTES}, this.getName(), false, null, this.createEnableCheck(context.getWorkbenchContext()));
        SELECTED_CHECK_BOX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Selected-features-only");
        TARGET_ATTRIBUTE_COMBO_BOX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Target-attribute");
        SOURCE_COMBO_BOX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Source-attribute");
        FROM_SOURCE_CHECK_BOX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Assign-from-other-attribute");
        FROM_SOURCE_DESCRIPTION = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.From-source-description");
        SOURCE_DIFF_DESTINATION = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Source-and-destination-atributes-must-be-different");
        AUTOINC_CHECK_BOX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Auto-increment");
        AUTOINC_PATTERN_BOX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Auto-increment-pattern");
        INC_VALUE_EDIT_BOX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Increment-by");
        AUTOINC_DESCRIPTION_1 = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Auto-increment-description-1");
        AUTOINC_DESCRIPTION_2 = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Auto-increment-description-2");
        ASSIGN_VALUE_CHECK_BOX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Assign-fixed-value");
        ASSIGN_VALUE_TEXT_BOX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Assign-value");
        ASSIGN_VALUE_DESCRIPTION = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Assign-value-description");
        SELECT_ONLY_ON_ONE_LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Select-features-on-only-one-layer");
        DESCRIPTION = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AutoAssignAttributePlugIn.Description");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = this.prompt(context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        this.reportNothingToUndoYet(context);
        this.assignValues(context);
        return true;
    }

    private MultiInputDialog prompt(PlugInContext context) {
        boolean selectionExists;
        final MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        dialog.setSideBarDescription(DESCRIPTION);
        if (this.layer == null || !context.getLayerManager().getLayers().contains(this.layer) || context.getLayerManager().getEditableLayers().contains(this.layer)) {
            this.layer = context.getLayerableNamePanel().chooseEditableLayer();
        }
        dialog.addLayerComboBox(LAYER_COMBO_BOX, this.layer, null, context.getLayerManager().getEditableLayers());
        boolean bl = selectionExists = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().size() > 0;
        if (!selectionExists) {
            this.selectedFeaturesOnly = false;
        }
        dialog.addCheckBox(SELECTED_CHECK_BOX, this.selectedFeaturesOnly);
        dialog.setFieldVisible(SELECTED_CHECK_BOX, selectionExists);
        JComboBox<String> targetAttributeComboBox = dialog.addAttributeComboBox(TARGET_ATTRIBUTE_COMBO_BOX, LAYER_COMBO_BOX, new AttributeTypeFilter(222), "");
        for (int i = 0; i < targetAttributeComboBox.getModel().getSize(); ++i) {
            Object item = targetAttributeComboBox.getModel().getElementAt(i);
            if (!item.equals(this.targetAttribute)) continue;
            targetAttributeComboBox.setSelectedIndex(i);
        }
        dialog.addSeparator();
        final JRadioButton assignValueRB = dialog.addRadioButton(ASSIGN_VALUE_CHECK_BOX, "MODE", this.assignValue, null);
        dialog.addTextField(ASSIGN_VALUE_TEXT_BOX, "", 15, null, "");
        dialog.addSeparator();
        JRadioButton fromSourceRB = dialog.addRadioButton(FROM_SOURCE_CHECK_BOX, "MODE", this.assignFromSource, null);
        JComboBox<String> sourceAttributeComboBox = dialog.addAttributeComboBox(SOURCE_COMBO_BOX, LAYER_COMBO_BOX, AttributeTypeFilter.ALL_FILTER, "");
        for (int i = 0; i < sourceAttributeComboBox.getModel().getSize(); ++i) {
            Object item = sourceAttributeComboBox.getModel().getElementAt(i);
            if (!item.equals(this.sourceAttribute)) continue;
            sourceAttributeComboBox.setSelectedIndex(i);
        }
        this.initEnableChecks(dialog);
        dialog.addSeparator();
        JRadioButton autoIncRB = dialog.addRadioButton(AUTOINC_CHECK_BOX, "MODE", this.autoIncrement, null);
        dialog.addTextField(AUTOINC_PATTERN_BOX, this.pattern, 4, null, AUTOINC_DESCRIPTION_2);
        dialog.addIntegerField(INC_VALUE_EDIT_BOX, 1, 4, "");
        this.updateControls(dialog);
        targetAttributeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String attribute;
                Layer layer = dialog.getLayer(LAYER_COMBO_BOX);
                FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
                if (schema.getAttributeType(attribute = dialog.getText(TARGET_ATTRIBUTE_COMBO_BOX)) == AttributeType.BOOLEAN && AutoAssignAttributePlugIn.this.autoIncrement) {
                    assignValueRB.setSelected(true);
                }
                if (schema.getAttributeType(attribute) == AttributeType.DATE && AutoAssignAttributePlugIn.this.autoIncrement) {
                    assignValueRB.setSelected(true);
                }
                AutoAssignAttributePlugIn.this.updateControls(dialog);
            }
        });
        autoIncRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoAssignAttributePlugIn.this.updateControls(dialog);
            }
        });
        fromSourceRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoAssignAttributePlugIn.this.updateControls(dialog);
            }
        });
        assignValueRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoAssignAttributePlugIn.this.updateControls(dialog);
            }
        });
        return dialog;
    }

    private void updateControls(MultiInputDialog dialog) {
        this.layer = dialog.getLayer(LAYER_COMBO_BOX);
        FeatureSchema schema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
        this.targetAttribute = dialog.getText(TARGET_ATTRIBUTE_COMBO_BOX);
        this.destinationAttributeType = schema.getAttributeType(schema.getAttributeIndex(this.targetAttribute));
        this.assignFromSource = dialog.getBoolean(FROM_SOURCE_CHECK_BOX);
        this.autoIncrement = dialog.getBoolean(AUTOINC_CHECK_BOX);
        this.assignValue = dialog.getBoolean(ASSIGN_VALUE_CHECK_BOX);
        dialog.setFieldEnabled(AUTOINC_PATTERN_BOX, this.autoIncrement);
        dialog.setFieldEnabled(INC_VALUE_EDIT_BOX, this.autoIncrement);
        dialog.setFieldEnabled(SOURCE_COMBO_BOX, this.assignFromSource);
        dialog.setFieldEnabled(ASSIGN_VALUE_TEXT_BOX, this.assignValue);
        if (this.assignValue) {
            dialog.setSideBarDescription(ASSIGN_VALUE_DESCRIPTION);
        } else if (this.autoIncrement) {
            dialog.setSideBarDescription(AUTOINC_DESCRIPTION_1 + "\n\n" + AUTOINC_DESCRIPTION_2);
        } else if (this.assignFromSource) {
            dialog.setSideBarDescription(FROM_SOURCE_DESCRIPTION);
        } else {
            dialog.setSideBarDescription(DESCRIPTION);
        }
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.layer = dialog.getLayer(LAYER_COMBO_BOX);
        this.selectedFeaturesOnly = dialog.getBoolean(SELECTED_CHECK_BOX);
        FeatureSchema schema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
        this.targetAttribute = dialog.getText(TARGET_ATTRIBUTE_COMBO_BOX);
        this.destinationAttributeType = schema.getAttributeType(schema.getAttributeIndex(this.targetAttribute));
        this.autoIncrement = dialog.getBoolean(AUTOINC_CHECK_BOX);
        this.incValue = dialog.getInteger(INC_VALUE_EDIT_BOX);
        this.pattern = dialog.getText(AUTOINC_PATTERN_BOX);
        this.numeric = this.parseNumber(this.pattern);
        this.assignFromSource = dialog.getBoolean(FROM_SOURCE_CHECK_BOX);
        this.sourceAttribute = dialog.getText(SOURCE_COMBO_BOX);
        this.assignValue = dialog.getBoolean(ASSIGN_VALUE_CHECK_BOX);
        this.textToAssign = dialog.getText(ASSIGN_VALUE_TEXT_BOX);
        this.autoInc = this.autoIncrement ? (this.numeric.length() == 0 ? 0 : Integer.parseInt(this.numeric)) : 0;
    }

    private void initEnableChecks(final MultiInputDialog dialog) {
        dialog.addEnableChecks(SOURCE_COMBO_BOX, Collections.singletonList(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return AutoAssignAttributePlugIn.this.assignFromSource && dialog.getText(TARGET_ATTRIBUTE_COMBO_BOX).equals(dialog.getText(SOURCE_COMBO_BOX)) ? SOURCE_DIFF_DESTINATION : null;
            }
        }));
    }

    private String parseNumber(String text) {
        for (int i = 0; i < text.length(); ++i) {
            int e;
            if (!Character.isDigit(text.charAt(i))) continue;
            int b = i;
            for (e = i; e < text.length() && Character.isDigit(text.charAt(e)); ++e) {
            }
            return text.substring(b, e);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignValues(PlugInContext context) {
        Collection<Feature> features;
        final ArrayList<Feature> newFeatures = new ArrayList<Feature>();
        final ArrayList<Feature> oldFeatures = new ArrayList<Feature>();
        if (this.selectedFeaturesOnly) {
            Collection<Layer> layers = context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
            if (layers.size() > 1) {
                context.getWorkbenchFrame().warnUser(SELECT_ONLY_ON_ONE_LAYER);
            }
            features = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        } else {
            features = this.layer.getFeatureCollectionWrapper().getFeatures();
        }
        context.getLayerManager().getUndoableEditReceiver().startReceiving();
        for (Feature feature : features) {
            String s;
            if (this.autoIncrement) {
                String value = "" + this.autoInc;
                this.autoInc += this.incValue;
                s = this.numeric.length() == 0 ? value : this.pattern.replaceFirst(this.numeric, value);
            } else {
                Object v;
                s = this.assignFromSource ? ((v = feature.getAttribute(this.sourceAttribute)) == null ? null : v.toString()) : this.textToAssign;
            }
            Object object = this.typeToConverterMap.get(this.destinationAttributeType).convert(s);
            oldFeatures.add(feature.clone(false));
            Feature newFeature = feature.clone(false);
            newFeature.setAttribute(this.targetAttribute, object);
            newFeatures.add(newFeature);
        }
        this.layer.getLayerManager().getUndoableEditReceiver().startReceiving();
        try {
            UndoableCommand command = new UndoableCommand(I18N.getInstance().get(AutoAssignAttributePlugIn.class.getName())){

                @Override
                public void execute() {
                    Iterator i = newFeatures.iterator();
                    for (Feature f : features) {
                        f.setAttribute(AutoAssignAttributePlugIn.this.targetAttribute, ((Feature)i.next()).getAttribute(AutoAssignAttributePlugIn.this.targetAttribute));
                    }
                    AutoAssignAttributePlugIn.this.layer.getLayerManager().fireFeaturesAttChanged(features, FeatureEventType.ATTRIBUTES_MODIFIED, AutoAssignAttributePlugIn.this.layer, oldFeatures);
                }

                @Override
                public void unexecute() {
                    Iterator i = oldFeatures.iterator();
                    for (Feature f : features) {
                        f.setAttribute(AutoAssignAttributePlugIn.this.targetAttribute, ((Feature)i.next()).getAttribute(AutoAssignAttributePlugIn.this.targetAttribute));
                    }
                    AutoAssignAttributePlugIn.this.layer.getLayerManager().fireFeaturesAttChanged(features, FeatureEventType.ATTRIBUTES_MODIFIED, AutoAssignAttributePlugIn.this.layer, newFeatures);
                }
            };
            command.execute();
            this.layer.getLayerManager().getUndoableEditReceiver().receive(command.toUndoableEdit());
        }
        finally {
            this.layer.getLayerManager().getUndoableEditReceiver().stopReceiving();
        }
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastOneVisibleLayersMustBeEditableCheck());
    }

    private static interface Converter {
        public Object convert(String var1);
    }
}

