/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openjump.core.ui.plugin.style.ImportSLDPlugIn;
import org.w3c.dom.Document;

public class ImportArcMapStylePlugIn
extends AbstractPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        EnableCheckFactory enableCheckFactory = EnableCheckFactory.getInstance(context.getWorkbenchContext());
        MultiEnableCheck enableCheck = new MultiEnableCheck().add(enableCheckFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(enableCheckFactory.createExactlyNLayerablesMustBeSelectedCheck(1, Layerable.class));
        context.getFeatureInstaller().addMainMenuItem(this, new String[]{MenuNames.LAYER}, I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportArcMapStylePlugIn.name"), false, null, enableCheck);
    }

    private static File findArcMap2SLD(WorkbenchFrame wbframe, Blackboard bb) throws IOException, InterruptedException {
        int res;
        String arcmap2sld = (String)bb.get("ArcMapStylePlugin.toollocation");
        String executableName = "ArcGIS_SLD_Converter.exe";
        JFileChooser chooser = new JFileChooser(arcmap2sld);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "ArcGIS_SLD_Converter.exe";
            }

            @Override
            public boolean accept(File f) {
                return f.getName().equals("ArcGIS_SLD_Converter.exe");
            }
        });
        JOptionPane.showMessageDialog(wbframe, I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportArcMapStylePlugIn.Must-Select-Location-Of-Tool"), I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Question"), 1);
        if (arcmap2sld != null) {
            chooser.setSelectedFile(new File(arcmap2sld));
        }
        if ((res = chooser.showOpenDialog(wbframe)) == 0) {
            File am2sld = chooser.getSelectedFile();
            if (!am2sld.exists()) {
                return null;
            }
            bb.put("ArcMapStylePlugin.toollocation", am2sld.getAbsoluteFile().toString());
            return am2sld;
        }
        return null;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        int res;
        Blackboard bb = PersistentBlackboardPlugIn.get(context.getWorkbenchContext());
        WorkbenchFrame wbframe = context.getWorkbenchFrame();
        String fileName = (String)bb.get("ArcMapStylePlugin.filename");
        File am2sld = ImportArcMapStylePlugIn.findArcMap2SLD(wbframe, bb);
        if (am2sld == null) {
            return false;
        }
        ProcessBuilder pb = new ProcessBuilder(am2sld.toString());
        pb.start().waitFor();
        JOptionPane.showMessageDialog(wbframe, I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportArcMapStylePlugIn.Must-Select-Location-Of-SLD"), I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Question"), 1);
        JFileChooser chooser = new JFileChooser();
        if (fileName != null) {
            chooser.setCurrentDirectory(new File(fileName).getParentFile());
        }
        if ((res = chooser.showOpenDialog(context.getWorkbenchFrame())) == 0) {
            File f = chooser.getSelectedFile();
            if (!f.exists()) {
                return false;
            }
            bb.put("ArcMapStylePlugin.filename", f.getAbsoluteFile().toString());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(f);
            ImportSLDPlugIn.importSLD(doc, context);
        }
        return false;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportArcMapStylePlugIn.name");
    }
}

