/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster.statistics;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.StatisticIndices;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.Raster;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.Stats;
import org.openjump.core.rasterimage.sextante.OpenJUMPSextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridRasterWrapper;
import org.openjump.sextante.gui.additionalResults.AdditionalResults;

public class DEMStatisticsPlugIn
extends ThreadedBasePlugIn {
    private static final String R_MAX = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.maximum");
    private static final String R_MIN = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.minimum");
    private static final String R_MEAN = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.mean");
    private static final String R_STD = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.JoinAttributesSpatiallyPlugIn.standard-dev");
    private static final String NODATA = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.cell.nodata");
    private static final String NODATACELLS = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.nodatacell");
    private static final String VALIDCELLS = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.validcells");
    private static final String XMIN = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.xmin");
    private static final String YMIN = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.ymin");
    private static final String CELL_SIZE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.dimension_cell");
    private static final String COLUMNS = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.DEMStatisticsPlugIn.columns");
    private static final String ROWS = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.DEMStatisticsPlugIn.rows");
    private static final String RASTER_BANDS = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.file.bands_number");
    private static final String AREA = I18N.getInstance().get("ui.plugin.LayerStatisticsPlugIn.area");
    public static MultiInputDialog dialog;
    public static JPanel panel;
    private JList<RasterImageLayer> list;
    private final DefaultListModel<RasterImageLayer> listModel = new DefaultListModel();
    private JScrollPane scroller;
    private static final Dimension scroller_size;

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesOfTypeMustExistCheck(1, RasterImageLayer.class));
    }

    public int nodata(Raster ras, double nodata) throws IOException, RasterImageLayer.RasterDataNotFoundException {
        int counter = 0;
        int nx = ras.getWidth();
        int ny = ras.getHeight();
        for (int y = 0; y < ny; ++y) {
            for (int x = 0; x < nx; ++x) {
                double value = ras.getSampleDouble(x, y, 0);
                if (value != nodata) continue;
                ++counter;
            }
        }
        return counter;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        return true;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        List<RasterImageLayer> rlayers = context.getTask().getLayerManager().getLayerables(RasterImageLayer.class);
        dialog.addSubTitle(I18N.getInstance().get("ui.GenericNames.select-layers"));
        dialog.addLabel(I18N.getInstance().get("org.openjump.core.ui.plugin.raster.DEMStatisticsPlugIn.select-multiple-layers"));
        this.listModel.removeAllElements();
        for (RasterImageLayer currentLayer : rlayers) {
            this.listModel.addElement(currentLayer);
        }
        this.list = new JList<RasterImageLayer>(this.listModel);
        this.list.setFont(new Font(dialog.getFont().getName(), 1, 13));
        this.list.setSelectionMode(2);
        LayerNameRenderer layerListCellRenderer = new LayerNameRenderer();
        layerListCellRenderer.setCheckBoxVisible(false);
        layerListCellRenderer.setProgressIconLabelVisible(false);
        this.list.setCellRenderer(layerListCellRenderer);
        panel = new JPanel(new BorderLayout());
        panel.setMinimumSize(scroller_size);
        panel.setPreferredSize(scroller_size);
        panel.add(this.list);
        this.scroller = new JScrollPane(panel, 20, 30);
        dialog.addRow(this.scroller);
        dialog.setResizable(false);
        dialog.pack();
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.raster.DEMStatisticsPlugIn.name");
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("grid_statistics.png");
    }

    public double cellSizeX(Raster r, Envelope env) throws IOException {
        return env.getWidth() / (double)r.getWidth();
    }

    public double cellSizeY(Raster r, Envelope env) throws IOException {
        return env.getHeight() / (double)r.getHeight();
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        monitor.report(this.getName() + ": " + I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.FillPolygonTool.computing"));
        Locale locale = new Locale("en", "UK");
        String pattern = "###.########";
        DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        df.applyPattern("###.########");
        JTable jTable = new JTable();
        if (!dialog.wasOKPressed()) {
            return;
        }
        List<RasterImageLayer> rLayers = this.list.getSelectedValuesList();
        DefaultTableModel dtm = (DefaultTableModel)jTable.getModel();
        Object[] header = new Object[]{XMIN, YMIN, COLUMNS, ROWS, CELL_SIZE, AREA, RASTER_BANDS, R_MIN, R_MAX, R_MEAN, R_STD, NODATA, VALIDCELLS, NODATACELLS, StatisticIndices.NUM_CLASSES};
        dtm.addColumn((Object)I18N.getInstance().get("jump.plugin.qa.DiffGeometryPlugIn.Layer").toUpperCase(), header);
        for (Object e : rLayers) {
            String classes;
            String stddev;
            String mean;
            String max;
            String min;
            RasterImageLayer slayer = (RasterImageLayer)e;
            Stats stats = slayer.getMetadata().getStats();
            Raster raster = slayer.getRasterData(null);
            Double nodata = slayer.getNoDataValue();
            String bands = "" + slayer.getNumBands();
            if (slayer.getNumBands() > 1) {
                min = df.format(stats.getMin(0)) + "-" + df.format(stats.getMin(1)) + "-" + df.format(stats.getMin(2));
                max = df.format(stats.getMax(0)) + "-" + df.format(stats.getMax(1)) + "-" + df.format(stats.getMax(2));
                mean = df.format(stats.getMean(0)) + "-" + df.format(stats.getMean(1)) + "-" + df.format(stats.getMean(2));
                stddev = df.format(stats.getStdDev(0)) + "-" + df.format(stats.getStdDev(1)) + "-" + df.format(stats.getStdDev(2));
                classes = "--.";
            } else {
                min = df.format(stats.getMin(0));
                max = df.format(stats.getMax(0));
                mean = df.format(stats.getMean(0));
                stddev = df.format(stats.getStdDev(0));
                OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
                rstLayer.create(slayer, true);
                double[] data = GridRasterWrapper.rasterToArray(rstLayer, 0);
                StatisticIndices statUtils = new StatisticIndices();
                statUtils.calculateDescriptiveStatistics(data);
                classes = Integer.toString(statUtils.getClasses());
            }
            Envelope extent = slayer.getWholeImageEnvelope();
            String pattern1 = "###.## ";
            df.applyPattern("###.## ");
            double cellSizeX = this.cellSizeX(raster, extent);
            double cellSizeY = this.cellSizeY(raster, extent);
            String CELLSIZEX = df.format(cellSizeX);
            String CELLSIZEY = df.format(cellSizeY);
            String cellSize = CELLSIZEX + "x" + CELLSIZEY;
            String minx = df.format(extent.getMinX());
            String miny = df.format(extent.getMinY());
            int X = raster.getWidth();
            int Y = raster.getHeight();
            String nodataText = null;
            String texmin = df.format(stats.getMin(0));
            double nda = slayer.getNoDataValue();
            String begin = "<b><font color='red'>";
            String end = "</font></b>";
            if (nda == -3.40282346639E38 || nodata == -1.79769313486E308) {
                if (stats.getMin(0) == -9999.0 || stats.getMin(0) == -99999.0 || stats.getMin(0) == 1.70141E38) {
                    nodataText = "<b><font color='red'>" + nodata + "</font></b>";
                    min = "<b><font color='red'>" + texmin + "</font></b>";
                } else {
                    nodataText = Double.toString(nda);
                    min = texmin;
                }
            } else {
                nodataText = Double.toString(nda);
                min = texmin;
            }
            int nodatacells = this.nodata(raster, nodata);
            int validcells = X * Y - nodatacells;
            double area = (double)(raster.getWidth() * raster.getHeight()) * cellSizeX * cellSizeY;
            String TOT_AREA = df.format(area);
            Object[] layers = new Object[]{minx, miny, X, Y, cellSize, TOT_AREA, bands, min, max, mean, stddev, nodataText, validcells, nodatacells, classes};
            dtm.addColumn((Object)slayer.getName().toUpperCase(), layers);
        }
        JTable table = new JTable(dtm){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        table.setRowHeight(22);
        JScrollPane jScrollPane = new JScrollPane(table);
        table.setPreferredScrollableViewportSize(new Dimension(500, 300));
        AdditionalResults.addAdditionalResultAndShow(this.getName(), jScrollPane);
    }

    static {
        scroller_size = new Dimension(400, 200);
    }
}

