/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedBasePlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import it.betastudio.adbtoolbox.libs.FileOperations;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.algorithms.GenericRasterAlgorithm;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;
import org.openjump.core.ui.util.LayerableUtil;
import org.saig.core.gui.swing.sldeditor.util.FormUtils;

public class ManageDataPlugIn
extends ThreadedBasePlugIn {
    public static WorkbenchFrame frame = JUMPWorkbench.getInstance().getFrame();
    private I18N i18n = I18N.getInstance();
    private final String CHANGE_NODATA = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.ChangeNoDataValuePlugIn.name");
    private final String CHANGE_INTERVAL_TO_NODATA = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.ChangeRangeValuesToNoDataPlugIn.name");
    private final String FROM = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.from");
    private final String TO = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.to");
    private final String LOWER_VALUE = I18N.getInstance().get("com.vividsolutions.jump.util.Frequency.lower-value");
    private final String UPPER_VALUE = I18N.getInstance().get("com.vividsolutions.jump.util.Frequency.upper-value");
    private final String STATISTICS = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.CellStatistics");
    private final String NODATA = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.nodata");
    private final String MIN = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.min");
    private final String MAX = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.max");
    private final String ERROR = I18N.getInstance().get("ui.GenericNames.Error");
    private final String SELECT_BAND = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.HistogramPlugIn.select-one-band");
    private final String CHECK_FILE = I18N.getInstance().get("plugin.EnableCheckFactory.at-least-one-single-banded-layer-should-exist");
    private final String NO_OVERWRITE = I18N.getInstance().get("ui.GenericNames.cannot-overwrite-input-layer");
    private final ImageIcon icon16 = IconLoader.icon("fugue/folder-horizontal-open_16.png");
    private JTextField target_nodata;
    private JTextField source_nodata;
    private JTextField lv_field;
    private JTextField uv_field;
    private JTextField nd;
    private JTextField max;
    private JTextField min;
    private JLabel source_NoData_label;
    private JLabel target_NoData_label;
    private JLabel lv_label;
    private JLabel uv_label;
    JTextField jTextField_RasterOut = new JTextField();
    private JPanel mainPanel;
    private JPanel rangePanel;
    private JPanel resetPanel;
    private JPanel decimalPanel;
    private RasterImageLayer rLayer;
    private JComboBox<String> comboBox = new JComboBox();
    private JComboBox<RasterImageLayer> layerableComboBox = new JComboBox();
    private String UNIT;
    private JRadioButton radioMin = new JRadioButton();
    private JRadioButton radioMax = new JRadioButton();
    boolean minval = true;
    boolean maxval = false;
    double min_value;
    double max_value;
    private String path;
    private final SpinnerModel dimensionModel = new SpinnerNumberModel(2, 0, 25, 1);
    private JSpinner dimensionSpinner = new JSpinner();
    private Integer dimension;
    Envelope envWanted = new Envelope();
    Envelope fix = new Envelope();
    private MultiInputDialog dialog;
    private final String CLAYER = I18N.getInstance().get("ui.GenericNames.Source-Layer");
    private final String OUTPUT_FILE = I18N.getInstance().get("driver.DriverManager.file-to-save");
    private final String PROCESSING = I18N.getInstance().get("jump.plugin.edit.NoderPlugIn.processing");
    private final String NAME = I18N.getInstance().get("ui.plugin.raster.ManageDataPlugIn.Name");
    private final String CHECK = I18N.getInstance().get("ui.GenericNames.check-field");
    private final String ACTION = I18N.getInstance().get("ui.GenericNames.choose-an-action");
    private final String CHANGE_NODATA_TIP = I18N.getInstance().get("ui.plugin.raster.ManageDataPlugIn.change-nodata-and-tag-tip");
    private final String CHANGE_INTERVAL_TO_NODATA_TIP = I18N.getInstance().get("ui.plugin.raster.ManageDataPlugIn.Mask-with-no-data-tip");
    private final String EXTRACT_INTERVAL_TIP = I18N.getInstance().get("ui.plugin.raster.ManageDataPlugIn.Extract-range-data-tip");
    private final String EXTRACT_INTERVAL = I18N.getInstance().get("ui.plugin.raster.ManageDataPlugIn.Extract-range-data");
    private final String RESET_NODATA_TAG_TIP = I18N.getInstance().get("ui.plugin.raster.ManageDataPlugIn.Stretch-raster-tip");
    private final String RESET_NODATA_TAG = I18N.getInstance().get("ui.plugin.raster.ManageDataPlugIn.Stretch-raster");
    private final String SET_DECIMAL = I18N.getInstance().get("ui.plugin.raster.ManageDataPlugIn.Set-decimals");
    private final String SET_DECIMAL_TIP = I18N.getInstance().get("ui.plugin.raster.ManageDataPlugIn.Set-decimals-tip");
    private final String RESET_TO_MIN = I18N.getInstance().get("ui.plugin.raster.ManageDataPlugIn.Stretch-to-min");
    private final String RESET_TO_MAX = I18N.getInstance().get("ui.plugin.raster.ManageDataPlugIn.Stretch-to-max");
    List<RasterImageLayer> fLayers = new ArrayList<RasterImageLayer>();
    private final EnableCheck[] chengeDataCheck = new EnableCheck[]{new EnableCheck(){

        @Override
        public String check(JComponent component) {
            return ManageDataPlugIn.this.uv_field.getText().isEmpty() ? ManageDataPlugIn.this.CHECK.concat(": ").concat(ManageDataPlugIn.this.UPPER_VALUE) : null;
        }
    }, new EnableCheck(){

        @Override
        public String check(JComponent component) {
            return ManageDataPlugIn.this.lv_field.getText().isEmpty() ? ManageDataPlugIn.this.CHECK.concat(": ").concat(ManageDataPlugIn.this.LOWER_VALUE) : null;
        }
    }, new EnableCheck(){

        @Override
        public String check(JComponent component) {
            return Double.parseDouble(ManageDataPlugIn.this.lv_field.getText()) > Double.parseDouble(ManageDataPlugIn.this.uv_field.getText()) ? ManageDataPlugIn.this.ERROR + " :" + ManageDataPlugIn.this.LOWER_VALUE + ">" + ManageDataPlugIn.this.UPPER_VALUE + "!" : null;
        }
    }};
    private final EnableCheck[] chengeNoDataCheck = new EnableCheck[]{new EnableCheck(){

        @Override
        public String check(JComponent component) {
            return ManageDataPlugIn.this.target_nodata.getText().isEmpty() ? ManageDataPlugIn.this.CHECK.concat(": ").concat(ManageDataPlugIn.this.TO) : null;
        }
    }};
    private final EnableCheck[] saveCheck = new EnableCheck[]{new EnableCheck(){

        @Override
        public String check(JComponent component) {
            ManageDataPlugIn.this.rLayer = (RasterImageLayer)ManageDataPlugIn.this.dialog.getLayerable(ManageDataPlugIn.this.CLAYER);
            return ManageDataPlugIn.this.jTextField_RasterOut.getText().equals(ManageDataPlugIn.this.rLayer.getImageFileName()) ? ManageDataPlugIn.this.NO_OVERWRITE : null;
        }
    }, new EnableCheck(){

        @Override
        public String check(JComponent component) {
            return ManageDataPlugIn.this.jTextField_RasterOut.getText().isEmpty() ? ManageDataPlugIn.this.CHECK.concat(ManageDataPlugIn.this.OUTPUT_FILE) : null;
        }
    }};

    public MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesOfTypeMustExistCheck(1, RasterImageLayer.class)).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                ArrayList<RasterImageLayer> mLayer = new ArrayList<RasterImageLayer>();
                List<RasterImageLayer> rlayers = workbenchContext.getLayerManager().getLayerables(RasterImageLayer.class);
                for (RasterImageLayer currentLayer : rlayers) {
                    if (!LayerableUtil.isMonoband(currentLayer)) continue;
                    mLayer.add(currentLayer);
                }
                if (!mLayer.isEmpty()) {
                    return null;
                }
                String msg = null;
                if (mLayer.isEmpty()) {
                    msg = I18N.getInstance().get(ManageDataPlugIn.this.CHECK_FILE);
                }
                return msg;
            }
        });
    }

    private void setDialogValues(final MultiInputDialog dialog, PlugInContext context) throws IOException {
        dialog.setSideBarDescription(this.CHANGE_NODATA_TIP);
        this.rLayer = !context.getLayerNamePanel().selectedNodes(RasterImageLayer.class).isEmpty() ? (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class) : context.getTask().getLayerManager().getLayerables(RasterImageLayer.class).get(0);
        this.min_value = this.rLayer.getMetadata().getStats().getMin(0);
        this.max_value = this.rLayer.getMetadata().getStats().getMax(0);
        this.fLayers = context.getTask().getLayerManager().getLayerables(RasterImageLayer.class);
        this.layerableComboBox = dialog.addLayerableComboBox(this.CLAYER, this.rLayer, "", this.fLayers);
        this.layerableComboBox.setSize(200, this.layerableComboBox.getPreferredSize().height);
        this.layerableComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageDataPlugIn.this.updateValues(e, dialog);
                dialog.pack();
                dialog.repaint();
            }
        });
        ArrayList<String> srsArray = new ArrayList<String>();
        srsArray.add(this.CHANGE_NODATA);
        srsArray.add(this.CHANGE_INTERVAL_TO_NODATA);
        srsArray.add(this.EXTRACT_INTERVAL);
        srsArray.add(this.RESET_NODATA_TAG);
        srsArray.add(this.SET_DECIMAL);
        this.comboBox = dialog.addComboBox(this.ACTION, "", srsArray, null);
        this.comboBox.setSize(200, this.comboBox.getPreferredSize().height);
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageDataPlugIn.this.updateGUI(e, dialog);
                ManageDataPlugIn.this.updateValues(e, dialog);
                dialog.pack();
                dialog.repaint();
            }
        });
        dialog.addRow(this.statisticPanel());
        dialog.addRow("ChangeNoData", this.changeNoDataValuePanel(), this.chengeNoDataCheck, null);
        dialog.addRow("ChangeData", this.changeRangeToNoDataPanel(), this.chengeDataCheck, null);
        dialog.addRow(this.resetNoDataPanel());
        dialog.addRow(this.decimalPanel());
        this.rangePanel.setEnabled(false);
        this.rangePanel.setVisible(false);
        this.resetPanel.setVisible(false);
        this.decimalPanel.setEnabled(false);
        this.decimalPanel.setVisible(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("TIF", "tif");
        dialog.addRow("Save", this.createOutputFilePanel(filter), this.saveCheck, null);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.rLayer = (RasterImageLayer)dialog.getLayerable(this.CLAYER);
        this.UNIT = dialog.getText(this.ACTION);
        if (this.UNIT.equals(this.RESET_NODATA_TAG)) {
            this.minval = dialog.getBoolean(this.RESET_TO_MIN);
            this.maxval = dialog.getBoolean(this.RESET_TO_MAX);
        }
        this.dimension = (Integer)this.dimensionSpinner.getValue();
        this.path = this.getOutputFilePath();
        int i = this.path.lastIndexOf(46);
        if (i > 0) {
            this.path = this.path.substring(0, this.path.length() - this.path.length() + i);
        }
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.NAME, true);
        this.setDialogValues(this.dialog, context);
        if (this.fLayers.isEmpty()) {
            return false;
        }
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        if (this.dialog.wasOKPressed()) {
            this.getDialogValues(this.dialog);
            return true;
        }
        return false;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.report(this.PROCESSING);
        this.reportNothingToUndoYet(context);
        GenericRasterAlgorithm IO = new GenericRasterAlgorithm();
        int band = 0;
        if (this.rLayer.getNumBands() > 1) {
            Object[] bands = new String[]{"0", "1", "2"};
            String stringInput = (String)JOptionPane.showInputDialog(JUMPWorkbench.getInstance().getFrame(), this.SELECT_BAND, this.getName(), -1, null, bands, "0");
            try {
                band = Integer.parseInt(stringInput);
            }
            catch (NumberFormatException e) {
                return;
            }
        }
        File outFile = FileUtil.addExtensionIfNone(new File(this.path), "tif");
        if (this.UNIT.equals(this.CHANGE_NODATA)) {
            double newdata = Double.parseDouble(this.target_nodata.getText());
            double olddata = this.rLayer.getNoDataValue();
            IO.save_ChangeNoData(outFile, this.rLayer, band, olddata, newdata);
        } else if (this.UNIT.equals(this.CHANGE_INTERVAL_TO_NODATA)) {
            double mindata = Double.parseDouble(this.lv_field.getText());
            double maxdata = Double.parseDouble(this.uv_field.getText());
            IO.save_LimitValidData(outFile, this.rLayer, band, mindata, maxdata);
        } else if (this.UNIT.equals(this.EXTRACT_INTERVAL)) {
            double mindata = Double.parseDouble(this.lv_field.getText());
            double maxdata = Double.parseDouble(this.uv_field.getText());
            IO.save_ExtractValidData(outFile, this.rLayer, band, mindata, maxdata);
        } else if (this.UNIT.equals(this.RESET_NODATA_TAG)) {
            if (this.minval) {
                IO.save_ResetNoDataTag(outFile, this.rLayer, band, this.rLayer.getMetadata().getStats().getMin(0));
            } else if (this.maxval) {
                IO.save_ResetNoDataTag(outFile, this.rLayer, band, this.rLayer.getMetadata().getStats().getMax(0));
            }
        } else if (this.UNIT.equals(this.SET_DECIMAL)) {
            IO.save_ChangeDecimalValues(outFile, this.rLayer, band, this.dimension);
        }
        String catName = StandardCategoryNames.WORKING;
        try {
            catName = ((Category)context.getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        IO.load(outFile, catName);
    }

    private void updateValues(ActionEvent evt, MultiInputDialog dialog) {
        RasterImageLayer rasLayer = (RasterImageLayer)dialog.getLayerable(this.CLAYER);
        this.min.setText(rasLayer.getMetadata().getStats().getMin(0) + "");
        this.max.setText(rasLayer.getMetadata().getStats().getMax(0) + "");
        this.nd.setText(rasLayer.getNoDataValue() + "");
        this.source_nodata.setText(rasLayer.getNoDataValue() + "");
        this.lv_field.setText(this.min_value + "");
        this.uv_field.setText(this.max_value + "");
    }

    private void updateGUI(ActionEvent evt, MultiInputDialog dialog) {
        switch (this.comboBox.getSelectedIndex()) {
            case 0: {
                dialog.setSideBarDescription(this.CHANGE_NODATA_TIP);
                this.mainPanel.setEnabled(true);
                this.mainPanel.setVisible(true);
                this.rangePanel.setEnabled(false);
                this.rangePanel.setVisible(false);
                this.resetPanel.setEnabled(false);
                this.resetPanel.setVisible(false);
                this.decimalPanel.setVisible(false);
                this.decimalPanel.setEnabled(false);
                break;
            }
            case 1: {
                dialog.setSideBarDescription(this.CHANGE_INTERVAL_TO_NODATA_TIP);
                this.rangePanel.setEnabled(true);
                this.rangePanel.setVisible(true);
                this.rangePanel.setBorder(BorderFactory.createTitledBorder(this.CHANGE_INTERVAL_TO_NODATA));
                this.mainPanel.setEnabled(false);
                this.mainPanel.setVisible(false);
                this.resetPanel.setEnabled(false);
                this.resetPanel.setVisible(false);
                this.decimalPanel.setVisible(false);
                this.decimalPanel.setEnabled(false);
                break;
            }
            case 2: {
                dialog.setSideBarDescription(this.EXTRACT_INTERVAL_TIP);
                this.rangePanel.setEnabled(true);
                this.rangePanel.setVisible(true);
                this.rangePanel.setBorder(BorderFactory.createTitledBorder(this.EXTRACT_INTERVAL));
                this.mainPanel.setEnabled(false);
                this.mainPanel.setVisible(false);
                this.resetPanel.setEnabled(false);
                this.resetPanel.setVisible(false);
                this.decimalPanel.setEnabled(false);
                this.decimalPanel.setVisible(false);
                break;
            }
            case 3: {
                dialog.setSideBarDescription(this.RESET_NODATA_TAG_TIP);
                this.resetPanel.setEnabled(true);
                this.resetPanel.setVisible(true);
                this.mainPanel.setEnabled(false);
                this.mainPanel.setVisible(false);
                this.rangePanel.setEnabled(false);
                this.rangePanel.setVisible(false);
                this.decimalPanel.setEnabled(false);
                this.decimalPanel.setVisible(false);
                break;
            }
            case 4: {
                dialog.setSideBarDescription(this.SET_DECIMAL_TIP);
                this.decimalPanel.setEnabled(true);
                this.decimalPanel.setVisible(true);
                this.resetPanel.setEnabled(false);
                this.resetPanel.setVisible(false);
                this.mainPanel.setEnabled(false);
                this.mainPanel.setVisible(false);
                this.rangePanel.setEnabled(false);
                this.rangePanel.setVisible(false);
            }
        }
    }

    private JPanel statisticPanel() {
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        jPanel1.setBorder(BorderFactory.createTitledBorder(this.STATISTICS));
        this.nd = new JTextField(String.valueOf(this.rLayer.getNoDataValue()));
        this.nd.setEditable(false);
        this.max = new JTextField(this.max_value + "");
        this.max.setEditable(false);
        this.min = new JTextField(this.min_value + "");
        this.min.setEditable(false);
        JLabel nd_label = new JLabel(this.NODATA);
        JLabel min_label = new JLabel(this.MIN);
        JLabel max_label = new JLabel(this.MAX);
        FormUtils.addRowInGBL((JComponent)jPanel1, 1, 0, nd_label, (JComponent)this.nd);
        FormUtils.addRowInGBL((JComponent)jPanel1, 1, 2, min_label, (JComponent)this.min);
        FormUtils.addRowInGBL((JComponent)jPanel1, 1, 4, max_label, (JComponent)this.max);
        return jPanel1;
    }

    private JPanel resetNoDataPanel() {
        this.resetPanel = new JPanel(new GridBagLayout());
        this.resetPanel.setBorder(BorderFactory.createTitledBorder(this.RESET_NODATA_TAG));
        this.radioMin = new JRadioButton(this.RESET_TO_MIN);
        this.radioMin.setSelected(true);
        this.radioMax = new JRadioButton(this.RESET_TO_MAX);
        ButtonGroup group = new ButtonGroup();
        group.add(this.radioMin);
        group.add(this.radioMax);
        FormUtils.addRowInGBL(this.resetPanel, 1, 0, this.radioMin);
        FormUtils.addRowInGBL(this.resetPanel, 2, 0, this.radioMax);
        return this.resetPanel;
    }

    private JPanel decimalPanel() {
        this.decimalPanel = new JPanel(new GridBagLayout());
        this.decimalPanel.setBorder(BorderFactory.createTitledBorder(this.SET_DECIMAL));
        this.dimensionSpinner = new JSpinner(this.dimensionModel);
        this.dimensionSpinner.setSize(20, 10);
        FormUtils.addRowInGBL(this.decimalPanel, 1, 0, this.dimensionSpinner);
        return this.decimalPanel;
    }

    public JPanel changeNoDataValuePanel() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.source_NoData_label = new JLabel(this.FROM);
        this.target_NoData_label = new JLabel(this.TO);
        this.source_nodata = new JTextField(String.valueOf(this.rLayer.getNoDataValue()));
        this.source_nodata.setEditable(false);
        this.target_nodata = new JTextField("-99999");
        this.source_nodata.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char vChar = e.getKeyChar();
                if (!Character.isDigit(vChar) && vChar != '.' && vChar != '\b' && vChar != '\u007f') {
                    e.consume();
                }
            }
        });
        this.target_nodata.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char vChar = e.getKeyChar();
                if (!Character.isDigit(vChar) && vChar != '.' && vChar != '\b' && vChar != '\u007f' && vChar != '-') {
                    e.consume();
                }
            }
        });
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(this.CHANGE_NODATA));
        FormUtils.addRowInGBL((JComponent)this.mainPanel, 2, 0, this.source_NoData_label, (JComponent)this.source_nodata);
        FormUtils.addRowInGBL((JComponent)this.mainPanel, 2, 3, this.target_NoData_label, (JComponent)this.target_nodata);
        return this.mainPanel;
    }

    public JPanel changeRangeToNoDataPanel() {
        this.rangePanel = new JPanel(new GridBagLayout());
        this.lv_field = new JTextField(String.valueOf(this.rLayer.getMetadata().getStats().getMin(0)));
        this.lv_field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char vChar = e.getKeyChar();
                if (!Character.isDigit(vChar) && vChar != '.' && vChar != '\b' && vChar != '\u007f' && vChar != '-') {
                    e.consume();
                }
            }
        });
        this.uv_field = new JTextField(String.valueOf(this.rLayer.getMetadata().getStats().getMax(0)));
        this.uv_field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char vChar = e.getKeyChar();
                if (!Character.isDigit(vChar) && vChar != '.' && vChar != '\b' && vChar != '\u007f' && vChar != '-') {
                    e.consume();
                }
            }
        });
        this.lv_label = new JLabel(this.LOWER_VALUE);
        this.uv_label = new JLabel(this.UPPER_VALUE);
        this.rangePanel.setBorder(BorderFactory.createTitledBorder(this.CHANGE_INTERVAL_TO_NODATA));
        FormUtils.addRowInGBL((JComponent)this.rangePanel, 2, 0, this.lv_label, (JComponent)this.lv_field);
        FormUtils.addRowInGBL((JComponent)this.rangePanel, 2, 2, this.uv_label, (JComponent)this.uv_field);
        return this.rangePanel;
    }

    public JPanel createOutputFilePanel(final FileNameExtensionFilter filter) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.jTextField_RasterOut = new JTextField();
        JButton jButton_Dir = new JButton();
        this.jTextField_RasterOut.setText("");
        jButton_Dir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File outputPathFile = null;
                GUIUtil.FileChooserWithOverwritePrompting chooser = new GUIUtil.FileChooserWithOverwritePrompting();
                chooser.setDialogTitle(ManageDataPlugIn.this.getName());
                chooser.setFileSelectionMode(0);
                ((JFileChooser)chooser).setSelectedFile(FileOperations.lastVisitedFolder);
                chooser.setDialogType(1);
                GUIUtil.removeChoosableFileFilters(chooser);
                chooser.setFileFilter(filter);
                int ret = chooser.showOpenDialog(null);
                if (ret == 0) {
                    outputPathFile = FileUtil.removeExtensionIfAny(((JFileChooser)chooser).getSelectedFile());
                    ManageDataPlugIn.this.jTextField_RasterOut.setText(outputPathFile.getPath().concat(".tif"));
                    FileOperations.lastVisitedFolder = outputPathFile;
                }
            }
        });
        jLabel3.setText(this.OUTPUT_FILE);
        this.jTextField_RasterOut.setEditable(false);
        jButton_Dir.setIcon(this.icon16);
        this.jTextField_RasterOut.setPreferredSize(new Dimension(250, 20));
        FormUtils.addRowInGBL((JComponent)jPanel, 3, 0, this.OUTPUT_FILE, (JComponent)this.jTextField_RasterOut);
        FormUtils.addRowInGBL(jPanel, 3, 2, jButton_Dir);
        return jPanel;
    }

    public String getOutputFilePath() {
        return this.jTextField_RasterOut.getText();
    }

    @Override
    public String getName() {
        return this.NAME;
    }
}

