/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu.category;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openjump.core.ui.plugin.mousemenu.category.CategoryMover;

public class MoveCategoryToTop
extends AbstractPlugIn {
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        CategoryMover cm = new CategoryMover(context);
        Collection<Category> cats = context.getLayerNamePanel().getSelectedCategories();
        if (cats.size() > 1 || cats.size() <= 0) {
            String s = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.category.MoveCategoryOneDown.Only-a-single-category-can-be-moved");
            context.getWorkbenchFrame().warnUser(s);
            return false;
        }
        Object[] catsArray = cats.toArray();
        cm.moveCategoryToTop((Category)catsArray[0]);
        return true;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("bullet_arrow_top.png");
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.category.MoveCategoryToTop.Move-Category-To-Top");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        TitledPopupMenu layerNamePopupMenu = context.getWorkbenchContext().getWorkbench().getFrame().getCategoryPopupMenu();
        FeatureInstaller featInst = context.getFeatureInstaller();
        featInst.addPopupMenuItem(layerNamePopupMenu, this, this.getName() + "...", false, GUIUtil.toSmallIcon((ImageIcon)this.getIcon()), MoveCategoryToTop.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck multiEnableCheck = new MultiEnableCheck();
        multiEnableCheck.add(checkFactory.createAtLeastNCategoriesMustBeSelectedCheck(1));
        multiEnableCheck.add(checkFactory.createExactlyNCategoriesMustBeSelectedCheck(1));
        return multiEnableCheck;
    }
}

