/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu.category;

import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.util.List;

public class CategoryMover {
    protected PlugInContext context = null;

    public CategoryMover(PlugInContext context) {
        this.context = context;
    }

    protected Category getCategory(String name) {
        return this.context.getLayerManager().getCategory(name);
    }

    public void moveCategoryToPosition(String name, int pos) {
        this.moveCategoryToPosition(this.getCategory(name), pos);
    }

    public void moveCategoryToPosition(Category cat, int pos) {
        int i;
        LayerManager lm = this.context.getLayerManager();
        lm.setFiringEvents(false);
        List<Category> categories = lm.getCategories();
        int currentPos = categories.indexOf(cat);
        if (pos < 0 || pos == currentPos) {
            lm.setFiringEvents(true);
            return;
        }
        List<Layerable> layers = cat.getLayerables();
        Object[] layerArray = layers.toArray();
        for (i = 0; i < layerArray.length; ++i) {
            lm.remove((Layerable)layerArray[i]);
        }
        lm.setFiringEvents(true);
        lm.removeIfEmpty(cat);
        lm.addCategory(cat.getName(), Math.min(pos, categories.size()));
        for (i = 0; i < layerArray.length; ++i) {
            lm.addLayerable(cat.getName(), (Layerable)layerArray[i]);
        }
    }

    public void moveCategoryToTop(Category cat) {
        if (this.context.getLayerManager().getCategories().size() < 2) {
            return;
        }
        this.moveCategoryToPosition(cat, 0);
    }

    public void moveCategoryToBottom(Category cat) {
        List<Category> categories = this.context.getLayerManager().getCategories();
        if (categories.size() < 2) {
            return;
        }
        this.moveCategoryToPosition(cat, categories.size() - 1);
    }

    public void moveCategoryOneUp(Category cat) {
        List<Category> categories = this.context.getLayerManager().getCategories();
        if (categories.size() < 2) {
            return;
        }
        int currentPos = categories.indexOf(cat);
        this.moveCategoryToPosition(cat, currentPos - 1);
    }

    public void moveCategoryOneDown(Category cat) {
        List<Category> categories = this.context.getLayerManager().getCategories();
        if (categories.size() < 2) {
            return;
        }
        int currentPos = categories.indexOf(cat);
        this.moveCategoryToPosition(cat, currentPos + 1);
    }
}

