/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.mousemenu;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.MeasureLayerFinder;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class MeasureSelectedPlugIn
extends AbstractPlugIn {
    public static final String NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.MeasureSelectedFeaturePlugIn.name");
    public static final Icon ICON = IconLoader.icon("Ruler.gif");

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        LayerViewPanel layerViewPanel = context.getWorkbenchContext().getLayerViewPanel();
        WorkbenchContext wbc = context.getWorkbenchContext();
        Collection<Layer> layers = ((SelectionManagerProxy)((Object)wbc.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection().getLayersWithSelectedItems();
        for (Layer layer : layers) {
            SelectionManager manager = context.getLayerViewPanel().getSelectionManager();
            for (Feature feature : manager.createFeaturesFromSelectedItems(layer)) {
                try {
                    layerViewPanel.setViewportInitialized(true);
                    Geometry geom = feature.getGeometry();
                    if (!(geom instanceof Polygon) && !(geom instanceof LineString)) continue;
                    this.measure(wbc, geom);
                }
                catch (IllegalArgumentException e) {
                    context.getWorkbenchFrame().warnUser(e.toString());
                }
            }
        }
        return true;
    }

    public void measure(WorkbenchContext context, Geometry geom) {
        MeasureLayerFinder measureLayerFinder = new MeasureLayerFinder(context.getLayerViewPanel(), context);
        measureLayerFinder.setMeasure(geom);
        if (!measureLayerFinder.getLayer().isVisible()) {
            measureLayerFinder.getLayer().setVisible(true);
        }
    }

    public static EnableCheck createEnableCheck(final WorkbenchContext context) {
        MultiEnableCheck mec = new MultiEnableCheck();
        EnableCheckFactory f = EnableCheckFactory.getInstance(context);
        mec.add(f.createWindowWithSelectionManagerMustBeActiveCheck());
        mec.add(f.createExactlyNFeaturesMustBeSelectedCheck(1));
        mec.add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Feature feature = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().iterator().next();
                Geometry geom = feature.getGeometry();
                return geom instanceof GeometryCollection || geom instanceof Point ? geom.getGeometryType() + " - " + I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.MeasureSelectedFeaturePlugIn.message1") : null;
            }
        });
        return mec;
    }
}

