/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer.pirolraster.panel;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ColorPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterSymbology;
import org.openjump.core.ui.color.ColorGenerator;
import org.openjump.core.ui.plugin.layer.pirolraster.ChangeRasterImagePropertiesPlugIn;
import org.openjump.core.ui.swing.ValueChecker;
import org.saig.core.gui.swing.sldeditor.util.FormUtils;

public class RasterColorEditorPanel
extends JPanel
implements ValueChecker,
ActionListener,
StylePanel {
    public static final String COLOR_KEY = RasterColorEditorPanel.class.getName() + " - COLOR_TYPE";
    public static final String MIN_KEY = RasterColorEditorPanel.class.getName() + " - MIN_VAL";
    public static final String MAX_KEY = RasterColorEditorPanel.class.getName() + " - MAX_VAL";
    private static final long serialVersionUID = 1L;
    protected RasterImageLayer layer = null;
    public JTextField fromValue;
    private JLabel fromValueLabel;
    private JLabel toValueLabel;
    public JTextField toValue;
    public JTextField Chooser;
    public JComboBox colorScaleChooser;
    public JComboBox colorRampChooser;
    public JComboBox typeChooser;
    private ColorGenerator colorGenerator;
    private JSpinner spinnerbox;
    private String[] colorTableList = new String[]{I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Default-colors"), I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Green-Yellow-Red"), I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Blue-Green-Red"), I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Red-Blue"), "Red-Yellow", I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Black-White"), "Stripes sixties", I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Rainbow"), "Color Relief", "Topo", "Spectral (Color brewer)", "BrBG (Color brewer)", "RdBu (Color Brewer)", "RdYlBu (Color Bewer)", "RdYlGn (Color Bewer)", "Reds", "Greens", "Blues"};
    private JPanel strechedPanel = new JPanel();
    private JPanel statisticPanel = new JPanel(new GridBagLayout());
    private JTextField nodataField = new JTextField();
    private JTextField maxdataField = new JTextField();
    private JTextField mindataField = new JTextField();
    public JCheckBox transparentBox = new JCheckBox();
    public JCheckBox intervalsBox = new JCheckBox();
    public JCheckBox discreteBox = new JCheckBox();
    public JCheckBox invertBox = new JCheckBox();
    public JCheckBox intervalBox = new JCheckBox();
    public String fromValueText = new String();
    public String toValueText = new String();
    private JLabel classes = new JLabel();
    private PlugInContext plugInContext;
    private Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    private Border borderRaised = BorderFactory.createRaisedBevelBorder();
    private Color[] valuesColors;
    private LayoutManager layout = new BorderLayout();
    private JComponent comp;
    private LayoutManager gridBagLayout = new GridBagLayout();
    private ColorPanel NoDataColorPanel = new ColorPanel();
    private int alpha = 255;
    public int intColor;
    private String sToolTip = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.Choose-a-color-range-It-will-be-automaticaly-expanded-between-the-2-values");
    private String sFromValue = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.From-value");
    private String sToValue = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.To-value");
    private static String STATISTICS = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.CellStatistics");
    private static String TITLE = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.Raster-Color-Editor");
    private static String NUMBER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.ClassifyAttributesPlugin.Number-of-classes") + ":";
    private static String NODATA = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.nodata");
    private static String MIN = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.min");
    private static String MAX = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.nodata.max");
    private static String TRANSPARENT = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.Set-values-outside-transparent");
    private static String INVERT = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.Invert-colors");
    private static String INTERVALS = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.Intervals");
    SpinnerModel spinner;

    public RasterColorEditorPanel(PlugInContext context, RasterImageLayer actualLayer) {
        this.plugInContext = context;
        this.layer = actualLayer;
        this.setVisible(true);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.layout);
        this.statisticPanel.setBorder(BorderFactory.createTitledBorder(STATISTICS));
        this.nodataField = new JTextField(String.valueOf(this.layer.getNoDataValue()));
        this.nodataField.setEditable(false);
        this.maxdataField = new JTextField(String.valueOf(this.layer.getMetadata().getStats().getMax(0)));
        this.maxdataField.setEditable(false);
        this.mindataField = new JTextField(String.valueOf(this.layer.getMetadata().getStats().getMin(0)));
        this.mindataField.setEditable(false);
        JLabel nd_label = new JLabel(NODATA);
        JLabel min_label = new JLabel(MIN);
        JLabel max_label = new JLabel(MAX);
        FormUtils.addRowInGBL((JComponent)this.statisticPanel, 1, 0, nd_label, (JComponent)this.nodataField);
        FormUtils.addRowInGBL((JComponent)this.statisticPanel, 1, 2, min_label, (JComponent)this.mindataField);
        FormUtils.addRowInGBL((JComponent)this.statisticPanel, 1, 4, max_label, (JComponent)this.maxdataField);
        this.strechedPanel.setBorder(this.border);
        this.strechedPanel.setLayout(this.gridBagLayout);
        this.strechedPanel.setBorder(BorderFactory.createTitledBorder(TITLE));
        this.colorScaleChooser = new JComboBox<String>(this.colorTableList);
        this.colorScaleChooser.setToolTipText(this.sToolTip);
        this.colorScaleChooser.setBorder(this.borderRaised);
        this.intColor = this.colorScaleChooser.getSelectedIndex();
        this.colorScaleChooser.setSelectedIndex(this.intColor);
        FormUtils.addRowInGBL(this.strechedPanel, 2, 0, this.colorScaleChooser);
        this.fromValueLabel = new JLabel(this.sFromValue);
        this.toValueLabel = new JLabel(this.sToValue);
        this.fromValueLabel.setPreferredSize(new Dimension(83, 20));
        this.toValueLabel.setPreferredSize(new Dimension(83, 20));
        this.fromValue = new JTextField(Double.toString(this.layer.getMetadata().getStats().getMin(0)), 15);
        this.fromValue.setCaretPosition(0);
        this.fromValue.selectAll();
        this.toValue = new JTextField(Double.toString(this.layer.getMetadata().getStats().getMax(0)), 15);
        this.toValue.setCaretPosition(0);
        this.toValue.selectAll();
        this.fromValue.setPreferredSize(new Dimension(83, 20));
        this.fromValue.setCaretPosition(this.fromValue.getText().length());
        this.toValue.setPreferredSize(new Dimension(83, 20));
        this.toValue.setCaretPosition(this.toValue.getText().length());
        FormUtils.addRowInGBL((JComponent)this.strechedPanel, 3, 0, this.fromValueLabel, (JComponent)this.toValueLabel);
        FormUtils.addRowInGBL((JComponent)this.strechedPanel, 4, 0, this.fromValue, (JComponent)this.toValue);
        this.classes.setText(NUMBER);
        this.classes.setEnabled(false);
        this.intervalsBox = new JCheckBox("Show colors as intervals");
        this.intervalsBox.setSelected(false);
        this.intervalsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RasterColorEditorPanel.this.updateComponents();
            }
        });
        this.spinner = new SpinnerNumberModel(6, 2, 65, 1);
        this.spinnerbox = new JSpinner(this.spinner);
        this.spinnerbox.setEnabled(false);
        this.spinnerbox.setMinimumSize(new Dimension(60, 20));
        this.spinnerbox.setPreferredSize(new Dimension(60, 20));
        this.invertBox = new JCheckBox(INVERT);
        this.invertBox.setSelected(false);
        this.transparentBox = new JCheckBox(TRANSPARENT);
        this.transparentBox.setSelected(false);
        FormUtils.addRowInGBL(this.strechedPanel, 5, 0, this.getIntervalBox());
        FormUtils.addRowInGBL(this.strechedPanel, 6, 0, this.classes);
        FormUtils.addRowInGBL((JComponent)this.strechedPanel, 6, 1, (JComponent)this.spinnerbox, true, true);
        FormUtils.addRowInGBL(this.strechedPanel, 7, 0, this.invertBox);
        FormUtils.addRowInGBL(this.strechedPanel, 8, 0, this.transparentBox);
        if (this.layer.getNumBands() == 1) {
            this.add((Component)this.statisticPanel, "North");
            this.add((Component)this.strechedPanel, "South");
        }
    }

    private JCheckBox getIntervalBox() {
        if (this.intervalsBox == null) {
            this.intervalsBox = new JCheckBox();
            this.intervalsBox.setText(INTERVALS);
            this.intervalsBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RasterColorEditorPanel.this.updateComponents();
                }
            });
        }
        return this.intervalsBox;
    }

    private void updateComponents() {
        this.spinnerbox.setEnabled(this.intervalsBox.isSelected());
        this.classes.setEnabled(this.intervalsBox.isSelected());
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String validateInput() {
        return null;
    }

    @Override
    public boolean areValuesOk() {
        return true;
    }

    public void changeColorsRamp(WorkbenchContext context, Color[] colors, Color noDataColor, double min, double max) throws NoninvertibleTransformException, IOException {
        if (colors == null || colors.length == 0) {
            this.layer.setNeedToKeepImage(false);
            this.layer.flushImages(true);
            context.getLayerViewPanel().getViewport().update();
            return;
        }
        int step = 9;
        this.colorGenerator = new ColorGenerator(step, colors);
        RasterSymbology symbology = new RasterSymbology("RAMP");
        this.CopyColorIntoBlackBoard(context, this.layer, symbology);
        min = Double.parseDouble(this.fromValue.getText());
        max = Double.parseDouble(this.toValue.getText());
        double maxlayer = this.layer.getMetadata().getStats().getMax(0);
        double minlayer = this.layer.getMetadata().getStats().getMin(0);
        double interval = (max - min) / (double)this.colorGenerator.getSteps();
        symbology.addColorMapEntry(this.layer.getNoDataValue(), noDataColor);
        for (double i = minlayer; i < min; i += 1.0) {
            symbology.addColorMapEntry(i, new Color(202, 218, 186));
        }
        for (double j = maxlayer; j > max; j -= 1.0) {
            symbology.addColorMapEntry(j, new Color(202, 218, 186));
        }
        for (int c = 0; c < this.colorGenerator.getSteps(); ++c) {
            Color color = this.colorGenerator.getColor(c);
            double value = min + (double)c * interval;
            symbology.addColorMapEntry(value, color);
        }
        this.layer.setSymbology(symbology);
        if (this.transparentBox.isSelected()) {
            this.layer.setTransparentColor(new Color(202, 218, 186));
        }
    }

    public void changeColorsIntervals(WorkbenchContext context, Color[] colors, Color noDataColor, double min, double max) throws NoninvertibleTransformException, IOException {
        if (colors == null || colors.length == 0) {
            this.layer.setNeedToKeepImage(false);
            this.layer.flushImages(true);
            context.getLayerViewPanel().getViewport().update();
            return;
        }
        int step = (Integer)this.spinner.getValue();
        this.colorGenerator = new ColorGenerator(step, colors);
        RasterSymbology symbology = new RasterSymbology("INTERVALS");
        this.CopyColorIntoBlackBoard(context, this.layer, symbology);
        min = Double.parseDouble(this.fromValue.getText());
        max = Double.parseDouble(this.toValue.getText());
        double maxlayer = this.layer.getMetadata().getStats().getMax(0);
        double minlayer = this.layer.getMetadata().getStats().getMin(0);
        double interval = (max - min) / (double)this.colorGenerator.getSteps();
        symbology.addColorMapEntry(this.layer.getNoDataValue(), noDataColor);
        for (double i = minlayer; i < min; i += 1.0) {
            symbology.addColorMapEntry(i, new Color(202, 218, 186));
        }
        for (double j = maxlayer; j > max; j -= 1.0) {
            symbology.addColorMapEntry(j, new Color(202, 218, 186));
        }
        for (int c = 0; c < this.colorGenerator.getSteps(); ++c) {
            Color color = this.colorGenerator.getColor(c);
            double value = min + (double)c * interval;
            symbology.addColorMapEntry(value, color);
        }
        this.layer.setSymbology(symbology);
        if (this.transparentBox.isSelected()) {
            this.layer.setTransparentColor(new Color(202, 218, 186));
        }
    }

    @Override
    public void updateStyles() {
        switch (this.colorScaleChooser.getSelectedIndex()) {
            case 0: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{Color.BLACK, Color.WHITE};
                    break;
                }
                this.valuesColors = new Color[]{Color.WHITE, Color.BLACK};
                break;
            }
            case 1: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{Color.RED, Color.YELLOW, Color.GREEN};
                    break;
                }
                this.valuesColors = new Color[]{Color.GREEN, Color.YELLOW, Color.RED};
                break;
            }
            case 2: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{Color.RED, Color.GREEN, Color.BLUE};
                    break;
                }
                this.valuesColors = new Color[]{Color.BLUE, Color.GREEN, Color.RED};
                break;
            }
            case 3: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{Color.BLUE, Color.RED};
                    break;
                }
                this.valuesColors = new Color[]{Color.RED, Color.BLUE};
                break;
            }
            case 4: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{Color.YELLOW, Color.RED};
                    break;
                }
                this.valuesColors = new Color[]{Color.RED, Color.YELLOW};
                break;
            }
            case 5: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{Color.BLACK, Color.WHITE};
                    break;
                }
                this.valuesColors = new Color[]{Color.WHITE, Color.BLACK};
                break;
            }
            case 6: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{Color.WHITE, Color.BLACK, Color.WHITE, Color.BLACK, Color.WHITE, Color.BLACK, Color.WHITE, Color.BLACK, Color.WHITE, Color.BLACK, Color.WHITE, Color.BLACK};
                    break;
                }
                this.valuesColors = new Color[]{Color.BLACK, Color.WHITE, Color.BLACK, Color.WHITE, Color.BLACK, Color.WHITE, Color.BLACK, Color.WHITE, Color.BLACK, Color.WHITE, Color.BLACK, Color.WHITE};
                break;
            }
            case 7: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, Color.decode("#4B0082"), Color.decode("#9400D3")};
                    break;
                }
                this.valuesColors = new Color[]{Color.decode("#9400D3"), Color.decode("#4B0082"), Color.BLUE, Color.GREEN, Color.YELLOW, Color.ORANGE, Color.RED};
                break;
            }
            case 8: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{new Color(215, 244, 244), new Color(200, 55, 55), new Color(224, 108, 31), new Color(251, 255, 128), new Color(46, 154, 88)};
                    break;
                }
                this.valuesColors = new Color[]{new Color(46, 154, 88), new Color(251, 255, 128), new Color(224, 108, 31), new Color(200, 55, 55), new Color(215, 244, 244)};
                break;
            }
            case 9: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{new Color(76, 0, 255), new Color(0, 46, 255), new Color(0, 229, 255), new Color(77, 255, 0), new Color(255, 255, 0), new Color(255, 222, 89), new Color(255, 224, 179)};
                    break;
                }
                this.valuesColors = new Color[]{new Color(255, 224, 179), new Color(255, 222, 89), new Color(255, 255, 0), new Color(77, 255, 0), new Color(0, 229, 255), new Color(0, 46, 255), new Color(76, 0, 255)};
                break;
            }
            case 10: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{new Color(43, 131, 186), new Color(171, 221, 164), new Color(255, 255, 191), new Color(253, 174, 97), new Color(215, 25, 28)};
                    break;
                }
                this.valuesColors = new Color[]{new Color(215, 25, 28), new Color(253, 174, 97), new Color(255, 255, 191), new Color(171, 221, 164), new Color(43, 131, 186)};
                break;
            }
            case 11: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{new Color(1, 133, 113), new Color(128, 205, 193), new Color(245, 245, 245), new Color(223, 194, 125), new Color(166, 97, 26)};
                    break;
                }
                this.valuesColors = new Color[]{new Color(166, 97, 26), new Color(223, 194, 125), new Color(245, 245, 245), new Color(128, 205, 193), new Color(1, 133, 113)};
                break;
            }
            case 12: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{new Color(5, 113, 176), new Color(146, 197, 222), new Color(247, 247, 247), new Color(244, 165, 130), new Color(202, 0, 32)};
                    break;
                }
                this.valuesColors = new Color[]{new Color(202, 0, 32), new Color(244, 165, 130), new Color(247, 247, 247), new Color(146, 197, 222), new Color(5, 113, 176)};
                break;
            }
            case 13: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{new Color(44, 123, 182), new Color(171, 217, 233), new Color(255, 255, 191), new Color(253, 174, 97), new Color(215, 25, 28)};
                    break;
                }
                this.valuesColors = new Color[]{new Color(215, 25, 28), new Color(253, 174, 97), new Color(255, 255, 191), new Color(171, 217, 233), new Color(44, 123, 182)};
                break;
            }
            case 14: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{new Color(26, 150, 65), new Color(166, 217, 106), new Color(255, 255, 191), new Color(253, 174, 97), new Color(215, 25, 28)};
                    break;
                }
                this.valuesColors = new Color[]{new Color(215, 25, 28), new Color(253, 174, 97), new Color(255, 255, 191), new Color(166, 217, 106), new Color(26, 150, 65)};
                break;
            }
            case 15: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{Color.RED, Color.WHITE};
                    break;
                }
                this.valuesColors = new Color[]{Color.WHITE, Color.RED};
                break;
            }
            case 16: {
                if (this.invertBox.isSelected()) {
                    this.valuesColors = new Color[]{Color.GREEN, Color.WHITE};
                    break;
                }
                this.valuesColors = new Color[]{Color.WHITE, Color.GREEN};
                break;
            }
            case 17: {
                this.valuesColors = this.invertBox.isSelected() ? new Color[]{Color.BLUE, Color.WHITE} : new Color[]{Color.WHITE, Color.BLUE};
            }
        }
        try {
            if (this.intervalsBox.isSelected()) {
                this.changeColorsIntervals(this.plugInContext.getWorkbenchContext(), this.valuesColors, GUIUtil.alphaColor(this.NoDataColorPanel.getFillColor(), this.alpha), Float.parseFloat(this.fromValue.getText()), Float.parseFloat(this.toValue.getText()));
            } else {
                this.changeColorsRamp(this.plugInContext.getWorkbenchContext(), this.valuesColors, GUIUtil.alphaColor(this.NoDataColorPanel.getFillColor(), this.alpha), Float.parseFloat(this.fromValue.getText()), Float.parseFloat(this.toValue.getText()));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.setVisible(false);
        this.layer.fireAppearanceChanged();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateStyles();
    }

    public void CopyColorIntoBlackBoard(WorkbenchContext context, RasterImageLayer layer, RasterSymbology symbology) throws NoninvertibleTransformException {
        String bboardKey = ChangeRasterImagePropertiesPlugIn.class.getName() + "-" + layer.getUUID() + " - COLORSTYLE";
        context.getBlackboard().put(bboardKey, this);
        layer.setSymbology(symbology);
        context.getLayerManager().fireLayerChanged(layer, LayerEventType.APPEARANCE_CHANGED);
    }
}

