/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;

public class ToggleVisibilityPlugIn
extends AbstractPlugIn {
    private static final String toggleVisibility = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ToggleVisibilityPlugIn");
    private static final String errorSeeOutputWindow = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ToggleVisibilityPlugIn.Error-See-Output-Window");
    private static final String layerName = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Layer-Name");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        WorkbenchContext workbenchContext = context.getWorkbenchContext();
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        TitledPopupMenu layerNamePopupMenu = workbenchContext.getWorkbench().getFrame().getLayerNamePopupMenu();
        featureInstaller.addPopupMenuItem(layerNamePopupMenu, this, toggleVisibility + "{pos:2}", true, GUIUtil.toSmallIcon((ImageIcon)this.getIcon()), ToggleVisibilityPlugIn.createEnableCheck(workbenchContext));
        TitledPopupMenu wmsLayerNamePopupMenu = workbenchContext.getWorkbench().getFrame().getWMSLayerNamePopupMenu();
        featureInstaller.addPopupMenuItem(wmsLayerNamePopupMenu, this, toggleVisibility + "{pos:2}", true, GUIUtil.toSmallIcon((ImageIcon)this.getIcon()), ToggleVisibilityPlugIn.createEnableCheck(workbenchContext));
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("eye.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        try {
            Collection<Layerable> layerCollection = context.getWorkbenchContext().getLayerNamePanel().selectedNodes(Layerable.class);
            boolean firingEvents = context.getLayerManager().isFiringEvents();
            context.getLayerManager().setFiringEvents(false);
            try {
                for (Layerable layer : layerCollection) {
                    layer.setVisible(!layer.isVisible());
                }
            }
            finally {
                context.getLayerManager().setFiringEvents(firingEvents);
                context.getLayerViewPanel().repaint();
                context.getWorkbenchFrame().repaint();
            }
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser(errorSeeOutputWindow);
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText("ToggleVisibilityPlugIn Exception:" + e.toString());
            return false;
        }
        return true;
    }

    public static MultiEnableCheck createEnableCheck(final WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck mec = new MultiEnableCheck();
        mec.add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck());
        mec.add(checkFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, Layerable.class));
        mec.add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Collection<Layerable> layers = workbenchContext.createPlugInContext().getSelectedLayerables();
                Layerable layer = layers.iterator().next();
                ((JCheckBoxMenuItem)component).setSelected(layer != null && layer.isVisible());
                return null;
            }
        });
        return mec;
    }
}

