/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.HTMLPanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreQueryDataSource;
import com.vividsolutions.jump.workbench.ui.renderer.style.AlphaSetting;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.io.FilenameUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.ccordsys.utils.ProjUtils;
import org.openjump.core.ccordsys.utils.SRSInfo;
import org.openjump.core.ui.swing.DetachableInternalFrame;

public class NewLayerPropertiesPlugIn
extends AbstractPlugIn {
    private static String LAYER_PROPERTIES = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Layer-Properties");
    private static String INFO = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Info");
    private static String LAYERS = I18N.getInstance().get("demo.layerviewpanel.MapTab.layers");
    private static String NUMBER_OF_FEATURES = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Number-of-Features");
    private static String NUMBER_OF_POINTS = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Number-of-Points");
    private static String GEOMETRY_TYPE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Geometry-Type");
    private static String NUMBER_OF_ATTRIBUTES = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Number-of-Attributes");
    private static String DATASOURCE_CLASS = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.DataSource-Class");
    private static String SOURCE_PATH = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Source-Path");
    private static String NO_FEATURES = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.No-Features");
    private static String FEATURES = I18N.getInstance().get("ui.AttributeTablePanel.features");
    private static String TRANSPARENCY = I18N.getInstance().get("ui.renderer.style.ColorThemingPanel.transparency");
    private static String MULTIPLE_GEOMETRY_TYPES = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Multiple-geometry-types");
    private static String MULTIPLE_SOURCE_TYPES = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Multiple-Source-Types");
    private static String NULL_GEOMETRIES = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Null-Geometries");
    private static String NOT_SAVED = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Not-Saved");
    private static String AVERAGE_PER_LAYER = " (" + I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.average-per-layer") + ")";
    private static String MULTIPLE_SOURCES = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Multiple-Sources");
    private static String STYLES = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Styles");
    private static String PROPORTIONAL_TRANSPARENCY_ADJUSTER = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Proportional-Transparency-Adjustment");
    private static String CHARSET = I18N.getInstance().get("org.openjump.core.ui.io.file.DataSourceFileLayerLoader.charset");
    private static String EXTENT = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.extent");
    private static String XMIN = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.xmin");
    private static String YMIN = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.ymin");
    private static String XMAX = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.xmax");
    private static String YMAX = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.ymax");
    private static String NAME = I18N.getInstance().get("jump.workbench.ui.plugin.datastore.ConnectionDescriptorPanel.Name");
    private static String IMAGE = I18N.getInstance().get("ui.plugin.imagery.AddImageLayerPlugIn.Image");
    private static String PROJECTION_UNSPECIFIED = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.unknown_projection");
    private static String GEO_METADATA = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.geographic_metadata");
    private static String CRS = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.SRS");
    private static String COORDINATE_SYSTEM = I18N.getInstance().get("ui.plugin.wms.EditWMSQueryPanel.coordinate-reference-system");
    private final String NODATASOURCELAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.nodatasourcelayer.message");
    private final String MODIFIED = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Modified");
    private static String CANCEL = I18N.getInstance().get("ui.OKCancelPanel.cancel");
    private static String OK = I18N.getInstance().get("ui.OKCancelPanel.ok");
    private static String CATALOG_FILE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Catalog_file");
    private static String SRID_CODE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.SRID_code");
    private static String WFS_LAYER_NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Local_layer_name");
    private static String WFS_SERVER = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.URL");
    private static String WEB_SERVICE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Web_Service");
    private static String DATASOURCE = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.DataSource");
    private Layer[] layers;
    private Envelope extent;
    private int[] currTransArray;
    private boolean styleChanged = false;
    public static final String Test = "Test";
    private final String bgColor0 = "\"#FEEDD6\"";
    private final String bgColor1 = "\"#EAEAEA\"";
    private final String bgColor3 = "\"#FBFFE1\"";
    private final String bgColor4 = "\"#CCCCCC\"";

    @Override
    public ImageIcon getIcon() {
        return IconLoader.icon("information_16x16.png");
    }

    @Override
    public String getName() {
        return LAYER_PROPERTIES;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.styleChanged = false;
        this.layers = context.getSelectedLayers();
        this.extent = context.getSelectedLayerEnvelope();
        this.currTransArray = new int[this.layers.length];
        for (int i = 0; i < this.layers.length; ++i) {
            this.currTransArray[i] = 255 - NewLayerPropertiesPlugIn.getAlpha(this.layers[i]);
        }
        final ArrayList<Collection<Style>> oldStyleList = new ArrayList<Collection<Style>>(this.layers.length);
        for (Layer layer : this.layers) {
            oldStyleList.add(layer.cloneStyles());
        }
        InfoPanel infoPanel = new InfoPanel();
        StylePanel stylePanel = new StylePanel();
        infoPanel.setPreferredSize(new Dimension(350, 200));
        JTabbedPane tabbedPane = new JTabbedPane();
        final DetachableInternalFrame frame = new DetachableInternalFrame();
        if (this.layers.length == 1) {
            frame.setTitle(LAYER_PROPERTIES + ": " + this.layers[0].getName());
        } else {
            frame.setTitle(LAYER_PROPERTIES + ": " + MULTIPLE_SOURCES);
        }
        frame.setIconifiable(true);
        frame.setFrameIcon(GUIUtil.pad(IconLoader.icon("information_12x12.png"), 1));
        CompoundBorder mainComponentBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        tabbedPane.setBorder(mainComponentBorder);
        tabbedPane.addTab(INFO, this.getIcon(), infoPanel, "");
        tabbedPane.addTab(TRANSPARENCY, null, stylePanel, "");
        JButton okButton = new JButton(OK){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 25);
            }
        };
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        JButton cancelButton = new JButton(CANCEL){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 25);
            }
        };
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (oldStyleList != null) {
                    int j = 0;
                    for (Layer layer : NewLayerPropertiesPlugIn.this.layers) {
                        layer.setStyles((Collection)oldStyleList.get(j++));
                    }
                }
                frame.dispose();
            }
        });
        JPanel okCancelPane = new JPanel();
        okCancelPane.add(okButton);
        okCancelPane.add(cancelButton);
        if (!this.styleChanged) {
            this.reportNothingToUndoYet(context);
        }
        frame.add((Component)tabbedPane, "Center");
        frame.add((Component)okCancelPane, "South");
        frame.setClosable(true);
        frame.setResizable(true);
        frame.setMaximizable(true);
        frame.setSize(550, 400);
        frame.setVisible(true);
        frame.setIcon(true);
        context.getWorkbenchFrame().addInternalFrame(frame, true, true);
        return true;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    public static ColorThemingStyle getColorThemingStyleIfEnabled(Layer layer) {
        ColorThemingStyle someStyle = null;
        for (Style style : layer.getStyles()) {
            if (!(style instanceof ColorThemingStyle) || !style.isEnabled()) continue;
            someStyle = (ColorThemingStyle)style;
        }
        return someStyle;
    }

    public static int getAlpha(Layer layer) {
        ColorThemingStyle cts = NewLayerPropertiesPlugIn.getColorThemingStyleIfEnabled(layer);
        if (cts != null) {
            return cts.getDefaultStyle().getAlpha();
        }
        List<Style> styles = layer.getStylesIfEnabled(AlphaSetting.class);
        Iterator<Style> localIterator = styles.iterator();
        if (localIterator.hasNext()) {
            Style style = localIterator.next();
            return ((AlphaSetting)((Object)style)).getAlpha();
        }
        return 128;
    }

    public static void setAlpha(Layer layer, int alpha) {
        List<Style> styles = layer.getStyles(AlphaSetting.class);
        for (Style style : styles) {
            ((AlphaSetting)((Object)style)).setAlpha(alpha);
        }
        ColorThemingStyle cts = NewLayerPropertiesPlugIn.getColorThemingStyleIfEnabled(layer);
        if (cts != null) {
            cts.setAlpha(alpha);
        }
    }

    public String header(String textA, String textB) {
        return "  <tr valign=\"top\">     <td width=\"550\" height=\"12\" bgcolor=\"#FBFFE1\"align=\"center\"><font face=\"Arial\" size=\"3\" align=\"right\"><b>" + textA + "</b></font></td>     <td width=\"1586\" height=\"12\" bgcolor=" + "\"#FBFFE1\"" + "align=\"center\"><font face=\"Arial\" size=\"3\"><b>" + textB + "</b></font></td>  </tr>";
    }

    public String property(String textA, String textB, String color) {
        return "  <tr valign=\"top\">     <td width=\"550\" height=\"12\" bgcolor=\"#CCCCCC\"align=\"right\"><font face=\"Arial\" size=\"3\" align=\"right\">" + textA + "</font></td>     <td width=\"1586\" height=\"12\" bgcolor=" + color + "align=\"left\"><font face=\"Arial\" size=\"3\" >" + textB + "</font></td>  </tr>";
    }

    public static String vectorFileSourcePath(Layer layer) {
        DataSourceQuery dsq;
        String fileSourcePath = "";
        if (layer.getDataSourceQuery() != null && (dsq = layer.getDataSourceQuery()).getDataSource() != null) {
            Map<String, Object> map = dsq.getDataSource().getProperties();
            if (map.get("Uri") != null) {
                fileSourcePath = ((URI)map.get("Uri")).getPath();
            } else if (map.get("File") != null) {
                fileSourcePath = map.get("File").toString();
            }
        }
        return fileSourcePath;
    }

    public static String imageFileSourcePath(Layer layer) {
        String fileSourcePath = "";
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        for (Feature feature : featureCollection) {
            String sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
            sourcePathImage = sourcePathImage.substring(5);
            File f = new File(sourcePathImage);
            String filePath = f.getAbsolutePath();
            fileSourcePath = filePath.replace("%20", " ");
        }
        return fileSourcePath;
    }

    public static String imageFileExtension(Layer layer) {
        String fileSourcePath = "";
        FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
        for (Feature feature : featureCollection) {
            String sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
            sourcePathImage = sourcePathImage.substring(5);
            File f = new File(sourcePathImage);
            String filePath = f.getAbsolutePath();
            fileSourcePath = filePath.replace("%20", " ");
        }
        String extension = FileUtil.getExtension(fileSourcePath).toUpperCase();
        return extension;
    }

    private class StylePanel
    extends JPanel
    implements PropertyPanel {
        private static final long serialVersionUID = 1L;
        private JSlider transparencySlider = new JSlider();

        private StylePanel() {
            Box box = new Box(1);
            this.setBorder(BorderFactory.createTitledBorder(PROPORTIONAL_TRANSPARENCY_ADJUSTER));
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            int value = 0;
            for (int i = -100; i <= 100 && i >= -100; i += 20) {
                labelTable.put(value, new JLabel(Integer.toString(i)));
                value += 10;
            }
            this.transparencySlider.setMinimumSize(new Dimension(200, 20));
            this.transparencySlider.setPreferredSize(new Dimension(460, 50));
            this.transparencySlider.setPaintLabels(true);
            this.transparencySlider.setPaintTicks(true);
            this.transparencySlider.setLabelTable(labelTable);
            this.transparencySlider.setMajorTickSpacing(10);
            this.transparencySlider.setMinimum(0);
            this.transparencySlider.setMaximum(100);
            this.transparencySlider.setValue(50);
            box.add(this.transparencySlider);
            this.add(box);
            this.transparencySlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    if (!source.getValueIsAdjusting()) {
                        int sliderVal = source.getValue();
                        for (int i = 0; i < NewLayerPropertiesPlugIn.this.layers.length; ++i) {
                            double percentChg;
                            Layer layer = NewLayerPropertiesPlugIn.this.layers[i];
                            int currTrans = NewLayerPropertiesPlugIn.this.currTransArray[i];
                            double newTrans = currTrans;
                            if (sliderVal < 50) {
                                percentChg = (double)(50 - sliderVal) / 50.0;
                                newTrans = (double)currTrans + (double)(255 - currTrans) * percentChg;
                            } else if (sliderVal > 50) {
                                percentChg = (double)(sliderVal - 50) / 50.0;
                                newTrans = (double)currTrans - (double)currTrans * percentChg;
                            }
                            NewLayerPropertiesPlugIn.setAlpha(layer, 255 - (int)newTrans);
                            layer.fireAppearanceChanged();
                            NewLayerPropertiesPlugIn.this.styleChanged = true;
                        }
                    }
                }
            });
        }

        @Override
        public String getTitle() {
            return STYLES;
        }

        @Override
        public void updateStyles() {
        }

        @Override
        public String validateInput() {
            return null;
        }
    }

    static interface PropertyPanel {
        public String getTitle();

        public void updateStyles();

        public String validateInput();
    }

    private class InfoPanel
    extends HTMLPanel
    implements PropertyPanel {
        private static final long serialVersionUID = 1L;
        private String label_Name_R = "";
        private String label_NumItems_R = "";
        private String label_NumPts_R = "";
        private String label_GeoType_R = "";
        private String label_NumAtts_R = "";
        private String label_DSClass_R = "";
        private String label_Path_R = "";
        private String label_Charset_R = "";
        private String label_Coordinate = "";
        private String label_Coordinate_file = "";
        private String label_DSClass_IR = "";
        private String label_Path_IR = "";

        private InfoPanel() throws Exception {
            Locale locale = new Locale("en", "UK");
            String pattern = "###.####";
            DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            df.applyPattern(pattern);
            this.setInfo(NewLayerPropertiesPlugIn.this.layers);
            String info = "";
            info = info + NewLayerPropertiesPlugIn.this.header("", LAYERS + ": " + df.format(NewLayerPropertiesPlugIn.this.layers.length));
            if (NewLayerPropertiesPlugIn.this.layers.length == 1) {
                info = NewLayerPropertiesPlugIn.this.layers[0].isFeatureCollectionModified() ? info + NewLayerPropertiesPlugIn.this.property(NAME, this.label_Name_R + " - " + NewLayerPropertiesPlugIn.this.MODIFIED, "\"#FEEDD6\"") : info + NewLayerPropertiesPlugIn.this.property(NAME, this.label_Name_R, "\"#FEEDD6\"");
                String sclass = NewLayerPropertiesPlugIn.this.layers[0].getClass().getSimpleName();
                if (!sclass.equals("WFSLayer")) {
                    info = info + NewLayerPropertiesPlugIn.this.header("", DATASOURCE);
                    if (sclass.equals("ReferencedImagesLayer")) {
                        info = info + NewLayerPropertiesPlugIn.this.property(DATASOURCE_CLASS, this.label_DSClass_IR, "\"#FEEDD6\"");
                        info = info + NewLayerPropertiesPlugIn.this.property(SOURCE_PATH, this.label_Path_IR, "\"#EAEAEA\"");
                        info = info + NewLayerPropertiesPlugIn.this.property(CATALOG_FILE, this.label_Path_R, "\"#FEEDD6\"");
                    } else {
                        info = info + NewLayerPropertiesPlugIn.this.property(DATASOURCE_CLASS, this.label_DSClass_R, "\"#FEEDD6\"");
                        info = info + NewLayerPropertiesPlugIn.this.property(SOURCE_PATH, this.label_Path_R, "\"#EAEAEA\"");
                        if (NewLayerPropertiesPlugIn.this.layers[0].getDataSourceQuery() != null && NewLayerPropertiesPlugIn.this.layers[0].getDataSourceQuery().getDataSource().getClass().getName().equals("com.vividsolutions.jump.io.datasource.StandardReaderWriterFileDataSource$Shapefile")) {
                            info = info + NewLayerPropertiesPlugIn.this.property(CHARSET, this.label_Charset_R, "\"#FEEDD6\"");
                        }
                    }
                }
                info = info + NewLayerPropertiesPlugIn.this.header("", COORDINATE_SYSTEM);
                this.setInfoProjection(NewLayerPropertiesPlugIn.this.layers);
                info = info + NewLayerPropertiesPlugIn.this.property(CRS, this.label_Coordinate, "\"#FEEDD6\"");
                info = info + NewLayerPropertiesPlugIn.this.property(SOURCE_PATH, this.label_Coordinate_file, "\"#EAEAEA\"");
            } else {
                info = info + NewLayerPropertiesPlugIn.this.property(NAME, this.label_Name_R, "\"#FEEDD6\"");
                info = info + NewLayerPropertiesPlugIn.this.header("", DATASOURCE);
                info = info + NewLayerPropertiesPlugIn.this.property(DATASOURCE_CLASS, this.label_DSClass_R, "\"#FEEDD6\"");
                info = info + NewLayerPropertiesPlugIn.this.property(SOURCE_PATH, this.label_Path_R, "\"#EAEAEA\"");
            }
            info = info + NewLayerPropertiesPlugIn.this.header("", EXTENT);
            info = info + NewLayerPropertiesPlugIn.this.property(XMIN, "" + NewLayerPropertiesPlugIn.this.extent.getMinX(), "\"#FEEDD6\"");
            info = info + NewLayerPropertiesPlugIn.this.property(XMAX, "" + NewLayerPropertiesPlugIn.this.extent.getMaxX(), "\"#EAEAEA\"");
            info = info + NewLayerPropertiesPlugIn.this.property(YMIN, "" + NewLayerPropertiesPlugIn.this.extent.getMinY(), "\"#FEEDD6\"");
            info = info + NewLayerPropertiesPlugIn.this.property(YMAX, "" + NewLayerPropertiesPlugIn.this.extent.getMaxY(), "\"#EAEAEA\"");
            info = info + NewLayerPropertiesPlugIn.this.header("", FEATURES);
            info = info + NewLayerPropertiesPlugIn.this.property(NUMBER_OF_FEATURES, this.label_NumItems_R, "\"#FEEDD6\"");
            info = info + NewLayerPropertiesPlugIn.this.property(NUMBER_OF_POINTS, this.label_NumPts_R, "\"#EAEAEA\"");
            info = info + NewLayerPropertiesPlugIn.this.property(GEOMETRY_TYPE, this.label_GeoType_R, "\"#FEEDD6\"");
            info = info + NewLayerPropertiesPlugIn.this.property(NUMBER_OF_ATTRIBUTES, this.label_NumAtts_R, "\"#EAEAEA\"");
            String table = "<table border='0.1'>";
            String table2 = "</table>";
            String infotext = "<html>" + table + info + table2 + "</html>";
            this.getRecordPanel().removeAll();
            this.createNewDocument();
            this.append(infotext);
        }

        private boolean isImageFileLayer(Layer layer) {
            return layer.getStyle(ReferencedImageStyle.class) != null && layer.getDescription() != null;
        }

        private boolean isDataBaseLayer(Layer layer) {
            DataSourceQuery dsq = layer.getDataSourceQuery();
            return dsq == null || dsq.getDataSource() instanceof DataStoreQueryDataSource;
        }

        @Override
        public String getTitle() {
            return INFO;
        }

        @Override
        public void updateStyles() {
        }

        @Override
        public String validateInput() {
            return null;
        }

        private void setInfo(Layer[] layers) throws IOException, URISyntaxException {
            String charsetName;
            if (layers.length == 1) {
                this.label_Name_R = layers[0].getName().startsWith("wfs") ? layers[0].getName().substring(4) : layers[0].getName();
            } else {
                for (Layer layer : layers) {
                    this.label_Name_R = this.label_Name_R + layer.getName() + " - ";
                }
            }
            String sourcePath = NOT_SAVED;
            String geoClass = "";
            String sourceClass = "";
            int numFeatures = 0;
            int numPts = 0;
            int numAtts = 0;
            boolean multipleGeoTypes = false;
            boolean multipleSourceTypes = false;
            Hashtable<String, Integer> geometryModes = new Hashtable<String, Integer>();
            for (Layer layer : layers) {
                FeatureCollectionWrapper fcw = layer.getFeatureCollectionWrapper();
                numFeatures += fcw.size();
                numAtts += fcw.getFeatureSchema().getAttributeCount() - 1;
                for (Feature feature : fcw.getFeatures()) {
                    Geometry geo = feature.getGeometry();
                    if (geo == null) continue;
                    numPts += geo.getNumPoints();
                    if (geoClass.equals("")) {
                        geoClass = geo.getClass().getName();
                    } else if (!geo.getClass().getName().equals(geoClass)) {
                        multipleGeoTypes = true;
                    }
                    String geoClassName = geo.getClass().getName();
                    int count = geometryModes.get(geoClassName) == null ? 0 : (Integer)geometryModes.get(geoClassName);
                    geometryModes.put(geoClassName, count + 1);
                }
                DataSourceQuery dsq = layer.getDataSourceQuery();
                if (dsq == null) continue;
                String dsqSourceClass = dsq.getDataSource().getClass().getName();
                if (sourceClass.equals("")) {
                    sourceClass = dsqSourceClass;
                } else if (!sourceClass.equals(dsqSourceClass)) {
                    multipleSourceTypes = true;
                }
                Map<String, Object> properties = dsq.getDataSource().getProperties();
                if (properties.get("Uri") != null) {
                    sourcePath = new URI(properties.get("Uri").toString()).getPath();
                    continue;
                }
                if (properties.get("File") != null) {
                    sourcePath = properties.get("File").toString();
                    continue;
                }
                if (properties.get("Connection Descriptor") == null) continue;
                sourcePath = properties.get("Connection Descriptor").toString();
            }
            if (numFeatures == 0) {
                geoClass = NO_FEATURES;
            } else if (multipleGeoTypes) {
                geoClass = MULTIPLE_GEOMETRY_TYPES + ": ";
                int n = geometryModes.size();
                Enumeration modeCount = geometryModes.elements();
                Enumeration modeName = geometryModes.keys();
                for (int i = 0; i < n; ++i) {
                    String geometryMode = (String)modeName.nextElement();
                    int dotPos = geometryMode.lastIndexOf(".");
                    if (dotPos > 0) {
                        geometryMode = geometryMode.substring(dotPos + 1);
                    }
                    int geometryModeCount = (Integer)modeCount.nextElement();
                    geoClass = geoClass + (i == 0 ? " " : ", ") + geometryMode + ":" + geometryModeCount;
                }
            } else if (geoClass.equals("")) {
                geoClass = NULL_GEOMETRIES;
            } else {
                int dotPos = geoClass.lastIndexOf(".");
                if (dotPos > 0) {
                    geoClass = geoClass.substring(dotPos + 1);
                }
            }
            if (sourceClass.equals("")) {
                sourceClass = NewLayerPropertiesPlugIn.this.NODATASOURCELAYER;
            } else if (multipleSourceTypes) {
                sourceClass = MULTIPLE_SOURCE_TYPES;
            } else {
                int dotPos = sourceClass.lastIndexOf(".");
                if (dotPos > 0) {
                    sourceClass = sourceClass.substring(dotPos + 1);
                }
                if ((dotPos = sourceClass.lastIndexOf("$")) > 0) {
                    sourceClass = sourceClass.substring(dotPos + 1);
                }
            }
            this.label_GeoType_R = geoClass;
            if (layers.length == 1) {
                this.label_NumItems_R = "" + numFeatures;
                this.label_NumPts_R = "" + numPts;
                this.label_NumAtts_R = "" + numAtts;
            } else {
                DecimalFormat df = new DecimalFormat("0.0");
                double numLayers = layers.length;
                double avgNumFeatures = (double)numFeatures / numLayers;
                double avgNumPts = (double)numPts / numLayers;
                double avgNumAtts = (double)numAtts / numLayers;
                this.label_NumItems_R = numFeatures + "  " + df.format(avgNumFeatures) + AVERAGE_PER_LAYER;
                this.label_NumPts_R = numPts + "  " + df.format(avgNumPts) + AVERAGE_PER_LAYER;
                this.label_NumAtts_R = df.format(avgNumAtts) + AVERAGE_PER_LAYER;
            }
            DataSourceQuery dsq = layers[0].getDataSourceQuery();
            if (dsq != null) {
                Map<String, Object> properties = dsq.getDataSource().getProperties();
                charsetName = (String)properties.get("charset");
                if (charsetName == null) {
                    charsetName = Charset.defaultCharset().displayName();
                    properties.put("charset", charsetName);
                }
            } else {
                charsetName = Charset.defaultCharset().displayName();
            }
            this.label_Charset_R = charsetName;
            if (layers[0].getStyle(ReferencedImageStyle.class) != null && layers[0].getDescription() != null) {
                FeatureCollectionWrapper featureCollection = layers[0].getFeatureCollectionWrapper();
                int size = featureCollection.size();
                if (size == 1) {
                    for (Feature feature : featureCollection.getFeatures()) {
                        if (feature.getString(ImageryLayerDataset.ATTR_URI).isEmpty()) continue;
                        String sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
                        sourcePathImage = sourcePathImage.substring(5);
                        File f = new File(sourcePathImage);
                        String filePath = f.getAbsolutePath().replace("%20", " ");
                        String type = FilenameUtils.getExtension((String)filePath).toUpperCase();
                        this.label_DSClass_IR = type + " - " + IMAGE;
                        this.label_Path_IR = filePath;
                    }
                } else {
                    for (Feature feature : featureCollection) {
                        String sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
                        sourcePathImage = sourcePathImage.substring(5);
                        File f = new File(sourcePathImage);
                        String filePath = f.getAbsolutePath();
                        String filePath1 = filePath.replace("%20", " ");
                        this.label_Path_IR = this.label_Path_IR + filePath1 + "\n";
                    }
                    this.label_DSClass_IR = MULTIPLE_SOURCE_TYPES;
                }
            }
            this.label_DSClass_R = sourceClass;
            this.label_Path_R = sourcePath;
            if (layers.length > 1 && !sourcePath.equalsIgnoreCase(NOT_SAVED)) {
                this.label_Path_R = MULTIPLE_SOURCES;
            }
        }

        private void setInfoProjection(Layer[] layers) throws Exception {
            SRSInfo srsInfo = ProjUtils.getSRSInfoFromLayerStyleOrSource(layers[0]);
            this.label_Coordinate_file = srsInfo.getSource();
            this.label_Coordinate = srsInfo.toString();
        }
    }
}

