/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.TreeLayerNamePanel;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;

public class MoveSelectedLayersPlugIn
extends AbstractPlugIn {
    private static final String CATEGORIES = I18N.getInstance().get("ui.plugin.MoveLayerablePlugIn.destination-category");
    private boolean moveToTop = true;
    public static final ImageIcon ICON = IconLoader.icon("bullet_arrow_up_down.png");

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.MoveLayerablePlugIn.move-to-category");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        try {
            this.reportNothingToUndoYet(context);
            LayerManager layerManager = context.getWorkbenchContext().getLayerManager();
            MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
            ArrayList<String> categoryArray = new ArrayList<String>();
            Iterator<Category> i = layerManager.getCategories().iterator();
            while (i.hasNext()) {
                categoryArray.add(i.next().getName());
            }
            JComboBox<String> comboBox = dialog.addComboBox(CATEGORIES, "", categoryArray, I18N.getInstance().get("ui.plugin.MoveLayerablePlugIn.destination-category"));
            comboBox.setEditable(true);
            comboBox.setPrototypeDisplayValue("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
            dialog.addRadioButton(I18N.getInstance().get("ui.plugin.MoveLayerablePlugIn.move-to-top"), "position", this.moveToTop, "Insert at top of category");
            dialog.addRadioButton(I18N.getInstance().get("ui.plugin.MoveLayerablePlugIn.move-to-bottom"), "position", !this.moveToTop, "Insert at bottom of category");
            GUIUtil.centreOnWindow(dialog);
            dialog.setVisible(true);
            if (!dialog.wasOKPressed()) {
                return false;
            }
            String categoryName = dialog.getText(CATEGORIES).trim();
            this.moveToTop = dialog.getRadioButton(I18N.getInstance().get("ui.plugin.MoveLayerablePlugIn.move-to-top")).isSelected();
            if (categoryName.length() == 0) {
                return false;
            }
            if (layerManager.getCategory(categoryName) == null) {
                layerManager.addCategory(categoryName);
            }
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            Collection<Layerable> layerCollection = context.getWorkbenchContext().getLayerNamePanel().selectedNodes(Layerable.class);
            Layerable[] selectedLayers = layerCollection.toArray(new Layerable[0]);
            if (this.moveToTop) {
                for (int i2 = selectedLayers.length - 1; i2 >= 0; --i2) {
                    Layerable layerable = selectedLayers[i2];
                    layerManager.remove(layerable);
                    layerManager.addLayerable(categoryName, layerable);
                }
            } else {
                Category destCat = layerManager.getCategory(categoryName);
                int bottomIndex = destCat.getLayerables().size();
                for (int i3 = selectedLayers.length - 1; i3 >= 0; --i3) {
                    Layerable layerable = selectedLayers[i3];
                    Category layerCat = layerManager.getCategory(layerable);
                    layerManager.remove(layerable);
                    if (layerCat == destCat) {
                        --bottomIndex;
                    }
                    destCat.add(bottomIndex, layerable);
                }
            }
            TreeLayerNamePanel lnp = (TreeLayerNamePanel)context.getWorkbenchContext().getLayerableNamePanel();
            lnp.setSelectedLayerables(selectedLayers);
            return true;
        }
        catch (Exception e) {
            context.getWorkbenchFrame().warnUser("Error: see output window");
            context.getWorkbenchFrame().getOutputFrame().createNewDocument();
            context.getWorkbenchFrame().getOutputFrame().addText("MoveSelectedLayersPlugIn Exception:" + e.toString());
            return false;
        }
    }

    protected int index(Layerable layerable) {
        return layerable.getLayerManager().getCategory(layerable).indexOf(layerable);
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayerablesMustBeSelectedCheck(1, Layerable.class));
    }
}

