/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openjump.core.ccordsys.srid.SRIDStyle;

public class ChangeSRIDPlugIn
extends AbstractPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        EnableCheckFactory enableCheckFactory = EnableCheckFactory.getInstance(context.getWorkbenchContext());
        MultiEnableCheck enableCheck = new MultiEnableCheck().add(enableCheckFactory.createWindowWithLayerManagerMustBeActiveCheck()).add(enableCheckFactory.createExactlyNLayersMustBeSelectedCheck(1));
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.LAYER}, this.getName() + "...", false, null, enableCheck);
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.layer.ChangeSRIDPlugIn.Change-SRID");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        final Layer layer = context.getSelectedLayer(0);
        final SRIDStyle sridStyle = (SRIDStyle)layer.getStyle(SRIDStyle.class);
        final int oldSRID = sridStyle.getSRID();
        String input = "";
        final JButton okay = new JButton(I18N.getInstance().get("ui.OKCancelPanel.ok"));
        okay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane pane = ChangeSRIDPlugIn.this.getOptionPane((JComponent)e.getSource());
                pane.setValue(okay);
            }
        });
        okay.setEnabled(false);
        final JButton cancel = new JButton(I18N.getInstance().get("ui.OKCancelPanel.cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane pane = ChangeSRIDPlugIn.this.getOptionPane((JComponent)e.getSource());
                pane.setValue(cancel);
            }
        });
        final JTextField field = new JTextField("0123456789");
        Border padding = BorderFactory.createEmptyBorder(1, 3, 1, 3);
        final CompoundBorder defaultBorder = BorderFactory.createCompoundBorder(field.getBorder(), padding);
        final CompoundBorder redBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), padding);
        field.setBorder(defaultBorder);
        field.setText("" + oldSRID);
        field.getDocument().addDocumentListener(new DocumentListener(){

            protected void update() {
                String value = field.getText().trim();
                boolean changed = !value.equals("" + oldSRID);
                boolean valid = value.matches("\\d+");
                field.setBorder(valid ? defaultBorder : redBorder);
                okay.setEnabled(changed && valid);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }
        });
        int res = JOptionPane.showOptionDialog(context.getWorkbenchFrame(), field, this.getName(), 2, -1, null, new Object[]{okay, cancel}, okay);
        if (res != 0) {
            return false;
        }
        input = field.getText().trim();
        final int newSRID = Integer.parseInt(input);
        if (newSRID == oldSRID) {
            return false;
        }
        this.execute(new UndoableCommand(this.getName()){

            @Override
            public void execute() {
                sridStyle.setSRID(newSRID);
                sridStyle.updateSRIDs(layer);
                layer.setFeatureCollectionModified(true);
            }

            @Override
            public void unexecute() {
                sridStyle.setSRID(oldSRID);
                sridStyle.updateSRIDs(layer);
                layer.setFeatureCollectionModified(true);
            }
        }, context);
        return true;
    }

    private JOptionPane getOptionPane(JComponent parent) {
        JOptionPane pane = null;
        pane = !(parent instanceof JOptionPane) ? this.getOptionPane((JComponent)parent.getParent()) : (JOptionPane)parent;
        return pane;
    }
}

