/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edittoolbox.cursortools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.FeatureDrawingUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.openjump.core.ui.plugin.edittoolbox.cursortools.ConstrainedMultiClickTool;

public class DrawConstrainedLineStringTool
extends ConstrainedMultiClickTool {
    private FeatureDrawingUtil featureDrawingUtil;
    static final String drawConstrainedLineString = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawConstrainedLineStringTool.Draw-Constrained-LineString");
    static final String TheLinestringMustHaveAtLeast2Points = I18N.getInstance().get("org.openjump.core.ui.plugin.edittoolbox.cursortools.DrawConstrainedLineStringTool.The-linestring-must-have-at-least-2-points");

    protected DrawConstrainedLineStringTool(WorkbenchContext context, FeatureDrawingUtil featureDrawingUtil) {
        super(context);
        this.drawClosed = false;
        this.featureDrawingUtil = featureDrawingUtil;
    }

    public static CursorTool create(WorkbenchContext context) {
        FeatureDrawingUtil featureDrawingUtil = new FeatureDrawingUtil(context);
        return featureDrawingUtil.prepare(new DrawConstrainedLineStringTool(context, featureDrawingUtil), true);
    }

    @Override
    public String getName() {
        return drawConstrainedLineString;
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("DrawLinestringConstrained.gif"));
    }

    @Override
    protected void gestureFinished() throws Exception {
        this.reportNothingToUndoYet();
        if (!this.checkLineString()) {
            return;
        }
        this.execute(this.featureDrawingUtil.createAddCommand((Geometry)this.getLineString(), this.isRollingBackInvalidEdits(), this.getPanel(), this), true);
    }

    protected LineString getLineString() throws NoninvertibleTransformException {
        return new GeometryFactory().createLineString(this.toArray(this.getCoordinates()));
    }

    protected boolean checkLineString() throws NoninvertibleTransformException {
        if (this.getCoordinates().size() < 2) {
            this.getPanel().getContext().warnUser(TheLinestringMustHaveAtLeast2Points);
            return false;
        }
        IsValidOp isValidOp = new IsValidOp((Geometry)this.getLineString());
        if (!isValidOp.isValid()) {
            this.getPanel().getContext().warnUser(isValidOp.getValidationError().getMessage());
            if (PersistentBlackboardPlugIn.get(this.getWorkbench().getContext()).get(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, false)) {
                return false;
            }
        }
        return true;
    }
}

