/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import java.util.ArrayList;
import org.locationtech.jts.geom.GeometryCollection;

public class SelectGeometryCollectionsPlugIn
extends AbstractPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.EDIT, MenuNames.SELECTION}, this.getName(), false, null, this.createEnableCheck(context.getWorkbenchContext()));
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        ArrayList<Feature> selectedFeatures = new ArrayList<Feature>();
        LayerViewPanel layerViewPanel = context.getWorkbenchContext().getLayerViewPanel();
        layerViewPanel.getSelectionManager().clear();
        for (Layer layer : context.getSelectedLayers()) {
            selectedFeatures.clear();
            if (!layer.isVisible()) continue;
            FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
            for (Feature feature : featureCollection.getFeatures()) {
                if (!(feature.getGeometry() instanceof GeometryCollection)) continue;
                selectedFeatures.add(feature);
            }
            if (selectedFeatures.size() <= 0) continue;
            context.getWorkbenchContext().getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(layer, selectedFeatures);
        }
        return true;
    }
}

