/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore.transaction;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerAdapter;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.plugin.WorkbenchContextReference;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openjump.core.ui.plugin.datastore.WritableDataStoreDataSource;
import org.openjump.core.ui.plugin.datastore.transaction.DataStoreTransactionManager;
import org.openjump.core.ui.plugin.datastore.transaction.Evolution;

public class TransactionManagerPanel
extends JPanel
implements WorkbenchContextReference {
    private static final String KEY = TransactionManagerPanel.class.getName();
    private final DataStoreTransactionManager transactionManager;
    private final ErrorHandler errorHandler;
    private final JTextArea textArea;
    private LayerListener layerListener;
    private WorkbenchContext context;

    public TransactionManagerPanel(DataStoreTransactionManager transactionManager, ErrorHandler errorHandler, WorkbenchContext context) {
        this.transactionManager = transactionManager;
        this.errorHandler = errorHandler;
        this.textArea = new JTextArea(12, 32);
        this.init(context);
    }

    protected void init(WorkbenchContext context) {
        this.context = context;
        this.setLayout(new BoxLayout(this, 1));
        this.textArea.setFont(this.textArea.getFont().deriveFont(11.0f));
        this.add(new JScrollPane(this.textArea, 20, 31));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 4, 2, 4);
        c.gridx = 0;
        c.gridy = 0;
        JButton inspectButton = new JButton(I18N.getInstance().get(KEY + ".inspect"));
        inspectButton.setToolTipText(I18N.getInstance().get(KEY + ".inspect-tooltip"));
        inspectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransactionManagerPanel.this.transactionManager.inspect(TransactionManagerPanel.this.getTaskFrame());
            }
        });
        c.gridx = 1;
        ++c.gridy;
        c.gridwidth = 1;
        c.fill = 2;
        panel.add((Component)inspectButton, c);
        JButton updateButton = new JButton(I18N.getInstance().get(KEY + ".update"));
        updateButton.setToolTipText(I18N.getInstance().get(KEY + ".update-tooltip"));
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransactionManagerPanel.this.transactionManager.update(TransactionManagerPanel.this.getTaskFrame());
            }
        });
        c.gridx = 0;
        ++c.gridy;
        panel.add((Component)updateButton, c);
        JButton commitButton = new JButton(I18N.getInstance().get(KEY + ".commit"));
        commitButton.setToolTipText(I18N.getInstance().get(KEY + ".commit-tooltip"));
        commitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TransactionManagerPanel.this.transactionManager.commit();
                    TransactionManagerPanel.this.updateTextArea(JUMPWorkbench.getInstance().getContext().getTask());
                }
                catch (Exception ex) {
                    TransactionManagerPanel.this.errorHandler.handleThrowable(ex);
                }
            }
        });
        c.gridx = 1;
        panel.add((Component)commitButton, c);
        this.add(panel);
    }

    public void updateListener(final Task task) {
        if (task == null) {
            return;
        }
        for (JInternalFrame iframe : JUMPWorkbench.getInstance().getFrame().getInternalFrames()) {
            if (!(iframe instanceof TaskFrame)) continue;
            ((TaskFrame)iframe).getTask().getLayerManager().removeLayerListener(this.layerListener);
        }
        this.layerListener = new LayerAdapter(){

            @Override
            public void featuresChanged(FeatureEvent e) {
                Layer layer = e.getLayer();
                Collection<Layer> layers = TransactionManagerPanel.this.transactionManager.getLayers();
                if (layers.contains(layer)) {
                    DataSource dataSource = layer.getDataSourceQuery().getDataSource();
                    if (dataSource instanceof WritableDataStoreDataSource) {
                        TransactionManagerPanel.this.updateTextArea(task);
                    } else {
                        Logger.error(I18N.getInstance().get(KEY + ".layer-with-irrelevant-datastore-datasource"));
                    }
                }
            }

            @Override
            public void layerChanged(LayerEvent e) {
                if (e.getType() == LayerEventType.REMOVED) {
                    TransactionManagerPanel.this.updateTextArea(task);
                }
            }
        };
        for (JInternalFrame iframe : JUMPWorkbench.getInstance().getFrame().getInternalFrames()) {
            if (!(iframe instanceof TaskFrame) || ((TaskFrame)iframe).getTask() != task) continue;
            LayerManager manager = ((TaskFrame)iframe).getTask().getLayerManager();
            manager.removeLayerListener(this.layerListener);
            manager.addLayerListener(this.layerListener);
        }
        this.updateTextArea(task);
    }

    void updateTextArea(Task task) {
        this.textArea.setText("");
        for (Layer layer : this.transactionManager.getLayers()) {
            DataSource source;
            if (this.transactionManager.getTask(layer) != task || !((source = layer.getDataSourceQuery().getDataSource()) instanceof WritableDataStoreDataSource)) continue;
            int c = 0;
            int m = 0;
            int s = 0;
            for (Evolution evo : ((WritableDataStoreDataSource)source).getUncommittedEvolutions()) {
                if (evo.getType() == Evolution.Type.CREATION) {
                    ++c;
                }
                if (evo.getType() == Evolution.Type.SUPPRESSION) {
                    ++s;
                }
                if (evo.getType() != Evolution.Type.MODIFICATION) continue;
                ++m;
            }
            if (c + m + s > 0) {
                this.textArea.append(layer.getName() + ":\n");
            }
            if (c > 0) {
                this.textArea.append(I18N.getInstance().get(KEY + ".creations", c) + "\n");
            }
            if (s > 0) {
                this.textArea.append(I18N.getInstance().get(KEY + ".suppressions", s) + "\n");
            }
            if (m <= 0) continue;
            this.textArea.append(I18N.getInstance().get(KEY + ".modifications", m) + "\n");
        }
    }

    TaskFrame getTaskFrame() {
        return this.context.getWorkbench().getFrame().getActiveTaskFrame();
    }

    @Override
    public void setWorkbenchContext(WorkbenchContext context) {
        this.context = context;
    }
}

