/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore.postgis2;

import com.vividsolutions.jump.datastore.AdhocQuery;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.datastore.postgis.PostgisDSConnection;
import com.vividsolutions.jump.datastore.postgis.PostgisDataStoreDriver;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSConnection;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.FeatureInputStream;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.locationtech.jts.geom.Coordinate;
import org.openjump.core.ui.plugin.datastore.WritableDataStoreDataSource;

public class PostGISDataStoreDataSource
extends WritableDataStoreDataSource {
    public PostGISDataStoreDataSource() {
    }

    public PostGISDataStoreDataSource(WorkbenchContext context) {
        this.context = context;
    }

    public PostGISDataStoreDataSource(ConnectionDescriptor connectionDescriptor, String datasetName, String geometryAttributeName, String identifierAttributeName, String txManagerClass, WorkbenchContext context) {
        super(connectionDescriptor, datasetName, geometryAttributeName, identifierAttributeName, txManagerClass, context);
    }

    @Override
    @Deprecated
    public void finalizeUpdate(SpatialDatabasesDSConnection conn) throws Exception {
        try (Statement statement = conn.getJdbcConnection().createStatement();){
            statement.execute("VACUUM ANALYZE " + SQLUtil.compose(this.schemaName, this.tableName));
            Logger.debug("VACUUM ANALYZE " + SQLUtil.compose(this.schemaName, this.tableName));
        }
    }

    @Override
    protected FeatureCollection createFeatureCollection() throws Exception {
        Logger.debug("Create new FeatureCollection from " + this.getProperties().get("Dataset Name"));
        ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)this.getProperties().get("Connection Descriptor");
        PostgisDSConnection pgConnection = (PostgisDSConnection)new PostgisDataStoreDriver().createConnection(connectionDescriptor.getParameterList());
        boolean hasPK = this.getProperties().get("External PK") != null;
        String PK = (String)this.getProperties().get("External PK");
        String query = this.buildQueryString(pgConnection);
        Logger.debug(query);
        AdhocQuery adhocQuery = new AdhocQuery(query);
        if (hasPK) {
            adhocQuery.setPrimaryKey(PK);
        }
        try {
            FeatureInputStream featureInputStream = pgConnection.execute(adhocQuery);
            FeatureDataset featureDataset = new FeatureDataset(featureInputStream.getFeatureSchema());
            if (hasPK) {
                featureDataset.getFeatureSchema().setExternalPrimaryKeyIndex(featureDataset.getFeatureSchema().getAttributeIndex(PK));
            }
            while (featureInputStream.hasNext()) {
                featureDataset.add(featureInputStream.next());
            }
            return featureDataset;
        }
        catch (Exception e) {
            if (this.context != null) {
                this.context.getWorkbench().getFrame().handleThrowable(e);
            }
            FeatureDataset featureDataset = new FeatureDataset(new FeatureSchema());
            return featureDataset;
        }
    }

    private String buildQueryString(SpatialDatabasesDSConnection conn) throws SQLException {
        String geometryColumn = (String)this.getProperties().get("Geometry Attribute Name");
        String[] columns = conn.getMetadata().getColumnNames(SQLUtil.unquote((String)this.getProperties().get("Dataset Name")));
        int table_srid = this.getTableSRID(conn.getJdbcConnection(), geometryColumn);
        boolean limited_to_view = (Boolean)this.getProperties().get("Limited To View");
        String extent = limited_to_view ? " AND (\"" + geometryColumn + "\" && ST_GeomFromText('" + this.getViewEnvelope().toText() + "'," + table_srid + "))" : "";
        String whereClause = (String)this.getProperties().get("Where Clause");
        whereClause = whereClause == null || whereClause.isEmpty() ? "true" : "(" + whereClause + ")";
        int max_features = (Integer)this.getProperties().get("Max Features");
        String notNullGeomColumn = String.format("CASE WHEN \"%s\" IS NULL THEN ST_GeomFromText('GEOMETRYCOLLECTION EMPTY') ELSE \"%s\" END as \"%s\"", geometryColumn, geometryColumn, geometryColumn);
        StringBuilder sb = new StringBuilder("SELECT ").append(notNullGeomColumn);
        for (String col : columns) {
            if (col.equals(geometryColumn)) continue;
            sb.append(", \"").append(col).append("\"");
        }
        sb.append(" FROM \"").append(this.schemaName == null ? "" : SQLUtil.unquote(this.schemaName) + "\".\"").append(SQLUtil.unquote(this.tableName)).append("\" WHERE ").append(whereClause).append(extent).append(" LIMIT ").append(max_features).append(";");
        return sb.toString();
    }

    @Override
    protected void deleteTableQuery(SpatialDatabasesDSConnection conn) throws SQLException {
        try (Statement statement = conn.getJdbcConnection().createStatement();){
            statement.execute("DROP TABLE " + SQLUtil.compose(this.schemaName, this.tableName) + ";");
        }
    }

    @Override
    protected void createAndPopulateTable(SpatialDatabasesDSConnection conn, FeatureCollection fc, int srid, String geometryType, boolean multi, int dim, boolean normalizedColumnNames) throws SQLException {
        Statement statement;
        FeatureSchema schema = fc.getFeatureSchema();
        String geometryColumn = normalizedColumnNames ? SQLUtil.normalize(schema.getAttributeName(schema.getGeometryIndex())) : schema.getAttributeName(schema.getGeometryIndex());
        try {
            statement = conn.getJdbcConnection().createStatement();
            try {
                Logger.debug(conn.getMetadata().getCreateTableStatement(fc.getFeatureSchema(), this.schemaName, this.tableName, normalizedColumnNames));
                statement.execute(conn.getMetadata().getCreateTableStatement(fc.getFeatureSchema(), this.schemaName, this.tableName, normalizedColumnNames));
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException sqle) {
            throw new SQLException("Error executing query: " + conn.getMetadata().getCreateTableStatement(fc.getFeatureSchema(), this.schemaName, this.tableName, normalizedColumnNames), sqle);
        }
        try {
            statement = conn.getJdbcConnection().createStatement();
            try {
                Logger.debug(conn.getMetadata().getAddGeometryColumnStatement(this.schemaName, this.tableName, geometryColumn, srid, geometryType, dim));
                statement.execute(conn.getMetadata().getAddGeometryColumnStatement(this.schemaName, this.tableName, geometryColumn, srid, geometryType, dim));
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException sqle) {
            throw new SQLException("Error executing query: " + conn.getMetadata().getAddGeometryColumnStatement(this.schemaName, this.tableName, geometryColumn, srid, geometryType, dim), sqle);
        }
        this.populateTable(conn, fc, srid, multi, dim, normalizedColumnNames);
        try {
            statement = conn.getJdbcConnection().createStatement();
            try {
                statement.execute(conn.getMetadata().getAddSpatialIndexStatement(this.schemaName, this.tableName, geometryColumn));
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException sqle) {
            throw new SQLException("Error executing query: " + conn.getMetadata().getAddSpatialIndexStatement(this.schemaName, this.tableName, geometryColumn), sqle);
        }
    }

    private void populateTable(SpatialDatabasesDSConnection conn, FeatureCollection fc, int srid, boolean multi, int dim, boolean normalizedColumnNames) throws SQLException {
        PreparedStatement statement = this.insertStatement(conn, fc.getFeatureSchema(), multi, normalizedColumnNames);
        int count = 0;
        double replacementZ = this.getProperties().get("NaN Z to value") == null ? Double.NaN : (Double)this.getProperties().get("NaN Z to value");
        for (Feature f : fc.getFeatures()) {
            if (dim == 3 && this.getProperties().get("Dimension") != null) {
                for (Coordinate c : f.getGeometry().getCoordinates()) {
                    if (!Double.isNaN(c.z)) continue;
                    c.z = replacementZ;
                }
            }
            statement = this.setAttributeValues(statement, f, srid, multi, dim);
            statement.addBatch();
            if (count++ % 10000 != 0) continue;
            statement.executeBatch();
            statement.clearBatch();
        }
        statement.executeBatch();
        statement.clearBatch();
    }

    @Override
    protected void addDBPrimaryKey(SpatialDatabasesDSConnection conn, String primaryKey) throws SQLException {
        String sql_create_dbid = "ALTER TABLE " + SQLUtil.compose(this.schemaName, this.tableName) + " ADD COLUMN \"" + primaryKey + "\" serial NOT NULL PRIMARY KEY;";
        try (Statement statement = conn.getJdbcConnection().createStatement();){
            statement.execute(sql_create_dbid);
        }
        catch (SQLException sqle) {
            throw new SQLException(sql_create_dbid, sqle);
        }
    }

    @Override
    protected int getTableSRID(Connection conn, String column) throws SQLException {
        String sql = this.schemaName == null ? "SELECT Find_SRID('public', '" + this.tableName + "', '" + SQLUtil.unquote(column) + "');" : "SELECT Find_SRID('" + this.schemaName + "', '" + this.tableName + "', '" + SQLUtil.unquote(column) + "');";
        Logger.debug(sql);
        ResultSet rs = conn.prepareStatement(sql).executeQuery();
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }
}

