/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreMetadata;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AbstractDriverPanel;
import com.vividsolutions.jump.workbench.ui.OKCancelPanel;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.ConnectionPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataStoreSaveDriverPanel
extends AbstractDriverPanel {
    public static final String KEY = DataStoreSaveDriverPanel.class.getName();
    private static final String TABLE = I18N.getInstance().get(KEY + ".table");
    private static final String WRITE_3D_GEOM = I18N.getInstance().get(KEY + ".write-3d-geometries");
    private static final String CONVERT_NAN_Z = I18N.getInstance().get(KEY + ".convert-nan-z");
    private static final String NARROW_GEOMETRY_TYPE = I18N.getInstance().get(KEY + ".narrow-geometry-type");
    private static final String CONVERT_TO_MULTIGEOMETRY = I18N.getInstance().get(KEY + ".convert-to-multigeometry");
    private static final String CREATE_DB_PK = I18N.getInstance().get(KEY + ".create-database-primary-key");
    private static final String NORMALIZED_TABLE_NAME = I18N.getInstance().get(KEY + ".normalized-table-name-key");
    private static final String NORMALIZED_COLUMN_NAMES = I18N.getInstance().get(KEY + ".normalized-column-names-key");
    ConnectionPanel connectionPanel;
    JComboBox<String> tableComboBox;
    JCheckBox createPrimaryKeyCheckBox;
    JCheckBox write3dGeomCheckBox;
    JTextField convertNaNZTextField;
    JCheckBox narrowGeometryTypeCheckBox;
    JCheckBox convertToMultiGeometryCheckBox;
    JCheckBox normalizedTableNameCheckBox;
    JCheckBox normalizedColumnNamesCheckBox;
    OKCancelPanel okCancelPanel = new OKCancelPanel();
    private WorkbenchContext wbContext;
    private String lastUsedLayerName = null;
    private Map<String, String> layer2TableMap = new HashMap<String, String>();
    private DefaultComboBoxModel<String> tableList = new DefaultComboBoxModel();

    public DataStoreSaveDriverPanel(PlugInContext context) {
        try {
            this.jbInit(context);
            this.wbContext = context.getWorkbenchContext();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void jbInit(PlugInContext context) throws Exception {
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints gbConstraints = new GridBagConstraints();
        this.setLayout(gbLayout);
        gbConstraints.insets = new Insets(2, 2, 2, 2);
        gbConstraints.anchor = 17;
        JLabel title = new JLabel("<html><h2>" + this.getTitle() + "</h2><br/></br></html>");
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 2;
        gbLayout.setConstraints(title, gbConstraints);
        this.add(title);
        this.connectionPanel = new ConnectionPanel(context.getWorkbenchContext());
        this.connectionPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataStoreSaveDriverPanel.this.connectionChanged();
            }
        });
        this.addAncestorListener(new PanelAncestorListener());
        ++gbConstraints.gridy;
        gbLayout.setConstraints(this.connectionPanel, gbConstraints);
        this.add(this.connectionPanel);
        JLabel tableLabel = new JLabel(TABLE);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbConstraints.gridwidth = 1;
        gbLayout.setConstraints(tableLabel, gbConstraints);
        this.add(tableLabel);
        this.tableComboBox = new JComboBox<String>(this.tableList);
        this.tableComboBox.setPrototypeDisplayValue("abcdefghijklmnopqrstuvwxyz.abcdefghijklmnopqrstuvwxyz");
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.tableComboBox, gbConstraints);
        this.add(this.tableComboBox);
        this.createPrimaryKeyCheckBox = new JCheckBox(CREATE_DB_PK);
        this.createPrimaryKeyCheckBox.setSelected(true);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbLayout.setConstraints(this.createPrimaryKeyCheckBox, gbConstraints);
        this.add(this.createPrimaryKeyCheckBox);
        this.write3dGeomCheckBox = new JCheckBox(WRITE_3D_GEOM);
        this.write3dGeomCheckBox.setSelected(false);
        ++gbConstraints.gridy;
        gbLayout.setConstraints(this.write3dGeomCheckBox, gbConstraints);
        this.add(this.write3dGeomCheckBox);
        JLabel convertNaNZLabel = new JLabel(CONVERT_NAN_Z);
        ++gbConstraints.gridy;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(convertNaNZLabel, gbConstraints);
        this.add(convertNaNZLabel);
        this.convertNaNZTextField = new JTextField("NaN", 12);
        this.convertNaNZTextField.setEnabled(false);
        this.convertNaNZTextField.setEditable(false);
        this.convertNaNZTextField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return ((JTextField)input).getText().matches("NaN|\\d+(\\.\\d+)?");
            }
        });
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.convertNaNZTextField, gbConstraints);
        this.add(this.convertNaNZTextField);
        this.write3dGeomCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataStoreSaveDriverPanel.this.convertNaNZTextField.setEnabled(((JCheckBox)e.getSource()).isSelected());
                DataStoreSaveDriverPanel.this.convertNaNZTextField.setEditable(((JCheckBox)e.getSource()).isSelected());
            }
        });
        this.narrowGeometryTypeCheckBox = new JCheckBox(NARROW_GEOMETRY_TYPE);
        this.narrowGeometryTypeCheckBox.setSelected(false);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbLayout.setConstraints(this.narrowGeometryTypeCheckBox, gbConstraints);
        this.add(this.narrowGeometryTypeCheckBox);
        this.convertToMultiGeometryCheckBox = new JCheckBox(CONVERT_TO_MULTIGEOMETRY);
        this.convertToMultiGeometryCheckBox.setSelected(false);
        ++gbConstraints.gridy;
        gbLayout.setConstraints(this.convertToMultiGeometryCheckBox, gbConstraints);
        this.add(this.convertToMultiGeometryCheckBox);
        this.normalizedTableNameCheckBox = new JCheckBox(NORMALIZED_TABLE_NAME);
        this.normalizedTableNameCheckBox.setSelected(false);
        gbConstraints.gridx = 0;
        ++gbConstraints.gridy;
        gbLayout.setConstraints(this.normalizedTableNameCheckBox, gbConstraints);
        this.add(this.normalizedTableNameCheckBox);
        this.normalizedTableNameCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    DataStoreSaveDriverPanel.this.tableComboBox.setSelectedItem(SQLUtil.normalize(DataStoreSaveDriverPanel.this.wbContext.getLayerableNamePanel().getSelectedLayers()[0].getName()));
                } else {
                    DataStoreSaveDriverPanel.this.tableComboBox.setSelectedItem(DataStoreSaveDriverPanel.this.wbContext.getLayerableNamePanel().getSelectedLayers()[0].getName());
                }
            }
        });
        this.normalizedColumnNamesCheckBox = new JCheckBox(NORMALIZED_COLUMN_NAMES);
        this.normalizedColumnNamesCheckBox.setSelected(false);
        ++gbConstraints.gridy;
        gbLayout.setConstraints(this.normalizedColumnNamesCheckBox, gbConstraints);
        this.add(this.normalizedColumnNamesCheckBox);
    }

    protected String getTitle() {
        return I18N.getInstance().get(this.getClass().getName() + ".title");
    }

    @Override
    public String getValidationError() {
        if (this.connectionPanel.getConnectionDescriptor() == null) {
            return I18N.getInstance().get("org.openjump.core.ui.plugin.datastore.postgis.PostGISSaveDataSourceQueryChooser.no-connection-choosen");
        }
        if (this.tableComboBox.getSelectedItem() == null || this.tableComboBox.getSelectedItem().equals("")) {
            return I18N.getInstance().get("org.openjump.core.ui.plugin.datastore.postgis.PostGISSaveDataSourceQueryChooser.no-table-choosen");
        }
        return null;
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.okCancelPanel.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.okCancelPanel.removeActionListener(l);
    }

    @Override
    public boolean wasOKPressed() {
        return this.okCancelPanel.wasOKPressed();
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        return this.connectionPanel.getConnectionDescriptor();
    }

    public void setConnectionDescriptor(ConnectionDescriptor cd) {
        this.connectionPanel.setConnectionDescriptor(cd);
    }

    public String getTableName() {
        this.layer2TableMap.put(this.lastUsedLayerName, this.tableComboBox.getSelectedItem().toString());
        return this.tableComboBox.getSelectedItem().toString();
    }

    public void setTableName(String tableName) {
        this.tableComboBox.setSelectedItem(tableName);
    }

    public boolean isCreatePrimaryKeyColumnSelected() {
        return this.createPrimaryKeyCheckBox.isSelected();
    }

    public boolean writeCreate3dGeometriesSelected() {
        return this.write3dGeomCheckBox.isSelected();
    }

    public double nanZToValue() {
        return Double.parseDouble(this.convertNaNZTextField.getText());
    }

    public boolean isNarrowGeometryType() {
        return this.narrowGeometryTypeCheckBox.isSelected();
    }

    public boolean isConvertToMultiGeometry() {
        return this.convertToMultiGeometryCheckBox.isSelected();
    }

    public boolean isNormalizedTableName() {
        return this.normalizedTableNameCheckBox.isSelected();
    }

    public boolean isNormalizedColumnNames() {
        return this.normalizedColumnNamesCheckBox.isSelected();
    }

    private void layerChanged() {
        this.addItemToTableList(this.tableList, this.lastUsedLayerName);
    }

    private void connectionChanged() {
        try {
            if (ConnectionManager.instance(this.wbContext) == null || this.connectionPanel.getConnectionDescriptor() == null || this.getDSConnection() == null) {
                this.updateTableList(null);
            } else {
                DataStoreMetadata metadata = this.getDSConnection().getMetadata();
                this.updateTableList(metadata);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DataStoreConnection getDSConnection() throws Exception {
        return ConnectionManager.instance(this.wbContext).getOpenConnection(this.connectionPanel.getConnectionDescriptor());
    }

    private void updateTableList(DataStoreMetadata metadata) {
        Layer[] layers = this.wbContext.getLayerableNamePanel().getSelectedLayers();
        if (layers.length == 1) {
            String layerName = layers[0].getName();
            if (this.normalizedTableNameCheckBox.isSelected()) {
                layerName = SQLUtil.normalize(layerName);
            }
            this.addItemToTableList(this.tableList, layerName);
            this.tableComboBox.setSelectedItem(layerName);
        }
        if (metadata != null) {
            String[] tableNames;
            for (String t : tableNames = metadata.getDatasetNames()) {
                this.addItemToTableList(this.tableList, t);
            }
        }
        this.tableComboBox.setEditable(true);
        this.validate();
    }

    private void addItemToTableList(DefaultComboBoxModel<String> model, String item) {
        for (int i = 0; i < model.getSize(); ++i) {
            String item_i = model.getElementAt(i);
            int compare = item.compareTo(item_i);
            if (compare < 0) {
                model.insertElementAt(item, i);
                return;
            }
            if (compare != 0) continue;
            return;
        }
        model.insertElementAt(item, model.getSize());
    }

    private class PanelAncestorListener
    implements AncestorListener {
        private PanelAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent e) {
            Layer[] layers = DataStoreSaveDriverPanel.this.wbContext.getLayerableNamePanel().getSelectedLayers();
            if (layers.length == 1) {
                DataStoreSaveDriverPanel.this.connectionChanged();
                String layerName = layers[0].getName();
                if (!layerName.equals(DataStoreSaveDriverPanel.this.lastUsedLayerName)) {
                    DataStoreSaveDriverPanel.this.lastUsedLayerName = layerName;
                    DataStoreSaveDriverPanel.this.layerChanged();
                }
                if (DataStoreSaveDriverPanel.this.layer2TableMap.get(layerName) != null) {
                    DataStoreSaveDriverPanel.this.tableList.setSelectedItem(DataStoreSaveDriverPanel.this.layer2TableMap.get(layerName));
                } else {
                    DataStoreSaveDriverPanel.this.tableList.setSelectedItem(layerName);
                }
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }
    }
}

