/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.h2.H2DataStoreDriver;
import com.vividsolutions.jump.datastore.postgis.PostgisDataStoreDriver;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import org.openjump.core.ui.plugin.datastore.WritableDataStoreDataSource;
import org.openjump.core.ui.plugin.datastore.h2.H2DataStoreDataSource;
import org.openjump.core.ui.plugin.datastore.postgis2.PostGISDataStoreDataSource;

public class DataStoreDataSourceFactory {
    private static final String KEY = DataStoreDataSourceFactory.class.getName();

    public static WritableDataStoreDataSource createWritableDataStoreDataSource(ConnectionDescriptor connectionDescriptor, String datasetName, String geometryAttributeName, String externalPKName, boolean tableAlreadyCreated, String txManagerClass, WorkbenchContext context) throws Exception {
        WritableDataStoreDataSource source;
        String driverName = connectionDescriptor.getDataStoreDriverClassName();
        if (driverName.equals(PostgisDataStoreDriver.class.getName())) {
            source = new PostGISDataStoreDataSource(connectionDescriptor, datasetName, geometryAttributeName, externalPKName, txManagerClass, context);
            source.setTableAlreadyCreated(tableAlreadyCreated);
        } else if (driverName.equals(H2DataStoreDriver.class.getName())) {
            source = new H2DataStoreDataSource(connectionDescriptor, datasetName, geometryAttributeName, externalPKName, txManagerClass, context);
            source.setTableAlreadyCreated(tableAlreadyCreated);
        } else {
            throw new Exception(I18N.getInstance().get(KEY + ".no-writable-datastore-datasource", driverName));
        }
        return source;
    }
}

