/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.cts;

import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.coordsys.Geographic;
import com.vividsolutions.jump.coordsys.Planar;
import com.vividsolutions.jump.coordsys.Projection;
import org.cts.IllegalCoordinateException;
import org.cts.crs.CoordinateReferenceSystem;
import org.cts.cs.Axis;
import org.cts.op.CoordinateOperationException;
import org.cts.op.CoordinateSwitch;
import org.cts.op.UnitConversion;
import org.cts.units.Unit;
import org.locationtech.jts.util.Assert;

public class CoordinateSystemWrapper
extends CoordinateSystem {
    private CoordinateReferenceSystem crs;

    CoordinateSystemWrapper(final CoordinateReferenceSystem crs) {
        super(crs.getName(), crs.getAuthorityKey().toUpperCase().equals("EPSG") ? Integer.parseInt(crs.getAuthorityKey()) : 0, new Projection(){

            @Override
            public Planar asPlanar(Geographic q0, Planar p) {
                double[] dd = new double[]{q0.lat, q0.lon, q0.hgt};
                try {
                    if (crs.getCoordinateSystem().getAxis(0) == Axis.LONGITUDE) {
                        dd = CoordinateSwitch.SWITCH_LAT_LON.transform(dd);
                    }
                    dd = UnitConversion.createUnitConverter((Unit)Unit.DEGREE, (Unit)Unit.RADIAN).transform(dd);
                    dd = crs.getProjection().transform(dd);
                    return new Planar(dd[0], dd[1]);
                }
                catch (IllegalCoordinateException | CoordinateOperationException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Geographic asGeographic(Planar p, Geographic q) {
                double[] dd = new double[]{p.x, p.y, p.z};
                try {
                    dd = crs.getProjection().inverse().transform(dd);
                    if (crs.getCoordinateSystem().getAxis(0) == Axis.LONGITUDE) {
                        dd = CoordinateSwitch.SWITCH_LAT_LON.transform(dd);
                    }
                    dd = UnitConversion.createUnitConverter((Unit)Unit.RADIAN, (Unit)Unit.DEGREE).transform(dd);
                    return new Geographic(dd[0], dd[1]);
                }
                catch (IllegalCoordinateException | CoordinateOperationException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.crs = crs;
    }

    @Override
    public String toString() {
        return this.crs.getName();
    }

    @Override
    public String getName() {
        return this.crs.getName();
    }

    @Override
    public Projection getProjection() {
        return new Projection(){

            @Override
            public Planar asPlanar(Geographic q0, Planar p) {
                return null;
            }

            @Override
            public Geographic asGeographic(Planar p, Geographic q) {
                return null;
            }
        };
    }

    @Override
    public int getEPSGCode() {
        return this.crs.getAuthorityName().equals("EPSG") ? Integer.parseInt(this.crs.getAuthorityKey()) : 0;
    }

    @Override
    public int compareTo(Object o) {
        Assert.isTrue((boolean)(o instanceof CoordinateSystem));
        if (this == o) {
            return 0;
        }
        if (this == UNSPECIFIED) {
            return -1;
        }
        if (o == UNSPECIFIED) {
            return 1;
        }
        return this.toString().compareTo(o.toString());
    }
}

