/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.enablecheck;

import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.ErrorHandler;
import java.lang.reflect.Method;
import javax.swing.JComponent;

public class PropertyEnableCheck
implements EnableCheck {
    String disabledMessage = "";
    private Method method;
    private Object object;
    private Object expectedValue;
    private ErrorHandler errorHandler;
    private boolean invert;

    public PropertyEnableCheck(Object object, String checkMethodName, Object expectedValue, boolean invert, ErrorHandler errorHandler) {
        this(object, checkMethodName, expectedValue, errorHandler);
        this.invert = invert;
    }

    public PropertyEnableCheck(Object object, String checkMethodName, Object expectedValue, ErrorHandler errorHandler) {
        Class<?> clazz = object.getClass();
        this.object = object;
        this.expectedValue = expectedValue;
        this.errorHandler = errorHandler;
        try {
            this.method = clazz.getMethod(checkMethodName, new Class[0]);
        }
        catch (Throwable e) {
            errorHandler.handleThrowable(e);
        }
    }

    @Override
    public String check(JComponent component) {
        try {
            Object result = this.method.invoke(this.object, new Object[0]);
            if (result == this.expectedValue) {
                return this.getResult(true);
            }
            if (result == null) {
                return this.getResult(false);
            }
            if (this.expectedValue == null) {
                return this.getResult(false);
            }
            if (result.equals(this.expectedValue)) {
                return this.getResult(true);
            }
            return this.getResult(false);
        }
        catch (Throwable e) {
            this.errorHandler.handleThrowable(e);
            return e.getMessage();
        }
    }

    private String getResult(boolean equal) {
        if (equal || this.invert) {
            return null;
        }
        return this.disabledMessage;
    }
}

