/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler;

import java.awt.Color;
import java.util.Random;

public class ColorUtils {
    private Random random = new Random();

    public Color interpolateColor(Color startColor, Color endColor, double relDistance) throws Exception {
        if (relDistance < 0.0 || relDistance > 1.0) {
            throw new Exception("Relative distance out of range. Must be 0-1.");
        }
        int red = this.interpolate(startColor.getRed(), endColor.getRed(), relDistance);
        int green = this.interpolate(startColor.getGreen(), endColor.getGreen(), relDistance);
        int blue = this.interpolate(startColor.getBlue(), endColor.getBlue(), relDistance);
        return new Color(red, green, blue);
    }

    private int interpolate(int startValue, int endValue, double relDistance) {
        return (int)Math.round((double)startValue * (1.0 - relDistance) + (double)endValue * relDistance);
    }

    public Color randomColor() {
        int red = this.random.nextInt(256);
        int green = this.random.nextInt(256);
        int blue = this.random.nextInt(256);
        return new Color(red, green, blue);
    }
}

