/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import java.awt.Point;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.rasterimage.Stats;

public class Metadata {
    private final Envelope originalImageEnvelope;
    private final Envelope actualEnvelope;
    private final Point originalSize;
    private final Point actualSize;
    private final double originalCellSize;
    private final double actualCellSize;
    private double noDataValue = -3.40282346639E38;
    private final Stats stats;

    public Metadata(Envelope originalImageEnvelope, Envelope actualEnvelope, Point originalSize, Point actualSize, double originalCellSize, double actualCellSize, double noDataValue, Stats stats) {
        this.originalImageEnvelope = originalImageEnvelope;
        this.actualEnvelope = actualEnvelope;
        this.originalSize = originalSize;
        this.actualSize = actualSize;
        this.originalCellSize = originalCellSize;
        this.actualCellSize = actualCellSize;
        this.noDataValue = noDataValue;
        this.stats = stats;
    }

    public Envelope getOriginalImageEnvelope() {
        return this.originalImageEnvelope;
    }

    public Envelope getActualEnvelope() {
        return this.actualEnvelope;
    }

    public Coordinate getOriginalImageLowerLeftCoord() {
        return new Coordinate(this.originalImageEnvelope.getMinX(), this.originalImageEnvelope.getMinY());
    }

    public Coordinate getActualLowerLeftCoord() {
        return new Coordinate(this.actualEnvelope.getMinX(), this.actualEnvelope.getMinY());
    }

    public Point getOriginalSize() {
        return this.originalSize;
    }

    public Point getActualSize() {
        return this.actualSize;
    }

    public double getOriginalCellSize() {
        return this.originalCellSize;
    }

    public double getActualCellSize() {
        return this.actualCellSize;
    }

    public double getNoDataValue() {
        return this.noDataValue;
    }

    public Stats getStats() {
        return this.stats;
    }
}

