/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ccordsys.utils;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.imagery.ImageryLayerDataset;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageStyle;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.DataStoreQueryDataSource;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.io.FilenameUtils;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.ccordsys.utils.SRSInfo;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.TiffTags;

public class ProjUtils {
    private static final String PROJECTION_UNSPECIFIED = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.unknown_projection");
    private static final String USER_DEFINED = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.User_defined");
    private static final String NOT_RECOGNIZED = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.LayerPropertiesPlugIn.Not_recognized");
    private static final String NO_SRS = I18N.getInstance().get("org.openjump.core.ccordsys.No-srs");
    private static final String EMBEDDED_SRS = I18N.getInstance().get("org.openjump.core.ccordsys.Embedded-srs");
    private static final String NOT_CONSISTENT_SRS = I18N.getInstance().get("org.openjump.core.ccordsys.Not-consistent-srs");

    public static SRSInfo getSRSInfoFromGeoTiff(String fileSourcePath) throws IOException, TiffTags.TiffReadingException {
        return TiffTags.readMetadata(new File(fileSourcePath)).getSRSInfo();
    }

    public static SRSInfo getSRSInfoFromAuxiliaryFile(String fileSourcePath) throws URISyntaxException, IOException {
        Scanner scanner;
        int pos = fileSourcePath.lastIndexOf(46);
        String projectSourceFilePrj = fileSourcePath.substring(0, pos) + ".prj";
        String projectSourceRFilePrj = fileSourcePath + ".prj";
        String projectSourceRFileAux = fileSourcePath + ".aux.xml";
        String type = FilenameUtils.getExtension((String)fileSourcePath).toUpperCase();
        SRSInfo srsInfo = new SRSInfo();
        String textProj = "";
        if (type.matches("SHP|DXF|ASC|FLT|ADF|GRD|BIL")) {
            if (new File(projectSourceFilePrj).exists()) {
                scanner = new Scanner(new File(projectSourceFilePrj));
                textProj = scanner.nextLine();
                srsInfo = new SRSInfo().setSource(projectSourceFilePrj);
                scanner.close();
            }
        } else if (new File(projectSourceRFilePrj).exists()) {
            scanner = new Scanner(new File(projectSourceRFilePrj));
            textProj = scanner.nextLine();
            srsInfo = new SRSInfo().setSource(projectSourceRFilePrj);
            scanner.close();
        } else if (new File(projectSourceRFileAux).exists()) {
            scanner = new Scanner(new File(projectSourceRFileAux));
            textProj = scanner.useDelimiter("\\A").next();
            if (textProj.contains("<WKT>") || textProj.contains("<SRS>")) {
                textProj = ProjUtils.getWktProjDefinition(textProj);
                srsInfo = new SRSInfo().setSource(projectSourceRFileAux);
            }
            scanner.close();
        }
        String prjName = ProjUtils.decodeProjDescription(textProj);
        srsInfo.setDescription(prjName);
        srsInfo.complete();
        return srsInfo;
    }

    public static String readableFormatWKTCode(String WKT2) {
        String HROGC = "";
        HROGC = WKT2.replace(",GEOGCS", ",<br>GEOCS").replace(",DATUM", ",<br>DATUM").replace(",SPHEROID", ",<br>SPHEROID").replace("],", "],<br>");
        return HROGC;
    }

    private static String decodeProjDescription(String textProj) {
        String prjname = "";
        try {
            textProj = textProj.replaceAll("&quot;", "\"");
            int start = textProj.indexOf("[\"");
            int end = textProj.indexOf("\",", start);
            prjname = textProj.substring(start + 2, end);
            prjname = prjname.replaceAll("_", " ").replace(" / ", " ").replaceAll("\\bft US\\b", "(ftUS)").replaceAll("\\bftUS\\b", "(ftUS)").replaceAll("\\bft\\b", "(ft)").replaceAll("feet", "ft").replaceAll("WGS 1984", "WGS 84").replaceAll("ED 1950", "ED50").replaceAll("NAD 1983 UTM", "NAD83 UTM").replaceAll("HARN", "(HARN)").replaceAll("\\bCSRS98\\b", "(CSRS98)").replaceAll("CSRS", "(CSRS)").replaceAll("\\bNSRS2007\\b", "(NSRS2007)").replaceAll("\\bNAD27_76\\b", "NAD27(76)").replaceAll("\\bCGQ77\\b", " (CGQ77)").replaceAll("\\bED77\\b", "(ED77)").replaceAll("\\b1942 83\\b", "1942(83)").replaceAll("\\b1942 58\\b", "1942(58)").replaceAll("\\bSegara Jakarta\\b", "Segara (Jakarta)").replaceAll("\\bRome\\b", "(Rome)").replaceAll("\\bParis\\b", "(Paris)").replaceAll("\\bFerro\\b", "(Ferro)");
        }
        catch (Exception ex) {
            prjname = NOT_RECOGNIZED;
        }
        return prjname;
    }

    private static String getWktProjDefinition(String textProj) {
        String prjname = "";
        try {
            if (textProj.contains("<WKT>")) {
                int start = textProj.indexOf("<WKT>");
                int end = textProj.indexOf("</WKT>", start);
                prjname = textProj.substring(start, end);
            } else if (textProj.contains("<SRS>")) {
                int start = textProj.indexOf("<SRS>");
                int end = textProj.indexOf("</SRS>", start);
                prjname = textProj.substring(start, end);
            } else {
                prjname = textProj;
            }
        }
        catch (Exception ex) {
            prjname = textProj;
        }
        return prjname;
    }

    public static SRSInfo getSRSInfoFromLayerStyleOrSource(Layer layer) throws Exception {
        SRIDStyle sridStyle = (SRIDStyle)layer.getStyle(SRIDStyle.class);
        int SRID_style_int = sridStyle.getSRID();
        String SRID_style_string = String.valueOf(SRID_style_int);
        SRSInfo srsInfo = ProjUtils.getSRSInfoFromLayerSource(layer);
        String SRID_srs_string = srsInfo.getCode();
        srsInfo.setCode(SRID_style_string);
        if (SRID_srs_string.equals("0") & SRID_style_string.equals("0") & !ProjUtils.isTemporaryLayer(layer)) {
            srsInfo.setSource(NO_SRS);
        }
        if (!SRID_style_string.equals(SRID_srs_string) & SRID_srs_string.equals("0") & !SRID_style_string.equals("0") & !ProjUtils.isTemporaryLayer(layer) || ProjUtils.isImageGeoTIFFLayer(layer)) {
            srsInfo.setSource(EMBEDDED_SRS);
        }
        if (!SRID_style_string.equals(SRID_srs_string) & !SRID_style_string.equals("0") & !SRID_srs_string.equals("0")) {
            srsInfo.setSource(NOT_CONSISTENT_SRS);
        }
        srsInfo.complete();
        return srsInfo;
    }

    public static SRSInfo getSRSInfoFromLayerStyleOrSource_old(Layer layer) throws Exception {
        SRSInfo srsInfo = new SRSInfo();
        SRIDStyle sridStyle = (SRIDStyle)layer.getStyle(SRIDStyle.class);
        int oldSRID = sridStyle.getSRID();
        if (oldSRID > 0) {
            srsInfo.setCode(Integer.toString(oldSRID));
            srsInfo.complete();
        } else {
            srsInfo = ProjUtils.getSRSInfoFromLayerSource(layer);
        }
        return srsInfo;
    }

    public static SRSInfo getSRSInfoFromLayerSource(Layer layer) throws Exception {
        String fileSourcePath = "";
        SRSInfo srsInfo = new SRSInfo();
        if (ProjUtils.isImageFileLayer(layer)) {
            TiffTags.TiffMetadata metadata;
            String extension;
            FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
            String sourcePathImage = null;
            for (Feature feature : featureCollection) {
                File f;
                sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
                if (sourcePathImage == null || sourcePathImage.isEmpty() || !(f = new File(URI.create(sourcePathImage).getPath())).exists()) continue;
                fileSourcePath = f.getAbsolutePath();
                break;
            }
            srsInfo = (extension = FileUtil.getExtension(fileSourcePath).toUpperCase()).equals("TIF") || extension.equals("TIFF") ? ((metadata = TiffTags.readMetadata(new File(fileSourcePath))).isGeoTiff() ? metadata.getSRSInfo() : ProjUtils.getSRSInfoFromAuxiliaryFile(fileSourcePath)) : ProjUtils.getSRSInfoFromAuxiliaryFile(fileSourcePath);
        } else if (!ProjUtils.isDataBaseLayer(layer)) {
            DataSourceQuery dsq = layer.getDataSourceQuery();
            Map<String, Object> properties = dsq.getDataSource().getProperties();
            if (properties.get("Uri") != null) {
                fileSourcePath = new URI(properties.get("Uri").toString()).getPath();
                srsInfo = ProjUtils.getSRSInfoFromAuxiliaryFile(fileSourcePath);
            } else if (properties.get("File") != null) {
                fileSourcePath = properties.get("File").toString();
                srsInfo = ProjUtils.getSRSInfoFromAuxiliaryFile(fileSourcePath);
            }
        }
        return srsInfo;
    }

    private static boolean isImageFileLayer(Layer layer) {
        return layer.getStyle(ReferencedImageStyle.class) != null && layer.getDescription() != null;
    }

    private static boolean isTemporaryLayer(Layer layer) {
        DataSourceQuery dsq = layer.getDataSourceQuery();
        String sclass = layer.getClass().getSimpleName();
        return dsq == null && layer.getStyle(ReferencedImageStyle.class) == null && layer.getDescription() != null && !sclass.equals("WFSLayer");
    }

    private static boolean isDataBaseLayer(Layer layer) {
        DataSourceQuery dsq = layer.getDataSourceQuery();
        return dsq == null || dsq.getDataSource() instanceof DataStoreQueryDataSource;
    }

    public static boolean isImageGeoTIFFLayer(Layer layer) {
        String fileSourcePath = "";
        if (layer.getStyle(ReferencedImageStyle.class) != null && layer.getDescription() != null) {
            String extension;
            FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
            String sourcePathImage = null;
            for (Feature feature : featureCollection) {
                File f;
                sourcePathImage = feature.getString(ImageryLayerDataset.ATTR_URI);
                if (sourcePathImage == null || sourcePathImage.isEmpty() || !(f = new File(URI.create(sourcePathImage).getPath())).exists()) continue;
                fileSourcePath = f.getAbsolutePath();
                break;
            }
            if ((extension = FileUtil.getExtension(fileSourcePath).toUpperCase()).equals("TIF") || extension.equals("TIFF")) {
                TiffTags.TiffMetadata metadata = null;
                try {
                    metadata = TiffTags.readMetadata(new File(fileSourcePath));
                }
                catch (IOException | TiffTags.TiffReadingException e) {
                    e.printStackTrace();
                }
                return metadata.isGeoTiff();
            }
        }
        return false;
    }

    public static SRSInfo getSRSInfoFromLayerSource(RasterImageLayer layer) throws Exception, URISyntaxException {
        String fileSourcePath = layer.getImageFileName();
        String extension = FileUtil.getExtension(fileSourcePath).toLowerCase();
        SRSInfo srsInfo = null;
        if (extension.equals("tif") || extension.equals("tiff")) {
            try {
                TiffTags.TiffMetadata metadata = TiffTags.readMetadata(new File(fileSourcePath));
                if (metadata.isGeoTiff()) {
                    srsInfo = metadata.getSRSInfo();
                    srsInfo.setSource(EMBEDDED_SRS);
                }
            }
            catch (Exception e) {
                Logger.error(e);
            }
        }
        if (srsInfo == null) {
            srsInfo = ProjUtils.getSRSInfoFromAuxiliaryFile(fileSourcePath);
        }
        if (srsInfo.getCode().equals("0") || layer.isTemporaryLayer()) {
            srsInfo.setSource("null");
        }
        srsInfo.complete();
        return srsInfo;
    }
}

