/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.apitools;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.apitools.FeatureCollectionTools;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.apitools.ToolToMakeYourLifeEasier;

public class SelectionTools
extends ToolToMakeYourLifeEasier {
    protected PlugInContext context = null;

    public SelectionTools(PlugInContext context) {
        this.context = context;
    }

    public void selectFeatures(List features) {
        SelectionTools.selectFeatures(features, this.context);
    }

    public static void selectLayer(PlugInContext context, Layer layer) {
    }

    public static void selectFeatures(List features, PlugInContext context) {
        SelectionManager sm = context.getLayerViewPanel().getSelectionManager();
        sm.clear();
        Map<Layer, List<Feature>> layer2FeatList = LayerTools.getLayer2FeatureMap(features, context);
        Layer[] layersWithFeatures = layer2FeatList.keySet().toArray(new Layer[0]);
        for (int i = 0; i < layersWithFeatures.length; ++i) {
            sm.getFeatureSelection().selectItems(layersWithFeatures[i], (ArrayList)layer2FeatList.get(layersWithFeatures[i]));
        }
    }

    public static List<Feature> getSelectedFeaturesFromLayer(PlugInContext context, Layer layer) {
        return new ArrayList<Feature>(context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(layer));
    }

    public static List<Feature> getSelectedFeatures(PlugInContext context) {
        return new ArrayList<Feature>(context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems());
    }

    public List<Feature> getSelectedFeatures() {
        return SelectionTools.getSelectedFeatures(this.context);
    }

    public static Geometry getFenceGeometry(PlugInContext context) {
        Layer fence = new FenceLayerFinder(context.getLayerViewPanel()).getLayer();
        if (fence == null) {
            return null;
        }
        FeatureCollectionWrapper fenceCollWrap = fence.getFeatureCollectionWrapper();
        Feature fencePolygon = fenceCollWrap.getUltimateWrappee().getFeatures().get(0);
        return fencePolygon.getGeometry();
    }

    public Geometry getFenceGeometry() {
        return SelectionTools.getFenceGeometry(this.context);
    }

    public List getFeaturesInFence() {
        Geometry fenceGeometry = this.getFenceGeometry();
        return this.getFeaturesInGeometry(fenceGeometry);
    }

    public List getFeaturesInGeometry(Geometry fenceGeometry) {
        ArrayList featsInFence = new ArrayList();
        List<Layer> layers = this.context.getLayerManager().getVisibleLayers(false);
        for (Layer tmp : layers) {
            featsInFence.addAll(SelectionTools.getFeaturesInFenceInLayerAsList(tmp, fenceGeometry));
        }
        return featsInFence;
    }

    public static Feature[] getFeaturesInFenceInLayer(Layer layer, Geometry fenceGeometry) {
        return SelectionTools.getFeaturesOnTheSameSpot(layer, fenceGeometry, false);
    }

    public static List getFeaturesInFenceInLayerAsList(Layer layer, Geometry fenceGeometry) {
        Feature[] featureArray = SelectionTools.getFeaturesOnTheSameSpot(layer, fenceGeometry, false);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < featureArray.length; ++i) {
            result.add(featureArray[i]);
        }
        return result;
    }

    public static Feature[] getFeaturesInFenceInLayer(Feature[] featArray, Geometry fenceGeometry) {
        return SelectionTools.getFeaturesOnTheSameSpot(featArray, fenceGeometry, false);
    }

    public static Feature[] getFeaturesOnTheSameSpot(Layer layer, Geometry fenceGeometry, boolean bothWays) {
        FeatureCollection featColl = layer.getFeatureCollectionWrapper().getUltimateWrappee();
        return SelectionTools.getFeaturesOnTheSameSpot(FeatureCollectionTools.FeatureCollection2FeatureArray(featColl), fenceGeometry, bothWays);
    }

    public static Feature[] getFeaturesOnTheSameSpot(Feature[] featArray, Geometry fenceGeometry, boolean bothWays) {
        ArrayList<Feature> featuresInsideTheFence = new ArrayList<Feature>();
        Geometry featGeom = null;
        for (Feature feat : featArray) {
            featGeom = feat.getGeometry();
            if (!fenceGeometry.disjoint(featGeom)) {
                featuresInsideTheFence.add(feat);
                continue;
            }
            if (!bothWays || featGeom.disjoint(fenceGeometry)) continue;
            featuresInsideTheFence.add(feat);
        }
        return featuresInsideTheFence.toArray(new Feature[0]);
    }
}

