/*
 * Decompiled with CFR 0.152.
 */
package de.latlon.deejump.plugin.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.java2xml.Java2XML;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.util.ScreenScale;

public class LayerStyle2SLDPlugIn
extends AbstractPlugIn {
    public static final ImageIcon ICON = IconLoader.icon("sld_out_16.png");
    protected static Transformer transformer = null;
    private Java2XML java2Xml = new Java2XML();
    private JFileChooser fileChooser;
    private MultiInputDialog dialog;
    private String styleTitle;
    private String geomProperty;
    private String styleName;
    private String wmsLayerName;
    private String namespace;
    private String featureTypeStyle;
    private double scaleFactor = 1.0;

    @Override
    public String getName() {
        return I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Transform-layer-style-into-sld");
    }

    public void install(PlugInContext context) throws Exception {
        context.getWorkbenchContext().getWorkbench().getFrame().getToolBar().addPlugIn(this.getIcon(), this, this.createEnableCheck(context.getWorkbenchContext()), context.getWorkbenchContext());
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        EnableCheck enableCheck = this.createEnableCheck(context.getWorkbenchContext());
        TitledPopupMenu popupMenu = context.getWorkbenchFrame().getLayerNamePopupMenu();
        featureInstaller.addPopupMenuItem(popupMenu, this, new String[]{MenuNames.STYLE}, this.getName(), false, ICON, enableCheck);
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.LAYER}, this.getName(), false, ICON, enableCheck);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Blackboard bb = PersistentBlackboardPlugIn.get(context.getWorkbenchContext());
        String fileName = (String)bb.get("LayerStyle2SLDPlugIn.filename");
        this.reportNothingToUndoYet(context);
        Layer layer = context.getSelectedLayer(0);
        if (layer == null) {
            return false;
        }
        this.geomProperty = "GEOM";
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getAttributeType(i) != AttributeType.GEOMETRY) continue;
            this.geomProperty = schema.getAttributeName(i);
        }
        this.initDialog(context);
        this.dialog.setVisible(true);
        if (!this.dialog.wasOKPressed()) {
            return false;
        }
        this.wmsLayerName = this.dialog.getText(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.WMS-Layer-name"));
        this.styleName = this.dialog.getText(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Style-name"));
        this.styleTitle = this.dialog.getText(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Style-title"));
        this.featureTypeStyle = this.dialog.getText(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Feature-Type-Style"));
        this.geomProperty = this.dialog.getText(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.geomProperty"));
        this.namespace = this.dialog.getText(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Namespace"));
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            if (fileName != null) {
                this.fileChooser.setCurrentDirectory(new File(fileName).getParentFile());
            }
            this.fileChooser.setApproveButtonText(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Save"));
            this.fileChooser.setDialogTitle(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Save-style-as-SLD"));
        }
        if (0 == this.fileChooser.showOpenDialog(context.getWorkbenchFrame())) {
            File file = File.createTempFile("temptask", ".xml");
            file.deleteOnExit();
            bb.put("LayerStyle2SLDPlugIn.filename", this.fileChooser.getSelectedFile().getAbsoluteFile().toString());
            this.scaleFactor = this.calcScaleFactor(context.getLayerViewPanel());
            this.transformXML(layer, file, this.fileChooser.getSelectedFile(), this.scaleFactor);
        }
        return true;
    }

    private void initDialog(PlugInContext context) {
        if (this.dialog == null) {
            this.dialog = new MultiInputDialog(context.getWorkbenchFrame(), I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.SLD-Parameters"), true);
            this.dialog.addSeparator();
            this.dialog.addTextField(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.geomProperty"), this.geomProperty, 25, null, I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Input-the-name-of-the-geometry-property"));
            this.dialog.addSeparator();
            String name = context.getCandidateLayer(0).getName();
            this.dialog.addTextField(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.WMS-Layer-name"), name, 25, null, I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.WMS-Layer-name"));
            this.dialog.addTextField(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Style-name"), name, 25, null, I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Style-name"));
            this.dialog.addTextField(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Style-title"), name, 25, null, I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Style-title"));
            this.dialog.addTextField(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Feature-Type-Style"), name, 25, null, I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Feature-Type-Style"));
            this.dialog.addTextField(I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Namespace"), "http://www.deegree.org/app", 25, null, I18N.getInstance().get("deejump.pluging.style.LayerStyle2SLDPlugIn.Namespace"));
            GUIUtil.centreOnWindow(this.dialog);
        }
    }

    private void transformXML(Layer layer, File inputXML, File outputXML, double scaleFactor) throws Exception {
        if (layer.getFeatureCollectionWrapper().getFeatures().size() == 0) {
            throw new Exception(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.StatisticOverViewPlugIn.Selected-layer-is-empty"));
        }
        BasicFeature bf = (BasicFeature)layer.getFeatureCollectionWrapper().getFeatures().get(0);
        Geometry geo = bf.getGeometry();
        String geoType = geo.getGeometryType();
        this.java2Xml.write((Object)layer, "layer", inputXML);
        FileInputStream input = new FileInputStream(inputXML);
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(outputXML), StandardCharsets.UTF_8);
        HashMap<String, String> map = new HashMap<String, String>(9);
        map.put("wmsLayerName", this.wmsLayerName);
        map.put("featureTypeStyle", this.featureTypeStyle);
        map.put("styleName", this.styleName);
        map.put("styleTitle", this.styleTitle);
        map.put("geoType", geoType);
        map.put("geomProperty", this.geomProperty);
        map.put("Namespace", this.namespace);
        Double d = layer.getMinScale();
        d = d != null ? d : 0.0;
        map.put("minScale", "" + LayerStyle2SLDPlugIn.toRealWorldScale(scaleFactor, d));
        double largeNumber = 9.9999999999E10;
        d = layer.getMaxScale();
        d = d != null ? d : new Double(9.9999999999E10);
        map.put("maxScale", "" + LayerStyle2SLDPlugIn.toRealWorldScale(scaleFactor, d));
        fw.write(LayerStyle2SLDPlugIn.transformContext(input, map));
        fw.close();
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(LayerStyle2SLDPlugIn.class.getResource("sldstyle.png"));
    }

    public static String transformContext(InputStream layerXML, Map<String, String> parameters) throws TransformerException {
        return LayerStyle2SLDPlugIn.transformContext(new InputStreamReader(layerXML, StandardCharsets.UTF_8), parameters);
    }

    public static String transformContext(Reader layerXML, Map<String, String> parameters) throws TransformerException {
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        StreamSource streamSource = new StreamSource(layerXML);
        transformer.clearParameters();
        for (String key : parameters.keySet()) {
            transformer.setParameter(key, parameters.get(key));
        }
        transformer.transform(streamSource, sr);
        try {
            sw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Logger.debug(sw.toString());
        return sw.toString();
    }

    private static void initTransformer() {
        try {
            URL xslUrl = LayerStyle2SLDPlugIn.class.getResource("layerstyle2sld.xsl");
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            InputStreamReader isr = new InputStreamReader(xslUrl.openStream(), StandardCharsets.UTF_8);
            StreamSource streamSrc = new StreamSource(isr);
            transformer = transformerFactory.newTransformer(streamSrc);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory ecf = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck mec = new MultiEnableCheck().add(ecf.createWindowWithLayerNamePanelMustBeActiveCheck()).add(ecf.createExactlyNLayerablesMustBeSelectedCheck(1, Layer.class));
        return mec;
    }

    public static double toRealWorldScale(double scaleFactor, double jumpScale) {
        return jumpScale / scaleFactor;
    }

    private double calcScaleFactor(LayerViewPanel panel) {
        double internalScale = 1.0 / panel.getViewport().getScale();
        double realScale = ScreenScale.getHorizontalMapScale(panel.getViewport());
        return internalScale / realScale;
    }

    static {
        LayerStyle2SLDPlugIn.initTransformer();
    }
}

