/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.simplify;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.locationtech.jts.coverage.CoverageSimplifier;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class CoverageSimplifierPlugIn
extends AbstractThreadedUiPlugIn {
    private String LAYER;
    private String DESCRIPTION;
    private String CREATE_NEW_LAYER;
    private String CREATE_NEW_LAYER_TOOLTIP;
    private String UPDATE_SOURCE;
    private String UPDATE_SOURCE_TOOLTIP;
    private String SIMPLIFICATION_TOLERANCE;
    private String SIMPLIFICATION_TOLERANCE_TOOLTIP;
    private String USE_ATTRIBUTE;
    private String USE_ATTRIBUTE_TOOLTIP;
    private String ATTRIBUTE;
    private String ATTRIBUTE_TOOLTIP;
    private String OTHER_PARAMETERS;
    private String SMALL_RINGS_REMOVER_COEFFICIENT;
    private String SMALL_RINGS_REMOVER_COEFFICIENT_TOOLTIP;
    private String PRESERVE_OUTER_BOUNDARY;
    private String PRESERVE_OUTER_BOUNDARY_TOOLTIP;
    private String SMOOTHNESS_COEFFICIENT;
    private String SMOOTHNESS_COEFFICIENT_TOOLTIP;
    private static final String P_LAYER_NAME = "LayerName";
    private static final String P_UPDATE_SOURCE = "UpdateSource";
    private static final String P_SIMPLIFICATION_TOLERANCE = "SimplificationTolerance";
    private static final String P_USE_ATTRIBUTE = "UseAttribute";
    private static final String P_SIMPLIFICATION_ATTRIBUTE = "SimplificationAttribute";
    private static final String P_SMALL_RINGS_REMOVER_COEFFICIENT = "SmallRingsRemoverCoefficient";
    private static final String P_PRESERVE_OUTER_BOUNDARY = "PreserveOuterBoundary";
    private static final String P_SMOOTHNESS_COEFFICIENT = "SmoothnessCoefficient";

    public CoverageSimplifierPlugIn() {
        super(I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn") + "...", IconLoader.icon("simplify_coverage_icon.png"));
        this.addParameter(P_LAYER_NAME, null);
        this.addParameter(P_UPDATE_SOURCE, false);
        this.addParameter(P_SIMPLIFICATION_TOLERANCE, 1.0);
        this.addParameter(P_USE_ATTRIBUTE, false);
        this.addParameter(P_SIMPLIFICATION_ATTRIBUTE, null);
        this.addParameter(P_SMALL_RINGS_REMOVER_COEFFICIENT, 1.0);
        this.addParameter(P_PRESERVE_OUTER_BOUNDARY, false);
        this.addParameter(P_SMOOTHNESS_COEFFICIENT, 0.0);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.GENERALIZATION}, this.getName(), false, this.getIcon(), CoverageSimplifierPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.LAYER = I18N.getInstance().get("ui.GenericNames.LAYER");
        this.DESCRIPTION = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.description");
        this.CREATE_NEW_LAYER = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.create-new-layer");
        this.CREATE_NEW_LAYER_TOOLTIP = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.create-new-layer-tooltip");
        this.UPDATE_SOURCE = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.update-source");
        this.UPDATE_SOURCE_TOOLTIP = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.update-source-tooltip");
        this.SIMPLIFICATION_TOLERANCE = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.simplification-tolerance");
        this.SIMPLIFICATION_TOLERANCE_TOOLTIP = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.simplification-tolerance-tooltip");
        this.USE_ATTRIBUTE = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.use-attribute");
        this.USE_ATTRIBUTE_TOOLTIP = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.use-attribute-tooltip");
        this.ATTRIBUTE = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.attribute");
        this.ATTRIBUTE_TOOLTIP = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.attribute-tooltip");
        this.OTHER_PARAMETERS = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.other-parameters");
        this.SMALL_RINGS_REMOVER_COEFFICIENT = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.small-rings-remover-coefficient");
        this.SMALL_RINGS_REMOVER_COEFFICIENT_TOOLTIP = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.small-ring-remover-coefficient-tooltip");
        this.PRESERVE_OUTER_BOUNDARY = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.preserve_outer_boundary");
        this.PRESERVE_OUTER_BOUNDARY_TOOLTIP = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.preserve_outer_boundary-tooltip");
        this.SMOOTHNESS_COEFFICIENT = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.smoothness_coefficient");
        this.SMOOTHNESS_COEFFICIENT_TOOLTIP = I18N.getInstance().get("ui.plugin.simplify.CoverageSimplifierPlugIn.smoothness_coefficient-tooltip");
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        Geometry[] simplifiedGeometries;
        Layer layer = context.getLayerManager().getLayer((String)this.getParameter(P_LAYER_NAME));
        FeatureSchema schema = layer.getFeatureCollectionWrapper().getFeatureSchema();
        boolean updateSource = (Boolean)this.getParameter(P_UPDATE_SOURCE);
        boolean useAttribute = (Boolean)this.getParameter(P_USE_ATTRIBUTE);
        int attributeIndex = this.getBooleanParam(P_USE_ATTRIBUTE) != false ? schema.getAttributeIndex(this.getStringParam(P_SIMPLIFICATION_ATTRIBUTE)) : -1;
        List<Feature> features = layer.getFeatureCollectionWrapper().getFeatures();
        Geometry[] source = new Geometry[features.size()];
        double[] perFeatureTolerance = new double[features.size()];
        for (int i = 0; i < features.size(); ++i) {
            source[i] = features.get(i).getGeometry();
            if (!useAttribute) continue;
            Object t = features.get(i).getAttribute(attributeIndex);
            perFeatureTolerance[i] = t == null ? 0.0 : (Double)t;
        }
        Geometry[] geometryArray = simplifiedGeometries = useAttribute ? this.simplify(source, perFeatureTolerance) : this.simplify(source);
        if (updateSource) {
            this.updateSourceLayer(monitor, context, layer, simplifiedGeometries);
        } else {
            this.createNewLayer(monitor, context, layer, simplifiedGeometries);
        }
    }

    private void updateSourceLayer(TaskMonitor monitor, PlugInContext context, Layer layer, Geometry[] simplifiedGeometries) {
        EditTransaction transaction = new EditTransaction(new LinkedHashSet<Feature>(), "CoverageSimplifier", layer, true, true, context.getLayerViewPanel().getContext());
        List<Feature> features = layer.getFeatureCollectionWrapper().getFeatures();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            transaction.modifyFeatureGeometry(feature, simplifiedGeometries[i]);
        }
        transaction.commit();
    }

    private void createNewLayer(TaskMonitor monitor, PlugInContext context, Layer layer, Geometry[] simplifiedGeometries) {
        FeatureDataset ds = new FeatureDataset(layer.getFeatureCollectionWrapper().getFeatureSchema());
        List<Feature> features = layer.getFeatureCollectionWrapper().getFeatures();
        for (int i = 0; i < features.size(); ++i) {
            Feature newFeature = features.get(i).clone(false, true);
            newFeature.setGeometry(simplifiedGeometries[i]);
            ds.add(newFeature);
        }
        context.getLayerManager().addLayer(GenericNames.RESULT_LAYER, layer.getName() + "_simplified_" + (Double)this.getParameter(P_SIMPLIFICATION_TOLERANCE), ds);
    }

    private Geometry[] simplify(Geometry[] source) {
        CoverageSimplifier simplifier = new CoverageSimplifier(source);
        simplifier.setRemovableRingSizeFactor(this.getDoubleParam(P_SMALL_RINGS_REMOVER_COEFFICIENT).doubleValue());
        simplifier.setSmoothWeight(this.getDoubleParam(P_SMOOTHNESS_COEFFICIENT).doubleValue());
        double innerTolerance = this.getDoubleParam(P_SIMPLIFICATION_TOLERANCE);
        double outerTolerance = this.getBooleanParam(P_PRESERVE_OUTER_BOUNDARY) != false ? 0.0 : innerTolerance;
        return simplifier.simplify(innerTolerance, outerTolerance);
    }

    private Geometry[] simplify(Geometry[] source, double[] tolerances) {
        CoverageSimplifier simplifier = new CoverageSimplifier(source);
        simplifier.setRemovableRingSizeFactor(this.getDoubleParam(P_SMALL_RINGS_REMOVER_COEFFICIENT).doubleValue());
        simplifier.setSmoothWeight(this.getDoubleParam(P_SMOOTHNESS_COEFFICIENT).doubleValue());
        return simplifier.simplify(tolerances);
    }

    private void setDialogValues(final MultiInputDialog dialog, final PlugInContext context) {
        dialog.setSideBarDescription(this.DESCRIPTION);
        dialog.setSideBarImage(new ImageIcon(IconLoader.image("simplify_coverage.png").getScaledInstance(172, 127, 4)));
        final JComboBox<Layer> layerComboBox = dialog.addLayerComboBox(this.LAYER, context.getCandidateLayer(0), context.getLayerManager());
        JRadioButton createNewRadioButton = dialog.addRadioButton(this.CREATE_NEW_LAYER, "new/update", (Boolean)this.getParameter(P_UPDATE_SOURCE) == false, this.CREATE_NEW_LAYER_TOOLTIP);
        JRadioButton updateRadioButton = dialog.addRadioButton(this.UPDATE_SOURCE, "new/update", (Boolean)this.getParameter(P_UPDATE_SOURCE), this.UPDATE_SOURCE_TOOLTIP);
        dialog.addSubTitle(this.SIMPLIFICATION_TOLERANCE);
        final JTextField toleranceTextField = dialog.addDoubleField(this.SIMPLIFICATION_TOLERANCE, this.getDoubleParam(P_SIMPLIFICATION_TOLERANCE), 10, this.SIMPLIFICATION_TOLERANCE_TOOLTIP);
        final JCheckBox preserveOuterBoundaryChecBox = dialog.addCheckBox(this.PRESERVE_OUTER_BOUNDARY, this.getBooleanParam(P_PRESERVE_OUTER_BOUNDARY), this.PRESERVE_OUTER_BOUNDARY_TOOLTIP);
        final JCheckBox useAttributeCheckBox = dialog.addCheckBox(this.USE_ATTRIBUTE, false, this.USE_ATTRIBUTE_TOOLTIP);
        final JComboBox<String> attributeComboBox = dialog.addAttributeComboBox(this.ATTRIBUTE, this.LAYER, AttributeTypeFilter.NUMERIC_FILTER, this.ATTRIBUTE_TOOLTIP);
        attributeComboBox.setEnabled(this.getBooleanParam(P_USE_ATTRIBUTE));
        dialog.addSubTitle(this.OTHER_PARAMETERS);
        JTextField smallRingsRemoverCoefficientTextField = dialog.addDoubleField(this.SMALL_RINGS_REMOVER_COEFFICIENT, this.getDoubleParam(P_SMALL_RINGS_REMOVER_COEFFICIENT), 10, this.SMALL_RINGS_REMOVER_COEFFICIENT_TOOLTIP);
        final JTextField smoothnessCoefficientTextField = dialog.addDoubleField(this.SMOOTHNESS_COEFFICIENT, this.getDoubleParam(P_SMOOTHNESS_COEFFICIENT), 10, this.SMOOTHNESS_COEFFICIENT_TOOLTIP);
        layerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ActionListener listener : layerComboBox.getActionListeners()) {
                    if (listener == this) continue;
                    listener.actionPerformed(e);
                }
                List<String> numericAttributes = AttributeTypeFilter.NUMERIC_FILTER.filter(context.getLayerManager().getLayer((String)layerComboBox.getSelectedItem()));
                boolean hasNumericAttributes = !numericAttributes.isEmpty();
                useAttributeCheckBox.setEnabled(hasNumericAttributes);
                attributeComboBox.setModel(new DefaultComboBoxModel<Object>(numericAttributes.toArray()));
            }
        });
        preserveOuterBoundaryChecBox.addActionListener(e -> {
            String image = preserveOuterBoundaryChecBox.isSelected() ? "simplify_coverage_pob.png" : "simplify_coverage.png";
            dialog.setSideBarImage(new ImageIcon(IconLoader.image(image).getScaledInstance(172, 127, 4)));
        });
        useAttributeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                toleranceTextField.setEnabled(!useAttributeCheckBox.isSelected());
                preserveOuterBoundaryChecBox.setEnabled(!useAttributeCheckBox.isSelected());
                attributeComboBox.setEnabled(useAttributeCheckBox.isSelected());
                CoverageSimplifierPlugIn.this.setSideBarImage(dialog);
            }
        });
        smoothnessCoefficientTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dialog.getDouble(CoverageSimplifierPlugIn.this.SMOOTHNESS_COEFFICIENT) < 0.0) {
                    smoothnessCoefficientTextField.setText("0.0");
                }
                if (dialog.getDouble(CoverageSimplifierPlugIn.this.SMOOTHNESS_COEFFICIENT) > 1.0) {
                    smoothnessCoefficientTextField.setText("1.0");
                }
            }
        });
    }

    private void setSideBarImage(MultiInputDialog dialog) {
        String image = dialog.getBoolean(this.PRESERVE_OUTER_BOUNDARY) && !dialog.getBoolean(this.USE_ATTRIBUTE) ? "simplify_coverage_pob.png" : "simplify_coverage.png";
        dialog.setSideBarImage(new ImageIcon(IconLoader.image(image).getScaledInstance(172, 127, 4)));
    }

    private void getDialogValues(MultiInputDialog dialog) {
        boolean useAttribute = dialog.getBoolean(this.USE_ATTRIBUTE);
        this.addParameter(P_LAYER_NAME, dialog.getLayer(this.LAYER).getName());
        this.addParameter(P_UPDATE_SOURCE, dialog.getBoolean(this.UPDATE_SOURCE));
        this.addParameter(P_SIMPLIFICATION_TOLERANCE, useAttribute ? 0.0 : dialog.getDouble(this.SIMPLIFICATION_TOLERANCE));
        this.addParameter(P_USE_ATTRIBUTE, dialog.getBoolean(this.USE_ATTRIBUTE));
        this.addParameter(P_SIMPLIFICATION_ATTRIBUTE, useAttribute ? dialog.getText(this.ATTRIBUTE) : null);
        this.addParameter(P_SMALL_RINGS_REMOVER_COEFFICIENT, dialog.getDouble(this.SMALL_RINGS_REMOVER_COEFFICIENT));
        this.addParameter(P_PRESERVE_OUTER_BOUNDARY, dialog.getBoolean(this.PRESERVE_OUTER_BOUNDARY));
        this.addParameter(P_SMOOTHNESS_COEFFICIENT, dialog.getDouble(this.SMOOTHNESS_COEFFICIENT));
    }
}

