/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.datastore;

import com.vividsolutions.jump.datastore.AdhocQuery;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.FeatureInputStream;
import com.vividsolutions.jump.io.datasource.Connection;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datastore.ConnectionDescriptor;
import com.vividsolutions.jump.workbench.datastore.ConnectionManager;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.WorkbenchContextReference;
import com.vividsolutions.jump.workbench.ui.plugin.datastore.PasswordPrompter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.operation.union.UnaryUnionOp;

public class DataStoreQueryDataSource
extends DataSource
implements WorkbenchContextReference {
    public static final String DATASET_NAME_KEY = "Dataset Name";
    public static final String SQL_QUERY_KEY = "SQL Query";
    public static final String CONNECTION_DESCRIPTOR_KEY = "Connection Descriptor";
    public static final String PRIMARY_KEY_KEY = "Primary Key";
    public static final Pattern PATTERN_FENCE = Pattern.compile("\\$\\{fence:(-?[0-9]+)\\}");
    public static final Pattern PATTERN_SELECTION = Pattern.compile("\\$\\{selection:(-?[0-9]+)\\}");
    public static final Pattern PATTERN_VIEW = Pattern.compile("\\$\\{view:(-?[0-9]+)\\}");
    private WorkbenchContext context;

    public DataStoreQueryDataSource() {
    }

    public DataStoreQueryDataSource(WorkbenchContext context) {
        this.context = context;
    }

    protected WorkbenchContext getWorkbenchContext() {
        return this.context;
    }

    public DataStoreQueryDataSource(String datasetName, String query, ConnectionDescriptor connectionDescriptor, WorkbenchContext context) {
        this.setProperties(CollectionUtil.createMap(new Object[]{DATASET_NAME_KEY, datasetName, SQL_QUERY_KEY, query, CONNECTION_DESCRIPTOR_KEY, connectionDescriptor}));
        this.setWorkbenchContext(context);
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public Connection getConnection() {
        return new Connection(){

            @Override
            public FeatureCollection executeQuery(String query, Collection<Throwable> exceptions, TaskMonitor monitor) {
                try {
                    return DataStoreQueryDataSource.this.createFeatureCollection();
                }
                catch (Exception e) {
                    exceptions.add(e);
                    return null;
                }
            }

            @Override
            public FeatureCollection executeQuery(String query, TaskMonitor monitor) throws Exception {
                ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
                FeatureCollection featureCollection = this.executeQuery(query, exceptions, monitor);
                if (!exceptions.isEmpty()) {
                    throw (Exception)exceptions.iterator().next();
                }
                return featureCollection;
            }

            @Override
            public void executeUpdate(String query, FeatureCollection featureCollection, TaskMonitor monitor) throws Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FeatureCollection createFeatureCollection() throws Exception {
        FeatureInputStream featureInputStream = null;
        FeatureDataset featureDataset = null;
        ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)this.getProperties().get(CONNECTION_DESCRIPTOR_KEY);
        String query = (String)this.getProperties().get(SQL_QUERY_KEY);
        String driver = connectionDescriptor.getDataStoreDriverClassName();
        if (driver.contains("Postgis") && query.matches("(?s).*\\$\\{[^\\{\\}]*\\}.*")) {
            query = DataStoreQueryDataSource.expandQuery(query, this.context.createPlugInContext());
        }
        AdhocQuery adhocQuery = new AdhocQuery(query);
        if (this.getProperties().get(PRIMARY_KEY_KEY) != null) {
            adhocQuery.setPrimaryKey((String)this.getProperties().get(PRIMARY_KEY_KEY));
        }
        try {
            featureInputStream = ConnectionManager.instance(this.context).getOpenConnection(connectionDescriptor).execute(adhocQuery);
            featureDataset = new FeatureDataset(featureInputStream.getFeatureSchema());
            boolean i = false;
            while (featureInputStream.hasNext()) {
                featureDataset.add(featureInputStream.next());
            }
            FeatureDataset featureDataset2 = featureDataset;
            return featureDataset2;
        }
        catch (Exception e) {
            this.context.getWorkbench().getFrame().handleThrowable(e);
            featureDataset = new FeatureDataset(new FeatureSchema());
        }
        finally {
            if (featureInputStream != null) {
                try {
                    featureInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return featureDataset;
    }

    @Override
    public void setWorkbenchContext(WorkbenchContext context) {
        this.context = context;
        try {
            new PasswordPrompter().getOpenConnection(ConnectionManager.instance(context), (ConnectionDescriptor)this.getProperties().get(CONNECTION_DESCRIPTOR_KEY), context.getWorkbench().getFrame());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static String expandQuery(String query, PlugInContext context) {
        Matcher matcher;
        GeometryFactory gf = new GeometryFactory();
        Geometry viewG = gf.toGeometry(context.getLayerViewPanel().getViewport().getEnvelopeInModelCoordinates());
        Geometry fenceG = context.getLayerViewPanel().getFence();
        Geometry selectionG = DataStoreQueryDataSource.selection(context);
        int lastUsedSRID = context.getLayerManager().getBlackboard().get("SRID", 0);
        String sLastUsedSRID = null;
        if (viewG != null) {
            matcher = PATTERN_VIEW.matcher(query);
            if (matcher.find()) {
                sLastUsedSRID = matcher.group(1);
            }
            matcher.reset();
            query = matcher.replaceAll("ST_GeomFromText('" + viewG.toText() + "',$1)");
        }
        if (fenceG != null) {
            matcher = PATTERN_FENCE.matcher(query);
            if (matcher.find()) {
                sLastUsedSRID = matcher.group(1);
            }
            matcher.reset();
            query = matcher.replaceAll("ST_GeomFromText('" + fenceG.toText() + "',$1)");
        } else {
            matcher = PATTERN_FENCE.matcher(query);
            if (matcher.find()) {
                sLastUsedSRID = matcher.group(1);
            }
            matcher.reset();
            query = matcher.replaceAll("ST_GeomFromText('POLYGON EMPTY',$1)");
        }
        if (selectionG != null) {
            matcher = PATTERN_SELECTION.matcher(query);
            if (matcher.find()) {
                sLastUsedSRID = matcher.group(1);
            }
            matcher.reset();
            query = matcher.replaceAll("ST_GeomFromText('" + selectionG.toText() + "',$1)");
        } else {
            matcher = PATTERN_SELECTION.matcher(query);
            if (matcher.find()) {
                sLastUsedSRID = matcher.group(1);
            }
            matcher.reset();
            query = matcher.replaceAll("ST_GeomFromText('POLYGON EMPTY',$1)");
        }
        if (sLastUsedSRID != null && sLastUsedSRID.matches("-?[0-9]+")) {
            context.getLayerManager().getBlackboard().put("SRID", Integer.parseInt(sLastUsedSRID));
        }
        return query;
    }

    private static Geometry selection(PlugInContext context) {
        Collection<Feature> features = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        if (features.size() > 0) {
            if (features.size() == 1) {
                return features.iterator().next().getGeometry();
            }
            ArrayList<Geometry> selectedGeometries = new ArrayList<Geometry>();
            int max_dim = -1;
            for (Feature feature : features) {
                int dim = feature.getGeometry().getDimension();
                if (dim > max_dim) {
                    max_dim = dim;
                }
                selectedGeometries.add(feature.getGeometry());
            }
            ArrayList<Geometry> homogeneousGeometries = new ArrayList<Geometry>();
            for (Geometry g : selectedGeometries) {
                if (g.getDimension() != max_dim) continue;
                homogeneousGeometries.add(g);
            }
            Geometry geometry = UnaryUnionOp.union(homogeneousGeometries);
            if (!geometry.isEmpty()) {
                return geometry;
            }
            return null;
        }
        return null;
    }
}

