/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.clipboard;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.CollectionOfLayerablesTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.clipboard.LayerableClipboardPlugIn;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;

public class PasteLayersPlugIn
extends LayerableClipboardPlugIn {
    public static final String MUST_NOT_BE_EMPTY = I18N.getInstance().get("ui.plugin.PasteLayersPlugIn.clipboard-must-not-be-empty");
    public static final String MUST_BE_LAYERS = I18N.getInstance().get("ui.plugin.PasteLayersPlugIn.clipboard-must-contain-layers");

    public String getNameWithMnemonic() {
        return StringUtil.replace(this.getName(), "P", "&P", false);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
        if (!transferable.isDataFlavorSupported(CollectionOfLayerablesTransferable.COLLECTION_OF_LAYERABLES_FLAVOR)) {
            return false;
        }
        Collection layerables = (Collection)transferable.getTransferData(CollectionOfLayerablesTransferable.COLLECTION_OF_LAYERABLES_FLAVOR);
        Category selectedCategory = context.getLayerNamePanel().getSelectedCategories().iterator().next();
        for (Layerable layerable : layerables) {
            Layerable clone = this.cloneLayerable(layerable);
            clone.setLayerManager(context.getLayerManager());
            context.getLayerManager().addLayerable(selectedCategory.getName(), clone);
            clone.setName(context.getLayerManager().uniqueLayerName(clone.getName()));
        }
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createExactlyNCategoriesMustBeSelectedCheck(1)).add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Transferable transferable = GUIUtil.getContents(Toolkit.getDefaultToolkit().getSystemClipboard());
                if (transferable == null) {
                    return MUST_NOT_BE_EMPTY;
                }
                if (!transferable.isDataFlavorSupported(CollectionOfLayerablesTransferable.COLLECTION_OF_LAYERABLES_FLAVOR)) {
                    return MUST_BE_LAYERS;
                }
                return null;
            }
        });
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("famfam/page_white_put.png");
    }
}

